/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;
import tech.sirwellington.alchemy.http.exceptions.JsonException;

final class Step2Impl
implements AlchemyRequest.Step2 {
    private static final Logger LOG = LoggerFactory.getLogger(Step2Impl.class);
    private final HttpRequest request;
    private final AlchemyHttpStateMachine stateMachine;
    private final Gson gson;

    Step2Impl(HttpRequest request, AlchemyHttpStateMachine stateMachine, Gson gson) {
        Arguments.checkThat((Object)request, (Object[])new Object[]{stateMachine, gson}).are(Assertions.notNull());
        this.request = request;
        this.stateMachine = stateMachine;
        this.gson = gson;
    }

    @Override
    public AlchemyRequest.Step3 nothing() {
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingBody((JsonElement)JsonNull.INSTANCE).build();
        return this.stateMachine.jumpToStep3(newRequest);
    }

    @Override
    public AlchemyRequest.Step3 body(String jsonString) throws IllegalArgumentException {
        JsonElement jsonBody;
        Arguments.checkThat((Object)jsonString).usingMessage("use 'nothing()' for empty body").is(StringAssertions.nonEmptyString());
        try {
            jsonBody = (JsonElement)this.gson.fromJson(jsonString, JsonElement.class);
        }
        catch (Exception ex) {
            throw new JsonException("Failed to parse JSON Body: " + jsonString, (Throwable)ex);
        }
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingBody(jsonBody).build();
        return this.stateMachine.jumpToStep3(newRequest);
    }

    @Override
    public AlchemyRequest.Step3 body(Object pojo) throws IllegalArgumentException {
        JsonElement jsonBody;
        Arguments.checkThat((Object)pojo).usingMessage("use 'nothing() for empty body").is(Assertions.notNull());
        try {
            jsonBody = this.gson.toJsonTree(pojo);
        }
        catch (Exception ex) {
            LOG.error("Could not convert {} to JSON", pojo, (Object)ex);
            throw new AlchemyHttpException("Could not convert to JSON", (Throwable)ex);
        }
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingBody(jsonBody).build();
        return this.stateMachine.jumpToStep3(newRequest);
    }

    public String toString() {
        return "Step2Impl{request=" + this.request + ", stateMachine=" + this.stateMachine + '}';
    }
}

