/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpVerb;

final class Step1Impl
implements AlchemyRequest.Step1 {
    private static final Logger LOG = LoggerFactory.getLogger(Step1Impl.class);
    private final AlchemyHttpStateMachine stateMachine;
    private final HttpRequest request;

    Step1Impl(AlchemyHttpStateMachine stateMachine, HttpRequest request) {
        Arguments.checkThat((Object)stateMachine, (Object[])new Object[]{request}).are(Assertions.notNull());
        this.stateMachine = stateMachine;
        this.request = request;
    }

    @Override
    public AlchemyRequest.Step3 get() {
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingVerb(HttpVerb.get()).build();
        return this.stateMachine.jumpToStep3(newRequest);
    }

    @Override
    public AlchemyRequest.Step2 post() {
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingVerb(HttpVerb.post()).build();
        return this.stateMachine.jumpToStep2(newRequest);
    }

    @Override
    public AlchemyRequest.Step2 put() {
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingVerb(HttpVerb.put()).build();
        return this.stateMachine.jumpToStep2(newRequest);
    }

    @Override
    public AlchemyRequest.Step2 delete() {
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingVerb(HttpVerb.delete()).build();
        return this.stateMachine.jumpToStep2(newRequest);
    }

    public String toString() {
        return "Step1Impl{stateMachine=" + this.stateMachine + ", request=" + this.request + '}';
    }
}

