/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyRequestMapper;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.HttpVerb;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;
import tech.sirwellington.alchemy.http.exceptions.JsonException;
import tech.sirwellington.alchemy.http.exceptions.OperationFailedException;

@StrategyPattern(role=StrategyPattern.Role.CLIENT)
@Internal
final class HttpVerbImpl
implements HttpVerb {
    private static final Logger LOG = LoggerFactory.getLogger(HttpVerbImpl.class);
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    private final AlchemyRequestMapper requestMapper;

    HttpVerbImpl(AlchemyRequestMapper requestMapper) {
        Arguments.checkThat((Object)requestMapper).is(Assertions.notNull());
        this.requestMapper = requestMapper;
    }

    static HttpVerbImpl using(AlchemyRequestMapper requestMapper) {
        return new HttpVerbImpl(requestMapper);
    }

    @Override
    public HttpResponse execute(HttpClient apacheHttpClient, HttpRequest request) throws AlchemyHttpException {
        JsonElement json;
        org.apache.http.HttpResponse apacheResponse;
        Arguments.checkThat((Object)apacheHttpClient, (Object[])new Object[]{request}).usingMessage("null arguments").are(Assertions.notNull());
        HttpUriRequest apacheRequest = this.requestMapper.convertToApacheRequest(request);
        Arguments.checkThat((Object)apacheRequest).throwing(ex -> new AlchemyHttpException("Could not map HttpRequest: " + request)).is(Assertions.notNull());
        request.getRequestHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequest)apacheRequest).addHeader(arg_0, arg_1));
        try {
            apacheResponse = apacheHttpClient.execute(apacheRequest);
        }
        catch (Exception ex2) {
            LOG.error("Failed to execute GET Request on {}", (Object)apacheRequest.getURI(), (Object)ex2);
            throw new AlchemyHttpException(ex2);
        }
        Arguments.checkThat((Object)apacheResponse).throwing(ex -> new AlchemyHttpException(request, "Missing Apache Client Response")).is(Assertions.notNull());
        try {
            json = this.extractJsonFromResponse(request, apacheResponse);
        }
        catch (JsonParseException ex3) {
            LOG.error("Could not parse Response from Request {} as JSON", (Object)request, (Object)ex3);
            throw new JsonException(request, "Failed to parse Json", (Throwable)ex3);
        }
        catch (Exception ex4) {
            LOG.error("Could not parse Response from Request {}", (Object)request, (Object)ex4);
            throw new OperationFailedException(request, (Throwable)ex4);
        }
        HttpResponse response = HttpResponse.Builder.newInstance().withResponseBody(json).withStatusCode(apacheResponse.getStatusLine().getStatusCode()).withResponseHeaders(this.extractHeadersFrom(apacheResponse)).usingGson(this.gson).build();
        return response;
    }

    private JsonElement extractJsonFromResponse(HttpRequest matchingRequest, org.apache.http.HttpResponse apacheResponse) throws JsonException, JsonParseException {
        if (apacheResponse.getEntity() == null) {
            return JsonNull.INSTANCE;
        }
        HttpEntity entity = apacheResponse.getEntity();
        String contentType = entity.getContentType().getValue();
        Arguments.checkThat((Object)contentType).throwing(JsonException.class).is(HttpAssertions.validContentType());
        String responseString = null;
        try (InputStream istream = entity.getContent();){
            byte[] rawBytes = ByteStreams.toByteArray((InputStream)istream);
            responseString = new String(rawBytes, Charsets.UTF_8);
        }
        catch (Exception ex) {
            LOG.error("Failed to read entity from request", (Throwable)ex);
            throw new AlchemyHttpException(matchingRequest, "Failed to read response from server", (Throwable)ex);
        }
        if (Strings.isNullOrEmpty((String)responseString)) {
            return JsonNull.INSTANCE;
        }
        if (contentType.contains("application/json")) {
            return (JsonElement)this.gson.fromJson(responseString, JsonElement.class);
        }
        return this.gson.toJsonTree((Object)responseString);
    }

    private Map<String, String> extractHeadersFrom(org.apache.http.HttpResponse apacheResponse) {
        if (apacheResponse.getAllHeaders() == null) {
            return Collections.emptyMap();
        }
        return Arrays.asList(apacheResponse.getAllHeaders()).stream().collect(Collectors.toMap(Header::getName, Header::getValue));
    }
}

