/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.nashorn.internal.ir.annotations.Immutable;
import tech.sirwellington.alchemy.annotations.arguments.Nullable;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.exceptions.JsonException;

@Immutable
public interface HttpResponse {
    public int statusCode();

    default public boolean isOk() {
        int statusCode = this.statusCode();
        return statusCode >= 200 && statusCode <= 208 || statusCode == 226;
    }

    @Nullable
    public Map<String, String> responseHeaders();

    public String bodyAsString();

    public JsonElement body() throws JsonException;

    public <T> T bodyAs(Class<T> var1) throws JsonException;

    public <T> List<T> bodyAsArrayOf(Class<T> var1) throws JsonException;

    default public boolean equals(HttpResponse other) {
        if (other == null) {
            return false;
        }
        if (this.statusCode() != other.statusCode()) {
            return false;
        }
        if (!Objects.equals(this.responseHeaders(), other.responseHeaders())) {
            return false;
        }
        return Objects.equals(this.bodyAsString(), other.bodyAsString());
    }

    public static Builder builder() {
        return Builder.newInstance();
    }

    @BuilderPattern(role=BuilderPattern.Role.BUILDER)
    public static class Builder {
        private int statusCode = -100;
        private Map<String, String> responseHeaders = Collections.emptyMap();
        private Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        private JsonElement responseBody = JsonNull.INSTANCE;

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder mergeFrom(HttpResponse other) {
            Arguments.checkThat((Object)other).is(Assertions.notNull());
            return this.withResponseBody(other.body()).withStatusCode(other.statusCode()).withResponseHeaders(other.responseHeaders());
        }

        public Builder withStatusCode(int statusCode) throws IllegalArgumentException {
            Arguments.checkThat((Object)statusCode).is(HttpAssertions.validHttpStatusCode());
            this.statusCode = statusCode;
            return this;
        }

        public Builder withResponseHeaders(Map<String, String> responseHeaders) throws IllegalArgumentException {
            if (responseHeaders == null) {
                responseHeaders = Collections.emptyMap();
            }
            this.responseHeaders = responseHeaders;
            return this;
        }

        public Builder withResponseBody(JsonElement json) throws IllegalArgumentException {
            Arguments.checkThat((Object)json).is(Assertions.notNull());
            this.responseBody = json;
            return this;
        }

        public Builder usingGson(Gson gson) throws IllegalArgumentException {
            Arguments.checkThat((Object)gson).is(Assertions.notNull());
            this.gson = gson;
            return this;
        }

        public HttpResponse build() throws IllegalStateException {
            Arguments.checkThat((Object)this.statusCode).throwing(ex -> new IllegalStateException("No status code supplied")).is(HttpAssertions.validHttpStatusCode());
            Arguments.checkThat((Object)this.responseBody).usingMessage("missing Response Body").is(Assertions.notNull());
            return new Impl(this.statusCode, Collections.unmodifiableMap(this.responseHeaders), this.gson, this.responseBody);
        }

        @Immutable
        @BuilderPattern(role=BuilderPattern.Role.PRODUCT)
        private static class Impl
        implements HttpResponse {
            private final int statusCode;
            private final Map<String, String> responseHeaders;
            private final Gson gson;
            private final JsonElement responseBody;

            private Impl(int statusCode, Map<String, String> responseHeaders, Gson gson, JsonElement response) {
                this.statusCode = statusCode;
                this.responseHeaders = responseHeaders;
                this.gson = gson;
                this.responseBody = response;
            }

            @Override
            public int statusCode() {
                return this.statusCode;
            }

            @Override
            public Map<String, String> responseHeaders() {
                return this.responseHeaders;
            }

            @Override
            public String bodyAsString() {
                if (this.responseBody.isJsonPrimitive()) {
                    return this.responseBody.getAsString();
                }
                return this.responseBody.toString();
            }

            @Override
            public JsonElement body() throws JsonParseException {
                JsonElement copy = this.gson.toJsonTree((Object)this.responseBody);
                return copy;
            }

            @Override
            public <T> T bodyAs(Class<T> classOfT) throws JsonParseException {
                Arguments.checkThat(classOfT).is(HttpAssertions.validResponseClass());
                try {
                    Object instance = this.gson.fromJson(this.responseBody, classOfT);
                    return (T)instance;
                }
                catch (Exception ex) {
                    throw new JsonException("Failed to parse json to class: " + classOfT, (Throwable)ex);
                }
            }

            @Override
            public <T> List<T> bodyAsArrayOf(Class<T> classOfT) throws JsonException {
                Arguments.checkThat(classOfT).is(HttpAssertions.validResponseClass());
                Object[] array = (Object[])Array.newInstance(classOfT, 0);
                Class<?> arrayClass = array.getClass();
                try {
                    array = (Object[])this.gson.fromJson(this.responseBody, arrayClass);
                    return array == null ? Collections.emptyList() : Arrays.asList(array);
                }
                catch (Exception ex) {
                    throw new JsonException("Failed to parse json to class: " + classOfT, (Throwable)ex);
                }
            }

            public int hashCode() {
                int hash = 3;
                hash = 41 * hash + this.statusCode;
                hash = 41 * hash + Objects.hashCode(this.responseHeaders);
                hash = 41 * hash + Objects.hashCode(this.responseBody);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof HttpResponse)) {
                    return false;
                }
                return this.equals((HttpResponse)obj);
            }

            public String toString() {
                return "HttpResponse{statusCode=" + this.statusCode + ", responseHeaders=" + this.responseHeaders + ", response=" + this.responseBody + '}';
            }
        }
    }
}

