/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.annotations.concurrency.Mutable;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.http.HttpVerb;

@Immutable
@BuilderPattern(role=BuilderPattern.Role.PRODUCT)
public interface HttpRequest {
    public Map<String, String> getRequestHeaders();

    public Map<String, String> getQueryParams();

    public URL getUrl();

    public JsonElement getBody();

    public HttpVerb getVerb();

    default public boolean hasBody() {
        return this.getBody() != null;
    }

    default public boolean hasQueryParams() {
        Map<String, String> queryParams = this.getQueryParams();
        return queryParams != null && !queryParams.isEmpty();
    }

    default public boolean equals(HttpRequest other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!Objects.equals(this.getRequestHeaders(), other.getRequestHeaders())) {
            return false;
        }
        if (!Objects.equals(this.getQueryParams(), other.getQueryParams())) {
            return false;
        }
        if (!Objects.equals(this.getUrl(), other.getUrl())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        return Objects.equals(this.getVerb(), other.getVerb());
    }

    public static HttpRequest copyOf(HttpRequest other) {
        return Builder.from(other).build();
    }

    @BuilderPattern(role=BuilderPattern.Role.BUILDER)
    @Mutable
    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(HttpRequest.class);
        private Map<String, String> requestHeaders = Maps.newHashMap();
        private Map<String, String> queryParams = Maps.newHashMap();
        private URL url;
        private JsonElement body;
        private HttpVerb verb;

        public static Builder newInstance() {
            return new Builder();
        }

        public static Builder from(HttpRequest other) {
            Builder builder = Builder.newInstance();
            if (other == null) {
                return builder;
            }
            builder.url = other.getUrl();
            if (other.getRequestHeaders() != null) {
                builder.requestHeaders = Maps.newHashMap(other.getRequestHeaders());
            }
            if (other.getQueryParams() != null) {
                builder.queryParams = Maps.newHashMap(other.getQueryParams());
            }
            builder.body = other.getBody();
            builder.verb = other.getVerb();
            return builder;
        }

        public Builder usingRequestHeaders(Map<String, String> requestHeaders) throws IllegalArgumentException {
            Arguments.checkThat(requestHeaders).is(CollectionAssertions.nonEmptyMap());
            this.requestHeaders.clear();
            this.requestHeaders.putAll(requestHeaders);
            return this;
        }

        public Builder usingQueryParams(Map<String, String> queryParams) throws IllegalArgumentException {
            Arguments.checkThat(queryParams).is(CollectionAssertions.nonEmptyMap());
            this.queryParams.clear();
            this.queryParams.putAll(queryParams);
            return this;
        }

        public Builder usingUrl(URL url) throws IllegalArgumentException {
            Arguments.checkThat((Object)url).is(Assertions.notNull());
            this.url = url;
            return this;
        }

        public Builder usingBody(JsonElement body) {
            Arguments.checkThat((Object)body).usingMessage("Use JsonNull instead of null").is(Assertions.notNull());
            this.body = body;
            return this;
        }

        public Builder usingVerb(HttpVerb verb) throws IllegalArgumentException {
            Arguments.checkThat((Object)verb).usingMessage("missing verb").is(Assertions.notNull());
            this.verb = verb;
            return this;
        }

        public HttpRequest build() throws IllegalArgumentException {
            Impl instance = new Impl();
            instance.requestHeaders = (Map)ImmutableMap.copyOf(this.requestHeaders);
            instance.queryParams = (Map)ImmutableMap.copyOf(this.queryParams);
            instance.body = this.body;
            instance.url = this.url;
            instance.verb = this.verb;
            return instance;
        }

        public String toString() {
            return "Builder{requestHeaders=" + this.requestHeaders + ", queryParams=" + this.queryParams + ", url=" + this.url + ", body=" + this.body + ", verb=" + this.verb + '}';
        }

        @Immutable
        @BuilderPattern(role=BuilderPattern.Role.PRODUCT)
        private static class Impl
        implements HttpRequest {
            private Map<String, String> requestHeaders;
            private Map<String, String> queryParams;
            private URL url;
            private JsonElement body;
            private HttpVerb verb;

            private Impl() {
            }

            @Override
            public Map<String, String> getRequestHeaders() {
                return this.requestHeaders;
            }

            @Override
            public Map<String, String> getQueryParams() {
                return this.queryParams;
            }

            @Override
            public URL getUrl() {
                return this.url;
            }

            @Override
            public JsonElement getBody() {
                return this.body;
            }

            @Override
            public HttpVerb getVerb() {
                return this.verb;
            }

            public int hashCode() {
                int hash = 7;
                hash = 83 * hash + Objects.hashCode(this.requestHeaders);
                hash = 83 * hash + Objects.hashCode(this.queryParams);
                hash = 83 * hash + Objects.hashCode(this.url);
                hash = 83 * hash + Objects.hashCode(this.body);
                hash = 83 * hash + Objects.hashCode(this.verb);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof HttpRequest)) {
                    return false;
                }
                return this.equals((HttpRequest)obj);
            }

            public String toString() {
                return "Impl{requestHeaders=" + this.requestHeaders + ", queryParams=" + this.queryParams + ", url=" + this.url + ", body=" + this.body + ", verb=" + this.verb + '}';
            }
        }
    }
}

