/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.gson.JsonElement;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpResponse;

@NonInstantiable
@Internal
final class HttpAssertions {
    private HttpAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    static AlchemyAssertion<Integer> validHttpStatusCode() {
        return NumberAssertions.greaterThanOrEqualTo((int)100).and(NumberAssertions.lessThanOrEqualTo((int)505));
    }

    static <Response> AlchemyAssertion<Class<Response>> validResponseClass() {
        AlchemyAssertion notNull = Assertions.notNull();
        return notNull.and(Assertions.not((AlchemyAssertion)Assertions.sameInstanceAs(Void.class)));
    }

    static AlchemyAssertion<HttpRequest> requestReady() {
        return request -> {
            Arguments.checkThat((Object)request).usingMessage("Request missing").is(Assertions.notNull());
            Arguments.checkThat((Object)request.getVerb()).usingMessage("Request missing HTTP Verb").is(Assertions.notNull());
            Arguments.checkThat((Object)request.getUrl()).usingMessage("Request missing URL").is(Assertions.notNull());
            Arguments.checkThat((Object)request.getUrl().getProtocol()).is(StringAssertions.stringBeginningWith((String)"http"));
        };
    }

    static AlchemyAssertion<String> validContentType() {
        return contentType -> {
            Arguments.checkThat((Object)contentType).usingMessage("missing Content-Type").is(StringAssertions.nonEmptyString());
            if (contentType.contains("application/json")) {
                return;
            }
            if (contentType.contains("text/plain")) {
                return;
            }
            throw new FailedAssertionException("Not a valid JSON content Type: " + contentType);
        };
    }

    static AlchemyAssertion<HttpRequest> notNullAndHasURL() {
        return request -> {
            Arguments.checkThat((Object)request).usingMessage("missing HTTP Request").is(Assertions.notNull());
            Arguments.checkThat((Object)request.getUrl()).usingMessage("missing request URL").is(Assertions.notNull());
        };
    }

    static AlchemyAssertion<JsonElement> jsonArray() {
        return json -> {
            Arguments.checkThat((Object)json).is(Assertions.notNull());
            if (!json.isJsonArray()) {
                throw new FailedAssertionException("Expecting JSON Array, instead: " + json);
            }
        };
    }

    static AlchemyAssertion<HttpResponse> okResponse() {
        return response -> {
            Arguments.checkThat((Object)response).is(Assertions.notNull());
            if (!response.isOk()) {
                throw new FailedAssertionException("Http Response not OK. Status Code: " + response.statusCode());
            }
        };
    }
}

