/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.base.Charsets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@StrategyPattern(role=StrategyPattern.Role.INTERFACE)
@Internal
interface AlchemyRequestMapper {
    @StrategyPattern(role=StrategyPattern.Role.CLIENT)
    public static final AlchemyRequestMapper GET = request -> {
        Arguments.checkThat((Object)request).is(HttpAssertions.notNullAndHasURL());
        try {
            URL url = AlchemyRequestMapper.expandUrlFromRequest(request);
            HttpGet get = new HttpGet(url.toURI());
            return get;
        }
        catch (Exception ex) {
            throw new AlchemyHttpException(request, "Could not convert to Apache GET Request", (Throwable)ex);
        }
    };
    public static final AlchemyRequestMapper POST = request -> {
        Arguments.checkThat((Object)request).is(HttpAssertions.notNullAndHasURL());
        try {
            URL url = AlchemyRequestMapper.expandUrlFromRequest(request);
            HttpPost post = new HttpPost(url.toURI());
            if (request.hasBody()) {
                StringEntity entity = new StringEntity(request.getBody().toString(), Charsets.UTF_8);
                post.setEntity((HttpEntity)entity);
            }
            return post;
        }
        catch (Exception ex) {
            throw new AlchemyHttpException(request, "Could not convert to Apache POST Request", (Throwable)ex);
        }
    };
    public static final AlchemyRequestMapper PUT = request -> {
        Arguments.checkThat((Object)request).is(HttpAssertions.notNullAndHasURL());
        try {
            URL url = AlchemyRequestMapper.expandUrlFromRequest(request);
            HttpPut put = new HttpPut(url.toURI());
            if (request.hasBody()) {
                StringEntity entity = new StringEntity(request.getBody().toString(), Charsets.UTF_8);
                put.setEntity((HttpEntity)entity);
            }
            return put;
        }
        catch (Exception ex) {
            throw new AlchemyHttpException(request, "Could not convert to Apache PUT Request", (Throwable)ex);
        }
    };
    public static final AlchemyRequestMapper DELETE = request -> {
        Arguments.checkThat((Object)request).is(HttpAssertions.notNullAndHasURL());
        try {
            URL url = AlchemyRequestMapper.expandUrlFromRequest(request);
            if (request.hasBody()) {
                HttpDeleteWithBody delete = new HttpDeleteWithBody(url.toURI());
                StringEntity entity = new StringEntity(request.getBody().toString(), Charsets.UTF_8);
                delete.setEntity((HttpEntity)entity);
                return delete;
            }
            return new HttpDelete(url.toURI());
        }
        catch (Exception ex) {
            throw new AlchemyHttpException(request, "Could not convert to Apache DELETE Request", (Throwable)ex);
        }
    };

    public HttpUriRequest convertToApacheRequest(@NonNull HttpRequest var1) throws AlchemyHttpException;

    @Internal
    public static URL expandUrlFromRequest(@NonNull HttpRequest request) throws URISyntaxException, MalformedURLException {
        Arguments.checkThat((Object)request).is(HttpAssertions.notNullAndHasURL());
        if (!request.hasQueryParams()) {
            return request.getUrl();
        }
        URI uri = request.getUrl().toURI();
        URIBuilder uriBuilder = new URIBuilder(uri);
        request.getQueryParams().forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
        return uriBuilder.build().toURL();
    }

    @Internal
    public static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = new HttpDelete().getMethod();

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody() {
        }
    }
}

