/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.annotations.designs.StepMachineDesign;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@FluidAPIDesign
@StepMachineDesign
public interface AlchemyRequest {

    @FunctionalInterface
    public static interface OnFailure {
        public static final OnFailure NO_OP = ex -> {};

        public void handleError(AlchemyHttpException var1);
    }

    @FunctionalInterface
    public static interface OnSuccess<ResponseType> {
        public static final OnSuccess NO_OP = response -> {};

        public void processResponse(ResponseType var1);
    }

    public static interface Step6<ResponseType> {
        public void at(URL var1);

        default public void at(String url) throws IllegalArgumentException, MalformedURLException {
            Arguments.checkThat((Object)url).is(StringAssertions.nonEmptyString());
            this.at(new URL(url));
        }
    }

    public static interface Step5<ResponseType> {
        public Step6<ResponseType> onFailure(OnFailure var1);
    }

    public static interface Step4<ResponseType> {
        public ResponseType at(URL var1) throws IllegalArgumentException, AlchemyHttpException;

        default public ResponseType at(String url) throws AlchemyHttpException, MalformedURLException {
            Arguments.checkThat((Object)url).is(StringAssertions.nonEmptyString());
            return this.at(new URL(url));
        }

        public Step5<ResponseType> onSuccess(OnSuccess<ResponseType> var1);
    }

    public static interface Step3 {
        public Step3 usingHeader(String var1, String var2) throws IllegalArgumentException;

        public Step3 usingQueryParam(String var1, String var2) throws IllegalArgumentException;

        default public Step3 accept(String mediaType, String ... others) throws IllegalArgumentException {
            Arguments.checkThat((Object)mediaType).is(StringAssertions.nonEmptyString());
            LinkedHashSet contentTypes = Sets.newLinkedHashSet();
            contentTypes.add(mediaType);
            if (others != null && others.length > 0) {
                for (String element : others) {
                    contentTypes.add(element);
                }
            }
            String accepts = Joiner.on((String)",").join((Iterable)contentTypes);
            return this.usingHeader("Accept", accepts);
        }

        default public Step3 usingQueryParam(String name, Number value) throws IllegalArgumentException {
            return this.usingQueryParam(name, String.valueOf(value));
        }

        default public Step3 usingQueryParam(String name, boolean value) throws IllegalArgumentException {
            return this.usingQueryParam(name, String.valueOf(value));
        }

        public Step3 followRedirects(int var1) throws IllegalArgumentException;

        default public Step3 followRedirects() {
            return this.followRedirects(5);
        }

        public HttpResponse at(URL var1) throws AlchemyHttpException;

        default public HttpResponse at(String url) throws IllegalArgumentException, AlchemyHttpException, MalformedURLException {
            Arguments.checkThat((Object)url).is(StringAssertions.nonEmptyString());
            return this.at(new URL(url));
        }

        public Step5<HttpResponse> onSuccess(OnSuccess<HttpResponse> var1);

        public <ResponseType> Step4<ResponseType> expecting(Class<ResponseType> var1) throws IllegalArgumentException;
    }

    public static interface Step2 {
        public Step3 nothing();

        public Step3 body(@NonEmpty String var1) throws IllegalArgumentException;

        public Step3 body(@NonNull Object var1) throws IllegalArgumentException;
    }

    public static interface Step1 {
        default public byte[] download(@NonNull URL url) throws IllegalArgumentException, AlchemyHttpException {
            Arguments.checkThat((Object)url).usingMessage("missing URL").is(Assertions.notNull());
            try {
                return Resources.toByteArray((URL)url);
            }
            catch (Exception ex) {
                throw new AlchemyHttpException("Could not download from URL" + url, (Throwable)ex);
            }
        }

        public Step3 get();

        public Step2 post();

        public Step2 put();

        public Step2 delete();
    }
}

