/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.gson.Gson;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.HttpVerb;
import tech.sirwellington.alchemy.http.Step1Impl;
import tech.sirwellington.alchemy.http.Step2Impl;
import tech.sirwellington.alchemy.http.Step3Impl;
import tech.sirwellington.alchemy.http.Step4Impl;
import tech.sirwellington.alchemy.http.Step5Impl;
import tech.sirwellington.alchemy.http.Step6Impl;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@Internal
final class AlchemyMachineImpl
implements AlchemyHttpStateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(AlchemyMachineImpl.class);
    private final HttpClient apacheHttpClient;
    private final ExecutorService async;
    private final Gson gson;

    AlchemyMachineImpl(HttpClient apacheHttpClient, ExecutorService async, Gson gson) {
        Arguments.checkThat((Object)apacheHttpClient, (Object[])new Object[]{async, gson}).are(Assertions.notNull());
        this.apacheHttpClient = apacheHttpClient;
        this.async = async;
        this.gson = gson;
    }

    @Override
    public AlchemyRequest.Step1 begin(HttpRequest initialRequest) throws IllegalArgumentException {
        Arguments.checkThat((Object)initialRequest).is(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.copyOf(initialRequest);
        LOG.debug("Beginning HTTP request {}", (Object)requestCopy);
        return new Step1Impl(this, requestCopy);
    }

    @Override
    public AlchemyRequest.Step2 jumpToStep2(HttpRequest request) throws IllegalArgumentException {
        Arguments.checkThat((Object)request).is(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.copyOf(request);
        return new Step2Impl(requestCopy, this, this.gson);
    }

    @Override
    public AlchemyRequest.Step3 jumpToStep3(HttpRequest request) throws IllegalArgumentException {
        Arguments.checkThat((Object)request).is(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.copyOf(request);
        return new Step3Impl(this, requestCopy);
    }

    @Override
    public <ResponseType> AlchemyRequest.Step4<ResponseType> jumpToStep4(HttpRequest request, Class<ResponseType> classOfResponseType) throws IllegalArgumentException {
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        HttpRequest requestCopy = HttpRequest.copyOf(request);
        return new Step4Impl<ResponseType>(this, requestCopy, classOfResponseType);
    }

    @Override
    public <ResponseType> AlchemyRequest.Step5<ResponseType> jumpToStep5(HttpRequest request, Class<ResponseType> classOfResponseType, AlchemyRequest.OnSuccess<ResponseType> successCallback) throws IllegalArgumentException {
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        Arguments.checkThat((Object)request, (Object[])new Object[]{successCallback}).are(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.copyOf(request);
        return new Step5Impl<ResponseType>(this, requestCopy, classOfResponseType, successCallback);
    }

    @Override
    public <ResponseType> AlchemyRequest.Step6<ResponseType> jumpToStep6(HttpRequest request, Class<ResponseType> classOfResponseType, AlchemyRequest.OnSuccess<ResponseType> successCallback, AlchemyRequest.OnFailure failureCallback) {
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        Arguments.checkThat((Object)request, (Object[])new Object[]{successCallback, failureCallback}).are(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.copyOf(request);
        return new Step6Impl<ResponseType>(this, requestCopy, classOfResponseType, successCallback, failureCallback);
    }

    @Override
    public <ResponseType> ResponseType executeSync(HttpRequest request, Class<ResponseType> classOfResponseType) {
        HttpResponse response;
        LOG.debug("Executing synchronous HTTP Request {}", (Object)request);
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        Arguments.checkThat((Object)request).is(Assertions.notNull()).is(HttpAssertions.requestReady());
        HttpVerb verb = request.getVerb();
        try {
            response = verb.execute(this.apacheHttpClient, request);
        }
        catch (AlchemyHttpException ex2) {
            LOG.info("Encountered AlchemyHttpException when running verb {} on request {}", new Object[]{verb, request, ex2});
            throw ex2;
        }
        catch (Exception ex3) {
            LOG.error("Failed to execute verb {} on request {}", new Object[]{verb, request, ex3});
            throw new AlchemyHttpException(request, (Throwable)ex3);
        }
        Arguments.checkThat((Object)response).throwing(ex -> new AlchemyHttpException(request, "HTTP Verb returned null response")).is(Assertions.notNull());
        Arguments.checkThat((Object)response).throwing(ex -> new AlchemyHttpException(request, response, "Http Response not OK. Status Code: " + response.statusCode())).is(HttpAssertions.okResponse());
        LOG.debug("HTTP Request {} successfully executed: {}", (Object)request, (Object)response);
        if (classOfResponseType == HttpResponse.class) {
            return (ResponseType)response;
        }
        if (classOfResponseType == String.class) {
            return (ResponseType)response.bodyAsString();
        }
        LOG.trace("Attempting to parse response {} as {}", (Object)response, classOfResponseType);
        return response.bodyAs(classOfResponseType);
    }

    @Override
    public <ResponseType> void executeAsync(HttpRequest request, Class<ResponseType> classOfResponseType, AlchemyRequest.OnSuccess<ResponseType> successCallback, AlchemyRequest.OnFailure failureCallback) {
        Arguments.checkThat((Object)request).is(Assertions.notNull()).is(HttpAssertions.requestReady());
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        Arguments.checkThat(successCallback, (Object[])new Object[]{failureCallback}).are(Assertions.notNull());
        LOG.debug("Submitting Async HTTP Request {}", (Object)request);
        Runnable asyncTask = () -> {
            Object response;
            LOG.debug("Starting Async HTTP Request {}", (Object)request);
            try {
                response = this.executeSync(request, classOfResponseType);
                Arguments.checkThat(response).throwing(ex -> new IllegalStateException("Received unexpected null response")).is(Assertions.notNull());
            }
            catch (AlchemyHttpException ex2) {
                LOG.trace("Async request failed", (Throwable)ex2);
                failureCallback.handleError(ex2);
                return;
            }
            catch (Exception ex3) {
                LOG.trace("Async request failed", (Throwable)ex3);
                failureCallback.handleError(new AlchemyHttpException(ex3));
                return;
            }
            try {
                successCallback.processResponse(response);
            }
            catch (Exception ex4) {
                String message = "Success Callback threw exception";
                LOG.warn(message, (Throwable)ex4);
                failureCallback.handleError(new AlchemyHttpException(message, (Throwable)ex4));
            }
        };
        this.async.submit(asyncTask);
    }

    public String toString() {
        return "AlchemyMachineImpl{apacheHttpClient=" + this.apacheHttpClient + ", async=" + this.async + ", gson=" + this.gson + '}';
    }
}

