/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyMachineImpl;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.Constants;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@Internal
interface AlchemyHttpStateMachine {
    default public AlchemyRequest.Step1 begin() {
        HttpRequest request = HttpRequest.Builder.newInstance().build();
        return this.begin(request);
    }

    public AlchemyRequest.Step1 begin(HttpRequest var1);

    public AlchemyRequest.Step2 jumpToStep2(HttpRequest var1) throws IllegalArgumentException;

    public AlchemyRequest.Step3 jumpToStep3(HttpRequest var1) throws IllegalArgumentException;

    public <ResponseType> AlchemyRequest.Step4<ResponseType> jumpToStep4(HttpRequest var1, Class<ResponseType> var2) throws IllegalArgumentException;

    public <ResponseType> AlchemyRequest.Step5<ResponseType> jumpToStep5(HttpRequest var1, Class<ResponseType> var2, AlchemyRequest.OnSuccess<ResponseType> var3) throws IllegalArgumentException;

    public <ResponseType> AlchemyRequest.Step6<ResponseType> jumpToStep6(HttpRequest var1, Class<ResponseType> var2, AlchemyRequest.OnSuccess<ResponseType> var3, AlchemyRequest.OnFailure var4);

    default public HttpResponse executeSync(HttpRequest request) throws AlchemyHttpException {
        return this.executeSync(request, HttpResponse.class);
    }

    public <ResponseType> ResponseType executeSync(HttpRequest var1, Class<ResponseType> var2) throws AlchemyHttpException;

    public <ResponseType> void executeAsync(HttpRequest var1, Class<ResponseType> var2, AlchemyRequest.OnSuccess<ResponseType> var3, AlchemyRequest.OnFailure var4);

    public static class Builder {
        private HttpClient apacheHttpClient;
        private ExecutorService executor = MoreExecutors.newDirectExecutorService();
        private final Gson gson = Constants.getDefaultGson();

        static Builder newInstance() {
            return new Builder();
        }

        Builder usingExecutorService(ExecutorService executor) throws IllegalArgumentException {
            Arguments.checkThat((Object)executor).is(Assertions.notNull());
            this.executor = executor;
            return this;
        }

        Builder usingApacheHttpClient(HttpClient apacheHttpClient) throws IllegalArgumentException {
            Arguments.checkThat((Object)apacheHttpClient).is(Assertions.notNull());
            this.apacheHttpClient = apacheHttpClient;
            return this;
        }

        AlchemyHttpStateMachine build() throws IllegalStateException {
            Arguments.checkThat((Object)this.apacheHttpClient).throwing(ex -> new IllegalStateException("missing Apache HTTP Client")).is(Assertions.notNull());
            return new AlchemyMachineImpl(this.apacheHttpClient, this.executor, this.gson);
        }
    }
}

