/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttp;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpRequest;

@Internal
@BuilderPattern(role=BuilderPattern.Role.PRODUCT)
@ThreadSafe
final class AlchemyHttpImpl
implements AlchemyHttp {
    @Immutable
    private final Map<String, String> defaultHeaders;
    private final AlchemyHttpStateMachine stateMachine;

    AlchemyHttpImpl(Map<String, String> defaultHeaders, AlchemyHttpStateMachine stateMachine) {
        Arguments.checkThat(defaultHeaders, (Object[])new Object[]{stateMachine}).are(Assertions.notNull());
        this.defaultHeaders = ImmutableMap.copyOf(defaultHeaders);
        this.stateMachine = stateMachine;
    }

    @Override
    public AlchemyHttp usingDefaultHeader(String key, String value) {
        Arguments.checkThat((Object)key).usingMessage("Key is empty").is(StringAssertions.nonEmptyString());
        HashMap copy = Maps.newHashMap(this.defaultHeaders);
        copy.put(key, value);
        return new AlchemyHttpImpl(copy, this.stateMachine);
    }

    @Override
    public AlchemyRequest.Step1 go() {
        HttpRequest initialRequest = HttpRequest.Builder.newInstance().usingRequestHeaders(this.defaultHeaders).build();
        return this.stateMachine.begin(initialRequest);
    }

    public String toString() {
        return "AlchemyHttp{defaultHeaders=" + this.defaultHeaders + ", stateMachine=" + this.stateMachine + '}';
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }
}

