/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttp;
import tech.sirwellington.alchemy.http.AlchemyHttpImpl;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.Constants;

@BuilderPattern(role=BuilderPattern.Role.BUILDER)
public final class AlchemyHttpBuilder {
    private static final HttpClient DEFAULT_APACHE_CLIENT = HttpClientBuilder.create().build();
    private HttpClient apacheHttpClient = DEFAULT_APACHE_CLIENT;
    private ExecutorService executor = MoreExecutors.newDirectExecutorService();
    private final Map<String, String> defaultHeaders = Maps.newHashMap(Constants.DEFAULT_HEADERS);

    static AlchemyHttpBuilder newInstance() {
        return new AlchemyHttpBuilder();
    }

    AlchemyHttpBuilder() {
    }

    public AlchemyHttpBuilder usingApacheHttpClient(HttpClient apacheHttpClient) throws IllegalArgumentException {
        Arguments.checkThat((Object)apacheHttpClient).is(Assertions.notNull());
        this.apacheHttpClient = apacheHttpClient;
        return this;
    }

    public AlchemyHttpBuilder usingExecutorService(ExecutorService executor) throws IllegalArgumentException {
        Arguments.checkThat((Object)executor).is(Assertions.notNull());
        this.executor = executor;
        return this;
    }

    public AlchemyHttpBuilder enableAsyncCallbacks() {
        return this.usingExecutorService(Executors.newSingleThreadExecutor());
    }

    public AlchemyHttpBuilder disableAsyncCallbacks() {
        return this.usingExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());
    }

    public AlchemyHttpBuilder usingDefaultHeaders(@NonNull Map<String, String> defaultHeaders) throws IllegalArgumentException {
        Arguments.checkThat(defaultHeaders).is(Assertions.notNull());
        this.defaultHeaders.clear();
        this.defaultHeaders.putAll(defaultHeaders);
        return this;
    }

    public AlchemyHttpBuilder usingDefaultHeader(@NonEmpty String key, String value) throws IllegalArgumentException {
        Arguments.checkThat((Object)key).usingMessage("missing key").is(StringAssertions.nonEmptyString());
        this.defaultHeaders.put(key, value);
        return this;
    }

    public AlchemyHttp build() throws IllegalStateException {
        Arguments.checkThat((Object)this.apacheHttpClient).throwing(ex -> new IllegalStateException("missing apache HTTP Client")).is(Assertions.notNull());
        Arguments.checkThat((Object)this.executor).throwing(ex -> new IllegalStateException("missing Executor Service")).is(Assertions.notNull());
        AlchemyHttpStateMachine stateMachine = this.buildTheStateMachine();
        return new AlchemyHttpImpl(this.defaultHeaders, stateMachine);
    }

    private AlchemyHttpStateMachine buildTheStateMachine() {
        return AlchemyHttpStateMachine.Builder.newInstance().usingApacheHttpClient(this.apacheHttpClient).usingExecutorService(this.executor).build();
    }
}

