/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpBuilder;
import tech.sirwellington.alchemy.http.AlchemyRequest;

@Immutable
@ThreadSafe
@FluidAPIDesign
@BuilderPattern(role=BuilderPattern.Role.PRODUCT)
public interface AlchemyHttp {
    public AlchemyHttp usingDefaultHeader(@NonEmpty String var1, String var2);

    @NonNull
    public Map<String, String> getDefaultHeaders();

    public AlchemyRequest.Step1 go();

    public static AlchemyHttp newDefaultInstance() {
        CloseableHttpClient apacheHttpClient = HttpClientBuilder.create().build();
        return AlchemyHttp.newInstanceWithApacheHttpClient((HttpClient)apacheHttpClient);
    }

    public static AlchemyHttp newInstanceWithApacheHttpClient(@NonNull HttpClient apacheHttpClient) throws IllegalArgumentException {
        return AlchemyHttpBuilder.newInstance().usingApacheHttpClient(apacheHttpClient).build();
    }

    public static AlchemyHttp newInstance(HttpClient apacheHttpClient, ExecutorService executorService, Map<String, String> defaultHeaders) throws IllegalArgumentException {
        Arguments.checkThat((Object)apacheHttpClient).usingMessage("missing Apache HTTP Client").is(Assertions.notNull());
        Arguments.checkThat((Object)executorService).usingMessage("missing ExecutorService").is(Assertions.notNull());
        Arguments.checkThat(defaultHeaders).usingMessage("Default HTTP Headers cannot be null. Use an empty map instead.").is(Assertions.notNull());
        return AlchemyHttpBuilder.newInstance().usingApacheHttpClient(apacheHttpClient).usingExecutorService(executorService).usingDefaultHeaders(defaultHeaders).build();
    }

    public static AlchemyHttpBuilder newBuilder() {
        return AlchemyHttpBuilder.newInstance();
    }
}

