/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.services;

import java.util.function.Supplier;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.CreateTokenRequest;
import tech.aroma.thrift.authentication.service.CreateTokenResponse;
import tech.aroma.thrift.authentication.service.GetTokenInfoRequest;
import tech.aroma.thrift.authentication.service.GetTokenInfoResponse;
import tech.aroma.thrift.authentication.service.InvalidateTokenRequest;
import tech.aroma.thrift.authentication.service.InvalidateTokenResponse;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.authentication.service.VerifyTokenResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.thrift.clients.Clients;

@Internal
@ThreadSafe
@DecoratorPattern(role=DecoratorPattern.Role.DECORATOR)
final class PerRequestAuthenticationService
implements AuthenticationService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(PerRequestAuthenticationService.class);
    private final Supplier<AuthenticationService.Iface> clientProvider;

    PerRequestAuthenticationService(Supplier<AuthenticationService.Iface> clientProvider) {
        Arguments.checkThat(clientProvider).is(Assertions.notNull());
        Arguments.checkThat((Object)clientProvider.get()).usingMessage("clientProvider returned null").is(Assertions.notNull());
        this.clientProvider = clientProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getApiVersion() throws TException {
        AuthenticationService.Iface client = this.clientProvider.get();
        try {
            double d = client.getApiVersion();
            return d;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTokenResponse createToken(CreateTokenRequest request) throws OperationFailedException, InvalidArgumentException, TException {
        AuthenticationService.Iface client = this.clientProvider.get();
        try {
            CreateTokenResponse createTokenResponse = client.createToken(request);
            return createTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTokenInfoResponse getTokenInfo(GetTokenInfoRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        AuthenticationService.Iface client = this.clientProvider.get();
        try {
            GetTokenInfoResponse getTokenInfoResponse = client.getTokenInfo(request);
            return getTokenInfoResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvalidateTokenResponse invalidateToken(InvalidateTokenRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        AuthenticationService.Iface client = this.clientProvider.get();
        try {
            InvalidateTokenResponse invalidateTokenResponse = client.invalidateToken(request);
            return invalidateTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyTokenResponse verifyToken(VerifyTokenRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        AuthenticationService.Iface client = this.clientProvider.get();
        try {
            VerifyTokenResponse verifyTokenResponse = client.verifyToken(request);
            return verifyTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }
}

