/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.functions;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.TimeUnit;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;

@NonInstantiable
public final class TimeFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(TimeFunctions.class);
    public static final Function<TimeUnit, ChronoUnit> TIME_UNIT_TO_CHRONO_UNIT = t -> {
        Arguments.checkThat((Object)t).usingMessage("missing time unit").is(Assertions.notNull());
        switch (t) {
            case MILLIS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case WEEKS: {
                return ChronoUnit.WEEKS;
            }
        }
        throw new IllegalArgumentException("Unexpected Time Unit: " + (Object)t);
    };
    public static final Function<LengthOfTime, Duration> LENGTH_OF_TIME_TO_DURATION = t -> {
        Arguments.checkThat((Object)t).is(Assertions.notNull());
        Arguments.checkThat((Object)((Object)t.unit)).usingMessage("missing time unit").is(Assertions.notNull());
        Arguments.checkThat((Object)t.value).usingMessage("time value must be >= 0").is(NumberAssertions.greaterThanOrEqualTo((long)0L));
        ChronoUnit chronoUnit = TIME_UNIT_TO_CHRONO_UNIT.apply(t.unit);
        return chronoUnit.getDuration().multipliedBy(t.value);
    };

    private TimeFunctions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static final Function<TimeUnit, ChronoUnit> timeUnitToChronoUnit() {
        return TIME_UNIT_TO_CHRONO_UNIT;
    }

    public static Function<LengthOfTime, Duration> lengthOfTimeToDuration() {
        return LENGTH_OF_TIME_TO_DURATION;
    }

    public static long toSeconds(@Required LengthOfTime lengthOfTime) {
        Arguments.checkThat((Object)lengthOfTime).is(Assertions.notNull());
        Duration duration = TimeFunctions.lengthOfTimeToDuration().apply(lengthOfTime);
        return duration.getSeconds();
    }
}

