/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.assertions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.UserToken;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.authentication.service.VerifyTokenResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
public final class AromaAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(AromaAssertions.class);

    AromaAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static ExceptionMapper<InvalidArgumentException> withMessage(String message) {
        return ex -> new InvalidArgumentException(message);
    }

    public static void checkRequestNotNull(Object request) throws InvalidArgumentException {
        AromaAssertions.checkNotNull(request, "missing request");
    }

    public static void checkNotNull(Object reference, String message) throws InvalidArgumentException {
        Arguments.checkThat((Object)reference).throwing(AromaAssertions.withMessage(message)).is(Assertions.notNull());
    }

    public static AlchemyAssertion<AuthenticationToken> legalToken() {
        return t -> {
            Arguments.checkThat((Object)t).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)t.tokenId).usingMessage("token missing tokenId").is(StringAssertions.nonEmptyString());
        };
    }

    public static AlchemyAssertion<ApplicationToken> validApplicationTokenIn(@Required AuthenticationService.Iface authenticationService) {
        Arguments.checkThat((Object)authenticationService).usingMessage("authentication service is null").is(Assertions.notNull());
        return token -> {
            Arguments.checkThat((Object)token).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)token.tokenId).usingMessage("token is missing tokenId").is(StringAssertions.nonEmptyString());
            AuthenticationToken authToken = new AuthenticationToken().setTokenId(token.tokenId).setOwnerId(token.applicationId).setOwnerName(token.applicationName);
            Arguments.checkThat((Object)authToken).is(AromaAssertions.validTokenIn(authenticationService));
        };
    }

    public static AlchemyAssertion<UserToken> validUserTokenIn(@Required AuthenticationService.Iface authenticationService) {
        Arguments.checkThat((Object)authenticationService).usingMessage("authentication service is null").is(Assertions.notNull());
        return token -> {
            Arguments.checkThat((Object)token).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)token.tokenId).usingMessage("token is missing tokenId").is(StringAssertions.nonEmptyString());
            AuthenticationToken authToken = new AuthenticationToken().setTokenId(token.tokenId).setOwnerId(token.userId).setOrganizationId(token.organization);
            Arguments.checkThat((Object)authToken).is(AromaAssertions.validTokenIn(authenticationService));
        };
    }

    public static AlchemyAssertion<AuthenticationToken> validTokenIn(@Required AuthenticationService.Iface authenticationService) {
        Arguments.checkThat((Object)authenticationService).usingMessage("authentication service is null").is(Assertions.notNull());
        return token -> {
            Arguments.checkThat((Object)token).is(AromaAssertions.legalToken());
            String tokenId = token.getTokenId();
            Arguments.checkThat((Object)tokenId).usingMessage("tokenId is missing").is(StringAssertions.nonEmptyString());
            VerifyTokenRequest request = new VerifyTokenRequest().setTokenId(tokenId);
            if (token.isSetOwnerId()) {
                request.setOwnerId(token.ownerId);
            }
            try {
                VerifyTokenResponse response = authenticationService.verifyToken(request);
            }
            catch (InvalidTokenException ex) {
                throw new FailedAssertionException("Token is not valid");
            }
            catch (Exception ex) {
                throw new FailedAssertionException("Could not contact Authentication Service", (Throwable)ex);
            }
        };
    }
}

