/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.Industry;
import tech.aroma.thrift.Tier;

public class Organization
implements TBase<Organization, _Fields>,
Serializable,
Cloneable,
Comparable<Organization> {
    private static final TStruct STRUCT_DESC = new TStruct("Organization");
    private static final TField ORGANIZATION_ID_FIELD_DESC = new TField("organizationId", 11, 1);
    private static final TField ORGANIZATION_NAME_FIELD_DESC = new TField("organizationName", 11, 2);
    private static final TField WEBSITE_FIELD_DESC = new TField("website", 11, 3);
    private static final TField LOGO_FIELD_DESC = new TField("logo", 12, 4);
    private static final TField TECH_STACK_FIELD_DESC = new TField("techStack", 11, 5);
    private static final TField OWNERS_FIELD_DESC = new TField("owners", 15, 6);
    private static final TField ORGANIZATION_EMAIL_FIELD_DESC = new TField("organizationEmail", 11, 7);
    private static final TField STOCK_MARKET_SYMBOL_FIELD_DESC = new TField("stockMarketSymbol", 11, 8);
    private static final TField LOGO_LINK_FIELD_DESC = new TField("logoLink", 11, 9);
    private static final TField INDUSTRY_FIELD_DESC = new TField("industry", 8, 10);
    private static final TField TIER_FIELD_DESC = new TField("tier", 8, 11);
    private static final TField ORGANIZATION_DESCRIPTION_FIELD_DESC = new TField("organizationDescription", 11, 12);
    private static final TField GITHUB_PROFILE_FIELD_DESC = new TField("githubProfile", 11, 13);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String organizationId;
    public String organizationName;
    public String website;
    public Image logo;
    public String techStack;
    public List<String> owners;
    public String organizationEmail;
    public String stockMarketSymbol;
    public String logoLink;
    public Industry industry;
    public Tier tier;
    public String organizationDescription;
    public String githubProfile;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Organization() {
        this.tier = Tier.FREE;
    }

    public Organization(String organizationId, String organizationName) {
        this();
        this.organizationId = organizationId;
        this.organizationName = organizationName;
    }

    public Organization(Organization other) {
        if (other.isSetOrganizationId()) {
            this.organizationId = other.organizationId;
        }
        if (other.isSetOrganizationName()) {
            this.organizationName = other.organizationName;
        }
        if (other.isSetWebsite()) {
            this.website = other.website;
        }
        if (other.isSetLogo()) {
            this.logo = new Image(other.logo);
        }
        if (other.isSetTechStack()) {
            this.techStack = other.techStack;
        }
        if (other.isSetOwners()) {
            ArrayList<String> __this__owners = new ArrayList<String>(other.owners);
            this.owners = __this__owners;
        }
        if (other.isSetOrganizationEmail()) {
            this.organizationEmail = other.organizationEmail;
        }
        if (other.isSetStockMarketSymbol()) {
            this.stockMarketSymbol = other.stockMarketSymbol;
        }
        if (other.isSetLogoLink()) {
            this.logoLink = other.logoLink;
        }
        if (other.isSetIndustry()) {
            this.industry = other.industry;
        }
        if (other.isSetTier()) {
            this.tier = other.tier;
        }
        if (other.isSetOrganizationDescription()) {
            this.organizationDescription = other.organizationDescription;
        }
        if (other.isSetGithubProfile()) {
            this.githubProfile = other.githubProfile;
        }
    }

    public Organization deepCopy() {
        return new Organization(this);
    }

    public void clear() {
        this.organizationId = null;
        this.organizationName = null;
        this.website = null;
        this.logo = null;
        this.techStack = null;
        this.owners = null;
        this.organizationEmail = null;
        this.stockMarketSymbol = null;
        this.logoLink = null;
        this.industry = null;
        this.tier = Tier.FREE;
        this.organizationDescription = null;
        this.githubProfile = null;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Organization setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public void unsetOrganizationId() {
        this.organizationId = null;
    }

    public boolean isSetOrganizationId() {
        return this.organizationId != null;
    }

    public void setOrganizationIdIsSet(boolean value) {
        if (!value) {
            this.organizationId = null;
        }
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Organization setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public void unsetOrganizationName() {
        this.organizationName = null;
    }

    public boolean isSetOrganizationName() {
        return this.organizationName != null;
    }

    public void setOrganizationNameIsSet(boolean value) {
        if (!value) {
            this.organizationName = null;
        }
    }

    public String getWebsite() {
        return this.website;
    }

    public Organization setWebsite(String website) {
        this.website = website;
        return this;
    }

    public void unsetWebsite() {
        this.website = null;
    }

    public boolean isSetWebsite() {
        return this.website != null;
    }

    public void setWebsiteIsSet(boolean value) {
        if (!value) {
            this.website = null;
        }
    }

    public Image getLogo() {
        return this.logo;
    }

    public Organization setLogo(Image logo) {
        this.logo = logo;
        return this;
    }

    public void unsetLogo() {
        this.logo = null;
    }

    public boolean isSetLogo() {
        return this.logo != null;
    }

    public void setLogoIsSet(boolean value) {
        if (!value) {
            this.logo = null;
        }
    }

    public String getTechStack() {
        return this.techStack;
    }

    public Organization setTechStack(String techStack) {
        this.techStack = techStack;
        return this;
    }

    public void unsetTechStack() {
        this.techStack = null;
    }

    public boolean isSetTechStack() {
        return this.techStack != null;
    }

    public void setTechStackIsSet(boolean value) {
        if (!value) {
            this.techStack = null;
        }
    }

    public int getOwnersSize() {
        return this.owners == null ? 0 : this.owners.size();
    }

    public Iterator<String> getOwnersIterator() {
        return this.owners == null ? null : this.owners.iterator();
    }

    public void addToOwners(String elem) {
        if (this.owners == null) {
            this.owners = new ArrayList<String>();
        }
        this.owners.add(elem);
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public Organization setOwners(List<String> owners) {
        this.owners = owners;
        return this;
    }

    public void unsetOwners() {
        this.owners = null;
    }

    public boolean isSetOwners() {
        return this.owners != null;
    }

    public void setOwnersIsSet(boolean value) {
        if (!value) {
            this.owners = null;
        }
    }

    public String getOrganizationEmail() {
        return this.organizationEmail;
    }

    public Organization setOrganizationEmail(String organizationEmail) {
        this.organizationEmail = organizationEmail;
        return this;
    }

    public void unsetOrganizationEmail() {
        this.organizationEmail = null;
    }

    public boolean isSetOrganizationEmail() {
        return this.organizationEmail != null;
    }

    public void setOrganizationEmailIsSet(boolean value) {
        if (!value) {
            this.organizationEmail = null;
        }
    }

    public String getStockMarketSymbol() {
        return this.stockMarketSymbol;
    }

    public Organization setStockMarketSymbol(String stockMarketSymbol) {
        this.stockMarketSymbol = stockMarketSymbol;
        return this;
    }

    public void unsetStockMarketSymbol() {
        this.stockMarketSymbol = null;
    }

    public boolean isSetStockMarketSymbol() {
        return this.stockMarketSymbol != null;
    }

    public void setStockMarketSymbolIsSet(boolean value) {
        if (!value) {
            this.stockMarketSymbol = null;
        }
    }

    public String getLogoLink() {
        return this.logoLink;
    }

    public Organization setLogoLink(String logoLink) {
        this.logoLink = logoLink;
        return this;
    }

    public void unsetLogoLink() {
        this.logoLink = null;
    }

    public boolean isSetLogoLink() {
        return this.logoLink != null;
    }

    public void setLogoLinkIsSet(boolean value) {
        if (!value) {
            this.logoLink = null;
        }
    }

    public Industry getIndustry() {
        return this.industry;
    }

    public Organization setIndustry(Industry industry) {
        this.industry = industry;
        return this;
    }

    public void unsetIndustry() {
        this.industry = null;
    }

    public boolean isSetIndustry() {
        return this.industry != null;
    }

    public void setIndustryIsSet(boolean value) {
        if (!value) {
            this.industry = null;
        }
    }

    public Tier getTier() {
        return this.tier;
    }

    public Organization setTier(Tier tier) {
        this.tier = tier;
        return this;
    }

    public void unsetTier() {
        this.tier = null;
    }

    public boolean isSetTier() {
        return this.tier != null;
    }

    public void setTierIsSet(boolean value) {
        if (!value) {
            this.tier = null;
        }
    }

    public String getOrganizationDescription() {
        return this.organizationDescription;
    }

    public Organization setOrganizationDescription(String organizationDescription) {
        this.organizationDescription = organizationDescription;
        return this;
    }

    public void unsetOrganizationDescription() {
        this.organizationDescription = null;
    }

    public boolean isSetOrganizationDescription() {
        return this.organizationDescription != null;
    }

    public void setOrganizationDescriptionIsSet(boolean value) {
        if (!value) {
            this.organizationDescription = null;
        }
    }

    public String getGithubProfile() {
        return this.githubProfile;
    }

    public Organization setGithubProfile(String githubProfile) {
        this.githubProfile = githubProfile;
        return this;
    }

    public void unsetGithubProfile() {
        this.githubProfile = null;
    }

    public boolean isSetGithubProfile() {
        return this.githubProfile != null;
    }

    public void setGithubProfileIsSet(boolean value) {
        if (!value) {
            this.githubProfile = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ORGANIZATION_ID: {
                if (value == null) {
                    this.unsetOrganizationId();
                    break;
                }
                this.setOrganizationId((String)value);
                break;
            }
            case ORGANIZATION_NAME: {
                if (value == null) {
                    this.unsetOrganizationName();
                    break;
                }
                this.setOrganizationName((String)value);
                break;
            }
            case WEBSITE: {
                if (value == null) {
                    this.unsetWebsite();
                    break;
                }
                this.setWebsite((String)value);
                break;
            }
            case LOGO: {
                if (value == null) {
                    this.unsetLogo();
                    break;
                }
                this.setLogo((Image)value);
                break;
            }
            case TECH_STACK: {
                if (value == null) {
                    this.unsetTechStack();
                    break;
                }
                this.setTechStack((String)value);
                break;
            }
            case OWNERS: {
                if (value == null) {
                    this.unsetOwners();
                    break;
                }
                this.setOwners((List)value);
                break;
            }
            case ORGANIZATION_EMAIL: {
                if (value == null) {
                    this.unsetOrganizationEmail();
                    break;
                }
                this.setOrganizationEmail((String)value);
                break;
            }
            case STOCK_MARKET_SYMBOL: {
                if (value == null) {
                    this.unsetStockMarketSymbol();
                    break;
                }
                this.setStockMarketSymbol((String)value);
                break;
            }
            case LOGO_LINK: {
                if (value == null) {
                    this.unsetLogoLink();
                    break;
                }
                this.setLogoLink((String)value);
                break;
            }
            case INDUSTRY: {
                if (value == null) {
                    this.unsetIndustry();
                    break;
                }
                this.setIndustry((Industry)((Object)value));
                break;
            }
            case TIER: {
                if (value == null) {
                    this.unsetTier();
                    break;
                }
                this.setTier((Tier)((Object)value));
                break;
            }
            case ORGANIZATION_DESCRIPTION: {
                if (value == null) {
                    this.unsetOrganizationDescription();
                    break;
                }
                this.setOrganizationDescription((String)value);
                break;
            }
            case GITHUB_PROFILE: {
                if (value == null) {
                    this.unsetGithubProfile();
                    break;
                }
                this.setGithubProfile((String)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ORGANIZATION_ID: {
                return this.getOrganizationId();
            }
            case ORGANIZATION_NAME: {
                return this.getOrganizationName();
            }
            case WEBSITE: {
                return this.getWebsite();
            }
            case LOGO: {
                return this.getLogo();
            }
            case TECH_STACK: {
                return this.getTechStack();
            }
            case OWNERS: {
                return this.getOwners();
            }
            case ORGANIZATION_EMAIL: {
                return this.getOrganizationEmail();
            }
            case STOCK_MARKET_SYMBOL: {
                return this.getStockMarketSymbol();
            }
            case LOGO_LINK: {
                return this.getLogoLink();
            }
            case INDUSTRY: {
                return this.getIndustry();
            }
            case TIER: {
                return this.getTier();
            }
            case ORGANIZATION_DESCRIPTION: {
                return this.getOrganizationDescription();
            }
            case GITHUB_PROFILE: {
                return this.getGithubProfile();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ORGANIZATION_ID: {
                return this.isSetOrganizationId();
            }
            case ORGANIZATION_NAME: {
                return this.isSetOrganizationName();
            }
            case WEBSITE: {
                return this.isSetWebsite();
            }
            case LOGO: {
                return this.isSetLogo();
            }
            case TECH_STACK: {
                return this.isSetTechStack();
            }
            case OWNERS: {
                return this.isSetOwners();
            }
            case ORGANIZATION_EMAIL: {
                return this.isSetOrganizationEmail();
            }
            case STOCK_MARKET_SYMBOL: {
                return this.isSetStockMarketSymbol();
            }
            case LOGO_LINK: {
                return this.isSetLogoLink();
            }
            case INDUSTRY: {
                return this.isSetIndustry();
            }
            case TIER: {
                return this.isSetTier();
            }
            case ORGANIZATION_DESCRIPTION: {
                return this.isSetOrganizationDescription();
            }
            case GITHUB_PROFILE: {
                return this.isSetGithubProfile();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Organization) {
            return this.equals((Organization)that);
        }
        return false;
    }

    public boolean equals(Organization that) {
        if (that == null) {
            return false;
        }
        boolean this_present_organizationId = this.isSetOrganizationId();
        boolean that_present_organizationId = that.isSetOrganizationId();
        if (this_present_organizationId || that_present_organizationId) {
            if (!this_present_organizationId || !that_present_organizationId) {
                return false;
            }
            if (!this.organizationId.equals(that.organizationId)) {
                return false;
            }
        }
        boolean this_present_organizationName = this.isSetOrganizationName();
        boolean that_present_organizationName = that.isSetOrganizationName();
        if (this_present_organizationName || that_present_organizationName) {
            if (!this_present_organizationName || !that_present_organizationName) {
                return false;
            }
            if (!this.organizationName.equals(that.organizationName)) {
                return false;
            }
        }
        boolean this_present_website = this.isSetWebsite();
        boolean that_present_website = that.isSetWebsite();
        if (this_present_website || that_present_website) {
            if (!this_present_website || !that_present_website) {
                return false;
            }
            if (!this.website.equals(that.website)) {
                return false;
            }
        }
        boolean this_present_logo = this.isSetLogo();
        boolean that_present_logo = that.isSetLogo();
        if (this_present_logo || that_present_logo) {
            if (!this_present_logo || !that_present_logo) {
                return false;
            }
            if (!this.logo.equals(that.logo)) {
                return false;
            }
        }
        boolean this_present_techStack = this.isSetTechStack();
        boolean that_present_techStack = that.isSetTechStack();
        if (this_present_techStack || that_present_techStack) {
            if (!this_present_techStack || !that_present_techStack) {
                return false;
            }
            if (!this.techStack.equals(that.techStack)) {
                return false;
            }
        }
        boolean this_present_owners = this.isSetOwners();
        boolean that_present_owners = that.isSetOwners();
        if (this_present_owners || that_present_owners) {
            if (!this_present_owners || !that_present_owners) {
                return false;
            }
            if (!this.owners.equals(that.owners)) {
                return false;
            }
        }
        boolean this_present_organizationEmail = this.isSetOrganizationEmail();
        boolean that_present_organizationEmail = that.isSetOrganizationEmail();
        if (this_present_organizationEmail || that_present_organizationEmail) {
            if (!this_present_organizationEmail || !that_present_organizationEmail) {
                return false;
            }
            if (!this.organizationEmail.equals(that.organizationEmail)) {
                return false;
            }
        }
        boolean this_present_stockMarketSymbol = this.isSetStockMarketSymbol();
        boolean that_present_stockMarketSymbol = that.isSetStockMarketSymbol();
        if (this_present_stockMarketSymbol || that_present_stockMarketSymbol) {
            if (!this_present_stockMarketSymbol || !that_present_stockMarketSymbol) {
                return false;
            }
            if (!this.stockMarketSymbol.equals(that.stockMarketSymbol)) {
                return false;
            }
        }
        boolean this_present_logoLink = this.isSetLogoLink();
        boolean that_present_logoLink = that.isSetLogoLink();
        if (this_present_logoLink || that_present_logoLink) {
            if (!this_present_logoLink || !that_present_logoLink) {
                return false;
            }
            if (!this.logoLink.equals(that.logoLink)) {
                return false;
            }
        }
        boolean this_present_industry = this.isSetIndustry();
        boolean that_present_industry = that.isSetIndustry();
        if (this_present_industry || that_present_industry) {
            if (!this_present_industry || !that_present_industry) {
                return false;
            }
            if (!this.industry.equals((Object)that.industry)) {
                return false;
            }
        }
        boolean this_present_tier = this.isSetTier();
        boolean that_present_tier = that.isSetTier();
        if (this_present_tier || that_present_tier) {
            if (!this_present_tier || !that_present_tier) {
                return false;
            }
            if (!this.tier.equals((Object)that.tier)) {
                return false;
            }
        }
        boolean this_present_organizationDescription = this.isSetOrganizationDescription();
        boolean that_present_organizationDescription = that.isSetOrganizationDescription();
        if (this_present_organizationDescription || that_present_organizationDescription) {
            if (!this_present_organizationDescription || !that_present_organizationDescription) {
                return false;
            }
            if (!this.organizationDescription.equals(that.organizationDescription)) {
                return false;
            }
        }
        boolean this_present_githubProfile = this.isSetGithubProfile();
        boolean that_present_githubProfile = that.isSetGithubProfile();
        if (this_present_githubProfile || that_present_githubProfile) {
            if (!this_present_githubProfile || !that_present_githubProfile) {
                return false;
            }
            if (!this.githubProfile.equals(that.githubProfile)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_organizationId = this.isSetOrganizationId();
        list.add(present_organizationId);
        if (present_organizationId) {
            list.add(this.organizationId);
        }
        boolean present_organizationName = this.isSetOrganizationName();
        list.add(present_organizationName);
        if (present_organizationName) {
            list.add(this.organizationName);
        }
        boolean present_website = this.isSetWebsite();
        list.add(present_website);
        if (present_website) {
            list.add(this.website);
        }
        boolean present_logo = this.isSetLogo();
        list.add(present_logo);
        if (present_logo) {
            list.add(this.logo);
        }
        boolean present_techStack = this.isSetTechStack();
        list.add(present_techStack);
        if (present_techStack) {
            list.add(this.techStack);
        }
        boolean present_owners = this.isSetOwners();
        list.add(present_owners);
        if (present_owners) {
            list.add(this.owners);
        }
        boolean present_organizationEmail = this.isSetOrganizationEmail();
        list.add(present_organizationEmail);
        if (present_organizationEmail) {
            list.add(this.organizationEmail);
        }
        boolean present_stockMarketSymbol = this.isSetStockMarketSymbol();
        list.add(present_stockMarketSymbol);
        if (present_stockMarketSymbol) {
            list.add(this.stockMarketSymbol);
        }
        boolean present_logoLink = this.isSetLogoLink();
        list.add(present_logoLink);
        if (present_logoLink) {
            list.add(this.logoLink);
        }
        boolean present_industry = this.isSetIndustry();
        list.add(present_industry);
        if (present_industry) {
            list.add(this.industry.getValue());
        }
        boolean present_tier = this.isSetTier();
        list.add(present_tier);
        if (present_tier) {
            list.add(this.tier.getValue());
        }
        boolean present_organizationDescription = this.isSetOrganizationDescription();
        list.add(present_organizationDescription);
        if (present_organizationDescription) {
            list.add(this.organizationDescription);
        }
        boolean present_githubProfile = this.isSetGithubProfile();
        list.add(present_githubProfile);
        if (present_githubProfile) {
            list.add(this.githubProfile);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Organization other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetOrganizationId()).compareTo(other.isSetOrganizationId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrganizationId() && (lastComparison = TBaseHelper.compareTo((String)this.organizationId, (String)other.organizationId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrganizationName()).compareTo(other.isSetOrganizationName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrganizationName() && (lastComparison = TBaseHelper.compareTo((String)this.organizationName, (String)other.organizationName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWebsite()).compareTo(other.isSetWebsite());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWebsite() && (lastComparison = TBaseHelper.compareTo((String)this.website, (String)other.website)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLogo()).compareTo(other.isSetLogo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLogo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.logo, (Comparable)other.logo)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTechStack()).compareTo(other.isSetTechStack());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTechStack() && (lastComparison = TBaseHelper.compareTo((String)this.techStack, (String)other.techStack)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwners()).compareTo(other.isSetOwners());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwners() && (lastComparison = TBaseHelper.compareTo(this.owners, other.owners)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrganizationEmail()).compareTo(other.isSetOrganizationEmail());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrganizationEmail() && (lastComparison = TBaseHelper.compareTo((String)this.organizationEmail, (String)other.organizationEmail)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStockMarketSymbol()).compareTo(other.isSetStockMarketSymbol());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStockMarketSymbol() && (lastComparison = TBaseHelper.compareTo((String)this.stockMarketSymbol, (String)other.stockMarketSymbol)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLogoLink()).compareTo(other.isSetLogoLink());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLogoLink() && (lastComparison = TBaseHelper.compareTo((String)this.logoLink, (String)other.logoLink)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndustry()).compareTo(other.isSetIndustry());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndustry() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.industry), (Comparable)((Object)other.industry))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTier()).compareTo(other.isSetTier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTier() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tier), (Comparable)((Object)other.tier))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrganizationDescription()).compareTo(other.isSetOrganizationDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrganizationDescription() && (lastComparison = TBaseHelper.compareTo((String)this.organizationDescription, (String)other.organizationDescription)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGithubProfile()).compareTo(other.isSetGithubProfile());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGithubProfile() && (lastComparison = TBaseHelper.compareTo((String)this.githubProfile, (String)other.githubProfile)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Organization(");
        boolean first = true;
        sb.append("organizationId:");
        if (this.organizationId == null) {
            sb.append("null");
        } else {
            sb.append(this.organizationId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("organizationName:");
        if (this.organizationName == null) {
            sb.append("null");
        } else {
            sb.append(this.organizationName);
        }
        first = false;
        if (this.isSetWebsite()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("website:");
            if (this.website == null) {
                sb.append("null");
            } else {
                sb.append(this.website);
            }
            first = false;
        }
        if (this.isSetLogo()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("logo:");
            if (this.logo == null) {
                sb.append("null");
            } else {
                sb.append(this.logo);
            }
            first = false;
        }
        if (this.isSetTechStack()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("techStack:");
            if (this.techStack == null) {
                sb.append("null");
            } else {
                sb.append(this.techStack);
            }
            first = false;
        }
        if (this.isSetOwners()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("owners:");
            if (this.owners == null) {
                sb.append("null");
            } else {
                sb.append(this.owners);
            }
            first = false;
        }
        if (this.isSetOrganizationEmail()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("organizationEmail:");
            if (this.organizationEmail == null) {
                sb.append("null");
            } else {
                sb.append(this.organizationEmail);
            }
            first = false;
        }
        if (this.isSetStockMarketSymbol()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("stockMarketSymbol:");
            if (this.stockMarketSymbol == null) {
                sb.append("null");
            } else {
                sb.append(this.stockMarketSymbol);
            }
            first = false;
        }
        if (this.isSetLogoLink()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("logoLink:");
            if (this.logoLink == null) {
                sb.append("null");
            } else {
                sb.append(this.logoLink);
            }
            first = false;
        }
        if (this.isSetIndustry()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("industry:");
            if (this.industry == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.industry);
            }
            first = false;
        }
        if (this.isSetTier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tier:");
            if (this.tier == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.tier);
            }
            first = false;
        }
        if (this.isSetOrganizationDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("organizationDescription:");
            if (this.organizationDescription == null) {
                sb.append("null");
            } else {
                sb.append(this.organizationDescription);
            }
            first = false;
        }
        if (this.isSetGithubProfile()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("githubProfile:");
            if (this.githubProfile == null) {
                sb.append("null");
            } else {
                sb.append(this.githubProfile);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.logo != null) {
            this.logo.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new OrganizationStandardSchemeFactory());
        schemes.put(TupleScheme.class, new OrganizationTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.WEBSITE, _Fields.LOGO, _Fields.TECH_STACK, _Fields.OWNERS, _Fields.ORGANIZATION_EMAIL, _Fields.STOCK_MARKET_SYMBOL, _Fields.LOGO_LINK, _Fields.INDUSTRY, _Fields.TIER, _Fields.ORGANIZATION_DESCRIPTION, _Fields.GITHUB_PROFILE};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ORGANIZATION_ID, new FieldMetaData("organizationId", 3, new FieldValueMetaData(11, "uuid")));
        tmpMap.put(_Fields.ORGANIZATION_NAME, new FieldMetaData("organizationName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WEBSITE, new FieldMetaData("website", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LOGO, new FieldMetaData("logo", 2, (FieldValueMetaData)new StructMetaData(12, Image.class)));
        tmpMap.put(_Fields.TECH_STACK, new FieldMetaData("techStack", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNERS, new FieldMetaData("owners", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ORGANIZATION_EMAIL, new FieldMetaData("organizationEmail", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.STOCK_MARKET_SYMBOL, new FieldMetaData("stockMarketSymbol", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LOGO_LINK, new FieldMetaData("logoLink", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.INDUSTRY, new FieldMetaData("industry", 2, (FieldValueMetaData)new EnumMetaData(16, Industry.class)));
        tmpMap.put(_Fields.TIER, new FieldMetaData("tier", 2, (FieldValueMetaData)new EnumMetaData(16, Tier.class)));
        tmpMap.put(_Fields.ORGANIZATION_DESCRIPTION, new FieldMetaData("organizationDescription", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GITHUB_PROFILE, new FieldMetaData("githubProfile", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Organization.class, metaDataMap);
    }

    private static class OrganizationTupleScheme
    extends TupleScheme<Organization> {
        private OrganizationTupleScheme() {
        }

        public void write(TProtocol prot, Organization struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetOrganizationId()) {
                optionals.set(0);
            }
            if (struct.isSetOrganizationName()) {
                optionals.set(1);
            }
            if (struct.isSetWebsite()) {
                optionals.set(2);
            }
            if (struct.isSetLogo()) {
                optionals.set(3);
            }
            if (struct.isSetTechStack()) {
                optionals.set(4);
            }
            if (struct.isSetOwners()) {
                optionals.set(5);
            }
            if (struct.isSetOrganizationEmail()) {
                optionals.set(6);
            }
            if (struct.isSetStockMarketSymbol()) {
                optionals.set(7);
            }
            if (struct.isSetLogoLink()) {
                optionals.set(8);
            }
            if (struct.isSetIndustry()) {
                optionals.set(9);
            }
            if (struct.isSetTier()) {
                optionals.set(10);
            }
            if (struct.isSetOrganizationDescription()) {
                optionals.set(11);
            }
            if (struct.isSetGithubProfile()) {
                optionals.set(12);
            }
            oprot.writeBitSet(optionals, 13);
            if (struct.isSetOrganizationId()) {
                oprot.writeString(struct.organizationId);
            }
            if (struct.isSetOrganizationName()) {
                oprot.writeString(struct.organizationName);
            }
            if (struct.isSetWebsite()) {
                oprot.writeString(struct.website);
            }
            if (struct.isSetLogo()) {
                struct.logo.write((TProtocol)oprot);
            }
            if (struct.isSetTechStack()) {
                oprot.writeString(struct.techStack);
            }
            if (struct.isSetOwners()) {
                oprot.writeI32(struct.owners.size());
                for (String _iter4 : struct.owners) {
                    oprot.writeString(_iter4);
                }
            }
            if (struct.isSetOrganizationEmail()) {
                oprot.writeString(struct.organizationEmail);
            }
            if (struct.isSetStockMarketSymbol()) {
                oprot.writeString(struct.stockMarketSymbol);
            }
            if (struct.isSetLogoLink()) {
                oprot.writeString(struct.logoLink);
            }
            if (struct.isSetIndustry()) {
                oprot.writeI32(struct.industry.getValue());
            }
            if (struct.isSetTier()) {
                oprot.writeI32(struct.tier.getValue());
            }
            if (struct.isSetOrganizationDescription()) {
                oprot.writeString(struct.organizationDescription);
            }
            if (struct.isSetGithubProfile()) {
                oprot.writeString(struct.githubProfile);
            }
        }

        public void read(TProtocol prot, Organization struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(13);
            if (incoming.get(0)) {
                struct.organizationId = iprot.readString();
                struct.setOrganizationIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.organizationName = iprot.readString();
                struct.setOrganizationNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.website = iprot.readString();
                struct.setWebsiteIsSet(true);
            }
            if (incoming.get(3)) {
                struct.logo = new Image();
                struct.logo.read((TProtocol)iprot);
                struct.setLogoIsSet(true);
            }
            if (incoming.get(4)) {
                struct.techStack = iprot.readString();
                struct.setTechStackIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list5 = new TList(11, iprot.readI32());
                struct.owners = new ArrayList<String>(_list5.size);
                for (int _i7 = 0; _i7 < _list5.size; ++_i7) {
                    String _elem6 = iprot.readString();
                    struct.owners.add(_elem6);
                }
                struct.setOwnersIsSet(true);
            }
            if (incoming.get(6)) {
                struct.organizationEmail = iprot.readString();
                struct.setOrganizationEmailIsSet(true);
            }
            if (incoming.get(7)) {
                struct.stockMarketSymbol = iprot.readString();
                struct.setStockMarketSymbolIsSet(true);
            }
            if (incoming.get(8)) {
                struct.logoLink = iprot.readString();
                struct.setLogoLinkIsSet(true);
            }
            if (incoming.get(9)) {
                struct.industry = Industry.findByValue(iprot.readI32());
                struct.setIndustryIsSet(true);
            }
            if (incoming.get(10)) {
                struct.tier = Tier.findByValue(iprot.readI32());
                struct.setTierIsSet(true);
            }
            if (incoming.get(11)) {
                struct.organizationDescription = iprot.readString();
                struct.setOrganizationDescriptionIsSet(true);
            }
            if (incoming.get(12)) {
                struct.githubProfile = iprot.readString();
                struct.setGithubProfileIsSet(true);
            }
        }
    }

    private static class OrganizationTupleSchemeFactory
    implements SchemeFactory {
        private OrganizationTupleSchemeFactory() {
        }

        public OrganizationTupleScheme getScheme() {
            return new OrganizationTupleScheme();
        }
    }

    private static class OrganizationStandardScheme
    extends StandardScheme<Organization> {
        private OrganizationStandardScheme() {
        }

        public void read(TProtocol iprot, Organization struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.organizationId = iprot.readString();
                            struct.setOrganizationIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.organizationName = iprot.readString();
                            struct.setOrganizationNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.website = iprot.readString();
                            struct.setWebsiteIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.logo = new Image();
                            struct.logo.read(iprot);
                            struct.setLogoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.techStack = iprot.readString();
                            struct.setTechStackIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.owners = new ArrayList<String>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                String _elem1 = iprot.readString();
                                struct.owners.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setOwnersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.organizationEmail = iprot.readString();
                            struct.setOrganizationEmailIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.stockMarketSymbol = iprot.readString();
                            struct.setStockMarketSymbolIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.logoLink = iprot.readString();
                            struct.setLogoLinkIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.industry = Industry.findByValue(iprot.readI32());
                            struct.setIndustryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.tier = Tier.findByValue(iprot.readI32());
                            struct.setTierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.organizationDescription = iprot.readString();
                            struct.setOrganizationDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 11) {
                            struct.githubProfile = iprot.readString();
                            struct.setGithubProfileIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Organization struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.organizationId != null) {
                oprot.writeFieldBegin(ORGANIZATION_ID_FIELD_DESC);
                oprot.writeString(struct.organizationId);
                oprot.writeFieldEnd();
            }
            if (struct.organizationName != null) {
                oprot.writeFieldBegin(ORGANIZATION_NAME_FIELD_DESC);
                oprot.writeString(struct.organizationName);
                oprot.writeFieldEnd();
            }
            if (struct.website != null && struct.isSetWebsite()) {
                oprot.writeFieldBegin(WEBSITE_FIELD_DESC);
                oprot.writeString(struct.website);
                oprot.writeFieldEnd();
            }
            if (struct.logo != null && struct.isSetLogo()) {
                oprot.writeFieldBegin(LOGO_FIELD_DESC);
                struct.logo.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.techStack != null && struct.isSetTechStack()) {
                oprot.writeFieldBegin(TECH_STACK_FIELD_DESC);
                oprot.writeString(struct.techStack);
                oprot.writeFieldEnd();
            }
            if (struct.owners != null && struct.isSetOwners()) {
                oprot.writeFieldBegin(OWNERS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.owners.size()));
                for (String _iter3 : struct.owners) {
                    oprot.writeString(_iter3);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.organizationEmail != null && struct.isSetOrganizationEmail()) {
                oprot.writeFieldBegin(ORGANIZATION_EMAIL_FIELD_DESC);
                oprot.writeString(struct.organizationEmail);
                oprot.writeFieldEnd();
            }
            if (struct.stockMarketSymbol != null && struct.isSetStockMarketSymbol()) {
                oprot.writeFieldBegin(STOCK_MARKET_SYMBOL_FIELD_DESC);
                oprot.writeString(struct.stockMarketSymbol);
                oprot.writeFieldEnd();
            }
            if (struct.logoLink != null && struct.isSetLogoLink()) {
                oprot.writeFieldBegin(LOGO_LINK_FIELD_DESC);
                oprot.writeString(struct.logoLink);
                oprot.writeFieldEnd();
            }
            if (struct.industry != null && struct.isSetIndustry()) {
                oprot.writeFieldBegin(INDUSTRY_FIELD_DESC);
                oprot.writeI32(struct.industry.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.tier != null && struct.isSetTier()) {
                oprot.writeFieldBegin(TIER_FIELD_DESC);
                oprot.writeI32(struct.tier.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.organizationDescription != null && struct.isSetOrganizationDescription()) {
                oprot.writeFieldBegin(ORGANIZATION_DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.organizationDescription);
                oprot.writeFieldEnd();
            }
            if (struct.githubProfile != null && struct.isSetGithubProfile()) {
                oprot.writeFieldBegin(GITHUB_PROFILE_FIELD_DESC);
                oprot.writeString(struct.githubProfile);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class OrganizationStandardSchemeFactory
    implements SchemeFactory {
        private OrganizationStandardSchemeFactory() {
        }

        public OrganizationStandardScheme getScheme() {
            return new OrganizationStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ORGANIZATION_ID(1, "organizationId"),
        ORGANIZATION_NAME(2, "organizationName"),
        WEBSITE(3, "website"),
        LOGO(4, "logo"),
        TECH_STACK(5, "techStack"),
        OWNERS(6, "owners"),
        ORGANIZATION_EMAIL(7, "organizationEmail"),
        STOCK_MARKET_SYMBOL(8, "stockMarketSymbol"),
        LOGO_LINK(9, "logoLink"),
        INDUSTRY(10, "industry"),
        TIER(11, "tier"),
        ORGANIZATION_DESCRIPTION(12, "organizationDescription"),
        GITHUB_PROFILE(13, "githubProfile");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ORGANIZATION_ID;
                }
                case 2: {
                    return ORGANIZATION_NAME;
                }
                case 3: {
                    return WEBSITE;
                }
                case 4: {
                    return LOGO;
                }
                case 5: {
                    return TECH_STACK;
                }
                case 6: {
                    return OWNERS;
                }
                case 7: {
                    return ORGANIZATION_EMAIL;
                }
                case 8: {
                    return STOCK_MARKET_SYMBOL;
                }
                case 9: {
                    return LOGO_LINK;
                }
                case 10: {
                    return INDUSTRY;
                }
                case 11: {
                    return TIER;
                }
                case 12: {
                    return ORGANIZATION_DESCRIPTION;
                }
                case 13: {
                    return GITHUB_PROFILE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

