/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.ImageType;

public class Image
implements TBase<Image, _Fields>,
Serializable,
Cloneable,
Comparable<Image> {
    private static final TStruct STRUCT_DESC = new TStruct("Image");
    private static final TField IMAGE_TYPE_FIELD_DESC = new TField("imageType", 8, 1);
    private static final TField DATA_FIELD_DESC = new TField("data", 11, 2);
    private static final TField DIMENSION_FIELD_DESC = new TField("dimension", 12, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ImageType imageType;
    public ByteBuffer data;
    public Dimension dimension;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Image() {
    }

    public Image(ImageType imageType, ByteBuffer data, Dimension dimension) {
        this();
        this.imageType = imageType;
        this.data = TBaseHelper.copyBinary((ByteBuffer)data);
        this.dimension = dimension;
    }

    public Image(Image other) {
        if (other.isSetImageType()) {
            this.imageType = other.imageType;
        }
        if (other.isSetData()) {
            this.data = TBaseHelper.copyBinary((ByteBuffer)other.data);
        }
        if (other.isSetDimension()) {
            this.dimension = new Dimension(other.dimension);
        }
    }

    public Image deepCopy() {
        return new Image(this);
    }

    public void clear() {
        this.imageType = null;
        this.data = null;
        this.dimension = null;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public Image setImageType(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public void unsetImageType() {
        this.imageType = null;
    }

    public boolean isSetImageType() {
        return this.imageType != null;
    }

    public void setImageTypeIsSet(boolean value) {
        if (!value) {
            this.imageType = null;
        }
    }

    public byte[] getData() {
        this.setData(TBaseHelper.rightSize((ByteBuffer)this.data));
        return this.data == null ? null : this.data.array();
    }

    public ByteBuffer bufferForData() {
        return TBaseHelper.copyBinary((ByteBuffer)this.data);
    }

    public Image setData(byte[] data) {
        this.data = data == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(data, data.length));
        return this;
    }

    public Image setData(ByteBuffer data) {
        this.data = TBaseHelper.copyBinary((ByteBuffer)data);
        return this;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Image setDimension(Dimension dimension) {
        this.dimension = dimension;
        return this;
    }

    public void unsetDimension() {
        this.dimension = null;
    }

    public boolean isSetDimension() {
        return this.dimension != null;
    }

    public void setDimensionIsSet(boolean value) {
        if (!value) {
            this.dimension = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case IMAGE_TYPE: {
                if (value == null) {
                    this.unsetImageType();
                    break;
                }
                this.setImageType((ImageType)((Object)value));
                break;
            }
            case DATA: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((ByteBuffer)value);
                break;
            }
            case DIMENSION: {
                if (value == null) {
                    this.unsetDimension();
                    break;
                }
                this.setDimension((Dimension)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case IMAGE_TYPE: {
                return this.getImageType();
            }
            case DATA: {
                return this.getData();
            }
            case DIMENSION: {
                return this.getDimension();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case IMAGE_TYPE: {
                return this.isSetImageType();
            }
            case DATA: {
                return this.isSetData();
            }
            case DIMENSION: {
                return this.isSetDimension();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Image) {
            return this.equals((Image)that);
        }
        return false;
    }

    public boolean equals(Image that) {
        if (that == null) {
            return false;
        }
        boolean this_present_imageType = this.isSetImageType();
        boolean that_present_imageType = that.isSetImageType();
        if (this_present_imageType || that_present_imageType) {
            if (!this_present_imageType || !that_present_imageType) {
                return false;
            }
            if (!this.imageType.equals((Object)that.imageType)) {
                return false;
            }
        }
        boolean this_present_data = this.isSetData();
        boolean that_present_data = that.isSetData();
        if (this_present_data || that_present_data) {
            if (!this_present_data || !that_present_data) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
        }
        boolean this_present_dimension = this.isSetDimension();
        boolean that_present_dimension = that.isSetDimension();
        if (this_present_dimension || that_present_dimension) {
            if (!this_present_dimension || !that_present_dimension) {
                return false;
            }
            if (!this.dimension.equals(that.dimension)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_imageType = this.isSetImageType();
        list.add(Boolean.valueOf(present_imageType));
        if (present_imageType) {
            list.add(Integer.valueOf(this.imageType.getValue()));
        }
        boolean present_data = this.isSetData();
        list.add(Boolean.valueOf(present_data));
        if (present_data) {
            list.add(this.data);
        }
        boolean present_dimension = this.isSetDimension();
        list.add(Boolean.valueOf(present_dimension));
        if (present_dimension) {
            list.add(this.dimension);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Image other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetImageType()).compareTo(other.isSetImageType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetImageType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.imageType), (Comparable)((Object)other.imageType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetData()).compareTo(other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData() && (lastComparison = TBaseHelper.compareTo((Comparable)this.data, (Comparable)other.data)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDimension()).compareTo(other.isSetDimension());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDimension() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dimension, (Comparable)other.dimension)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Image(");
        boolean first = true;
        sb.append("imageType:");
        if (this.imageType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.imageType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("data:");
        if (this.data == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.data, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dimension:");
        if (this.dimension == null) {
            sb.append("null");
        } else {
            sb.append(this.dimension);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.dimension != null) {
            this.dimension.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ImageStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ImageTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.IMAGE_TYPE, new FieldMetaData("imageType", 3, (FieldValueMetaData)new EnumMetaData(16, ImageType.class)));
        tmpMap.put(_Fields.DATA, new FieldMetaData("data", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DIMENSION, new FieldMetaData("dimension", 3, (FieldValueMetaData)new StructMetaData(12, Dimension.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Image.class, metaDataMap);
    }

    private static class ImageTupleScheme
    extends TupleScheme<Image> {
        private ImageTupleScheme() {
        }

        public void write(TProtocol prot, Image struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetImageType()) {
                optionals.set(0);
            }
            if (struct.isSetData()) {
                optionals.set(1);
            }
            if (struct.isSetDimension()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetImageType()) {
                oprot.writeI32(struct.imageType.getValue());
            }
            if (struct.isSetData()) {
                oprot.writeBinary(struct.data);
            }
            if (struct.isSetDimension()) {
                struct.dimension.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, Image struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.imageType = ImageType.findByValue(iprot.readI32());
                struct.setImageTypeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.data = iprot.readBinary();
                struct.setDataIsSet(true);
            }
            if (incoming.get(2)) {
                struct.dimension = new Dimension();
                struct.dimension.read((TProtocol)iprot);
                struct.setDimensionIsSet(true);
            }
        }
    }

    private static class ImageTupleSchemeFactory
    implements SchemeFactory {
        private ImageTupleSchemeFactory() {
        }

        public ImageTupleScheme getScheme() {
            return new ImageTupleScheme();
        }
    }

    private static class ImageStandardScheme
    extends StandardScheme<Image> {
        private ImageStandardScheme() {
        }

        public void read(TProtocol iprot, Image struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.imageType = ImageType.findByValue(iprot.readI32());
                            struct.setImageTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.data = iprot.readBinary();
                            struct.setDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.dimension = new Dimension();
                            struct.dimension.read(iprot);
                            struct.setDimensionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Image struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.imageType != null) {
                oprot.writeFieldBegin(IMAGE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.imageType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.data != null) {
                oprot.writeFieldBegin(DATA_FIELD_DESC);
                oprot.writeBinary(struct.data);
                oprot.writeFieldEnd();
            }
            if (struct.dimension != null) {
                oprot.writeFieldBegin(DIMENSION_FIELD_DESC);
                struct.dimension.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ImageStandardSchemeFactory
    implements SchemeFactory {
        private ImageStandardSchemeFactory() {
        }

        public ImageStandardScheme getScheme() {
            return new ImageStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        IMAGE_TYPE(1, "imageType"),
        DATA(2, "data"),
        DIMENSION(3, "dimension");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return IMAGE_TYPE;
                }
                case 2: {
                    return DATA;
                }
                case 3: {
                    return DIMENSION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

