/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BinaryGenerators;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.CollectionGenerators;
import tech.sirwellington.alchemy.generator.DateGenerators;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.ObjectGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;
import tech.sirwellington.alchemy.generator.TimeGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateList {
    public Class<?> value();

    public int size() default 10;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<List<?>> createGeneratorFor(GenerateList annotation) throws IllegalArgumentException {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            int size = annotation.size();
            Checks.Internal.checkThat(size > 0, "size must be > 0");
            Class<?> genericType = annotation.value();
            Checks.Internal.checkNotNull(genericType, "annotation is missing generic type information");
            AlchemyGenerator<?> generator = Values.determineGeneratorFor(genericType);
            return () -> CollectionGenerators.listOf((AlchemyGenerator)generator, (int)size);
        }

        private static AlchemyGenerator<?> determineGeneratorFor(Class<?> genericType) {
            if (genericType == String.class) {
                return StringGenerators.alphanumericString();
            }
            if (genericType == Integer.class) {
                return NumberGenerators.positiveIntegers();
            }
            if (genericType == Long.class) {
                return NumberGenerators.positiveLongs();
            }
            if (genericType == Double.class) {
                return NumberGenerators.doubles((double)0.0, (double)10000.0);
            }
            if (Date.class.isAssignableFrom(genericType)) {
                return DateGenerators.anyTime();
            }
            if (genericType == Instant.class) {
                return TimeGenerators.anytime();
            }
            if (genericType == Boolean.class) {
                return BooleanGenerators.booleans();
            }
            if (ByteBuffer.class.isAssignableFrom(genericType)) {
                return BinaryGenerators.byteBuffers((int)1024);
            }
            return ObjectGenerators.pojos(genericType);
        }
    }
}

