/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Instant;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.TimeGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateInstant {
    public Type value() default Type.ANYTIME;

    public long startTime() default 0L;

    public long endTime() default 0L;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<Instant> createGeneratorFor(GenerateInstant annotation) throws IllegalArgumentException {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            switch (annotation.value()) {
                case PAST: {
                    return TimeGenerators.pastInstants();
                }
                case PRESENT: {
                    return TimeGenerators.presentInstants();
                }
                case FUTURE: {
                    return TimeGenerators.futureInstants();
                }
                case ANYTIME: {
                    return TimeGenerators.anytime();
                }
                case RANGE: {
                    return Values.timesInRange(annotation.startTime(), annotation.endTime());
                }
            }
            return TimeGenerators.anytime();
        }

        private static AlchemyGenerator<Instant> timesInRange(long startTime, long endDate) {
            Checks.Internal.checkThat(startTime < endDate, "startDate must come before endDate");
            Instant start = Instant.ofEpochMilli(startTime);
            Instant end = Instant.ofEpochMilli(endDate);
            return TimeGenerators.timesBetween((Instant)start, (Instant)end);
        }
    }

    public static enum Type {
        PAST,
        PRESENT,
        FUTURE,
        ANYTIME,
        RANGE;

    }
}

