/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.DateGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateDate {
    public Type value() default Type.ANYTIME;

    public long startDate() default 0L;

    public long endDate() default 0L;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<Date> createGeneratorFor(GenerateDate annotation) throws IllegalArgumentException {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            switch (annotation.value()) {
                case PAST: {
                    return DateGenerators.pastDates();
                }
                case PRESENT: {
                    return DateGenerators.presentDates();
                }
                case FUTURE: {
                    return DateGenerators.futureDates();
                }
                case ANYTIME: {
                    return DateGenerators.anyTime();
                }
                case RANGE: {
                    return Values.datesInRange(annotation.startDate(), annotation.endDate());
                }
            }
            return DateGenerators.anyTime();
        }

        private static AlchemyGenerator<Date> datesInRange(long startDate, long endDate) {
            Checks.Internal.checkThat(startDate < endDate, "startDate must come before endDate");
            Date start = new Date(startDate);
            Date end = new Date(endDate);
            return DateGenerators.datesBetween((Date)start, (Date)end);
        }
    }

    public static enum Type {
        PAST,
        PRESENT,
        FUTURE,
        ANYTIME,
        RANGE;

    }
}

