/*
 * Decompiled with CFR 0.152.
 */
package sir.wellington.alchemy.collections.sets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Optional;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;

@NonInstantiable
public final class Sets {
    private static final Logger LOG = LoggerFactory.getLogger(Sets.class);

    Sets() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static <E> Set<E> create() {
        return new HashSet();
    }

    public static <E> Set<E> createFrom(@Required E first, E ... rest) {
        Arguments.checkThat(first).usingMessage("first element is required").is(Assertions.notNull());
        Set<E> set = Sets.create();
        set.add(first);
        if (rest != null) {
            set.addAll(Arrays.asList(rest));
        }
        return set;
    }

    public static <E> Set<E> emptySet() {
        Set<E> set = Sets.create();
        return Collections.unmodifiableSet(set);
    }

    public static <E> Set<E> nullToEmpty(Set<E> set) {
        return set == null ? Sets.emptySet() : set;
    }

    public static <E> Set<E> toSet(Collection<E> collection) {
        return Sets.copyOf(collection);
    }

    public static <E> Set<E> copyOf(Collection<E> collection) {
        Set<E> set = Sets.create();
        if (collection == null) {
            return set;
        }
        set.addAll(collection);
        return set;
    }

    public static boolean isEmpty(Set<?> set) {
        return Lists.isEmpty(set);
    }

    public static <E> E oneOf(@NonEmpty Set<E> set) {
        Arguments.checkThat(set).is(CollectionAssertions.nonEmptySet());
        return set.stream().findAny().get();
    }

    public static <E> Set<E> unionOf(@Optional Collection<E> first, Collection<E> ... rest) {
        Set<E> union = Sets.create();
        if (!Lists.isEmpty(first)) {
            union.addAll(first);
        }
        for (Collection<E> collection : rest) {
            union.retainAll(collection);
        }
        return union;
    }

    public static <E> boolean containTheSameElements(Collection<E> first, Collection<E> ... rest) {
        Set<E> unionOf = Sets.unionOf(first, rest);
        return !unionOf.isEmpty();
    }
}

