/*
 * Decompiled with CFR 0.152.
 */
package sir.wellington.alchemy.collections.maps;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadUnsafe;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class Maps {
    private static final Logger LOG = LoggerFactory.getLogger(Maps.class);

    Maps() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    @ThreadUnsafe
    public static <K, V> Map<K, V> create() {
        return new HashMap();
    }

    @ThreadSafe
    public static <K, V> Map<K, V> createSynchronized() {
        return new ConcurrentHashMap();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> Map<K, V> merge(Map<K, V> firstMap, Map<K, V> ... others) {
        Map result = Maps.create();
        if (!Maps.isEmpty(firstMap)) {
            result.putAll(firstMap);
        }
        if (others != null) {
            Arrays.asList(others).stream().filter(map -> !Maps.isEmpty(map)).forEach(map -> result.putAll((Map)map));
        }
        return result;
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<K, V> map) {
        return Maps.isEmpty(map) ? Collections.EMPTY_MAP : map;
    }

    public static <K, V> Map<K, V> immutableCopyOf(Map<K, V> map) throws IllegalArgumentException {
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap<K, V> copy = new HashMap<K, V>(map);
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V> Map<K, V> mutableCopyOf(Map<K, V> map) {
        return Maps.copyOf(map, () -> new HashMap());
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map, Supplier<Map<K, V>> mapSupplier) {
        Arguments.checkThat(mapSupplier).usingMessage("map supplier cannot be null").is(Assertions.notNull());
        Map<K, V> result = mapSupplier.get();
        Arguments.checkThat(result).usingMessage("supplier returned a null map").is(Assertions.notNull());
        if (!Maps.isEmpty(map)) {
            result.putAll(map);
        }
        return result;
    }
}

