/*
 * Decompiled with CFR 0.152.
 */
package sir.wellington.alchemy.collections.lists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Optional;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;

@NonInstantiable
public final class Lists {
    private static final Logger LOG = LoggerFactory.getLogger(Lists.class);

    Lists() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static boolean isEmpty(@Optional Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static <E> List<E> create() {
        return new ArrayList();
    }

    public static <E> List<E> createFrom(@Required E first, E ... rest) {
        Arguments.checkThat(first).usingMessage("missing first value").is(Assertions.notNull());
        List<E> list = Lists.create();
        list.add(first);
        if (rest != null) {
            list.addAll(Arrays.asList(rest));
        }
        return list;
    }

    public static <E> List<E> copy(@Optional Collection<E> collection) {
        List<E> list = Lists.create();
        if (Lists.isEmpty(collection)) {
            return list;
        }
        list.addAll(collection);
        return list;
    }

    public static <E> List<E> emptyList() {
        List<E> list = Lists.create();
        return Collections.unmodifiableList(list);
    }

    public static <E> List<E> toList(Collection<E> set) {
        return Lists.copy(set);
    }

    public static <E> E oneOf(@NonEmpty List<E> list) {
        Arguments.checkThat(list).usingMessage("List cannot be empty").is(Assertions.notNull()).is(CollectionAssertions.nonEmptyList());
        Random random = new Random();
        int index = random.nextInt(list.size());
        return list.get(index);
    }

    public static <E> List<E> combine(@Optional List<E> first, List<E> ... additional) {
        List<E> result = Lists.create();
        if (!Lists.isEmpty(first)) {
            result.addAll(first);
        }
        if (additional != null) {
            for (List<E> list : additional) {
                if (Lists.isEmpty(list)) continue;
                result.addAll(list);
            }
        }
        return result;
    }

    public static <E> List<E> nullToEmpty(@Optional List<E> list) {
        return list == null ? Lists.emptyList() : list;
    }
}

