/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;

@NonInstantiable
public final class TimeAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(TimeAssertions.class);

    TimeAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<Instant> inThePast() {
        return argument -> {
            Instant present = Instant.now();
            if (!argument.isBefore(present)) {
                throw new FailedAssertionException(String.format("Expected Timestamp %s to be in the past. Now: %s", argument, present));
            }
        };
    }

    public static AlchemyAssertion<Instant> before(@NonNull Instant expected) {
        Checks.Internal.checkNotNull(expected, "time cannot be null");
        return argument -> {
            Assertions.notNull().check((Instant)argument);
            if (!argument.isBefore(expected)) {
                throw new FailedAssertionException(String.format("Expected Timestamp to be before %s", expected.toString()));
            }
        };
    }

    public static AlchemyAssertion<Instant> inTheFuture() {
        return argument -> {
            Instant present = Instant.now();
            if (!argument.isAfter(present)) {
                throw new FailedAssertionException(String.format("Expected Timestamp %s to be in the future. Now: %s", argument, present));
            }
        };
    }

    public static AlchemyAssertion<Instant> after(@NonNull Instant expected) {
        Checks.Internal.checkNotNull(expected, "time cannot be null");
        return argument -> {
            Assertions.notNull().check((Instant)argument);
            if (!argument.isAfter(expected)) {
                throw new FailedAssertionException(String.format("Expected Timestamp to be after %s", expected.toString()));
            }
        };
    }

    public static AlchemyAssertion<Instant> rightNow() {
        return TimeAssertions.nowWithinDelta(5L);
    }

    public static AlchemyAssertion<Instant> nowWithinDelta(long marginOfErrorInMillis) throws IllegalArgumentException {
        Checks.Internal.checkThat(marginOfErrorInMillis >= 0L, "millis must be non-negative.");
        return instant -> {
            long now = Instant.now().toEpochMilli();
            Assertions.notNull().check((Instant)instant);
            long epoch = instant.toEpochMilli();
            long difference = Math.abs(epoch - now);
            if (difference > marginOfErrorInMillis) {
                throw new FailedAssertionException("Time difference of " + difference + " exceeded margin-of-error of " + marginOfErrorInMillis + "ms");
            }
        };
    }

    public static AlchemyAssertion<Long> epochRightNow() {
        return TimeAssertions.epochNowWithinDelta(5L);
    }

    public static AlchemyAssertion<Long> epochNowWithinDelta(long marginOfErrorInMillis) throws IllegalArgumentException {
        Checks.Internal.checkThat(marginOfErrorInMillis >= 0L, "millis must be non-negative.");
        return epoch -> {
            long now = Instant.now().toEpochMilli();
            NumberAssertions.greaterThan(0L).check((Long)epoch);
            long difference = Math.abs(epoch - now);
            if (difference > marginOfErrorInMillis) {
                throw new FailedAssertionException("Time difference of " + difference + " exceeded margin-of-error of " + marginOfErrorInMillis + "ms");
            }
        };
    }
}

