/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.util.UUID;
import java.util.regex.Pattern;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class StringAssertions {
    StringAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<String> stringThatMatches(Pattern pattern) {
        Checks.Internal.checkNotNull(pattern, "missing pattern");
        return string -> {
            if (!pattern.matcher((CharSequence)string).matches()) {
                throw new FailedAssertionException("Expected String to match pattern: " + pattern);
            }
        };
    }

    public static AlchemyAssertion<String> emptyString() {
        return string -> {
            if (!Checks.Internal.isNullOrEmpty(string)) {
                throw new FailedAssertionException("Expected empty string but got: " + string);
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLengthGreaterThanOrEqualTo(int minimumLength) {
        Checks.Internal.checkThat(minimumLength >= 0);
        return string -> {
            Assertions.notNull().check((String)string);
            if (string.length() < minimumLength) {
                throw new FailedAssertionException("Expecting a String with length >= " + minimumLength);
            }
        };
    }

    public static AlchemyAssertion<String> stringWithNoWhitespace() {
        return string -> {
            Assertions.notNull().check((String)string);
            for (char character : string.toCharArray()) {
                if (!Character.isWhitespace(character)) continue;
                throw new FailedAssertionException("Argument should not have whitespace.");
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLength(int expectedLength) {
        Checks.Internal.checkThat(expectedLength >= 0, "expectedLength must be >= 0");
        return string -> {
            Assertions.notNull().check((String)string);
            if (string.length() != expectedLength) {
                throw new FailedAssertionException("Expecting a String with length " + expectedLength);
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLengthLessThan(int upperBound) {
        Checks.Internal.checkThat(upperBound > 0, "upperBound must be > 0");
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            if (string.length() >= upperBound) {
                throw new FailedAssertionException("Expecting a String with length < " + upperBound);
            }
        };
    }

    public static AlchemyAssertion<String> stringBeginningWith(String prefix) {
        Checks.Internal.checkThat(!Checks.Internal.isNullOrEmpty(prefix), "missing prefix");
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            if (!string.startsWith(prefix)) {
                String message = String.format("Expected \"%s\" to start with \"%s\"", string, prefix);
                throw new FailedAssertionException(message);
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLengthLessThanOrEqualTo(int maximumLength) {
        Checks.Internal.checkThat(maximumLength >= 0);
        return string -> {
            Assertions.notNull().check((String)string);
            if (string == null || string.length() > maximumLength) {
                throw new FailedAssertionException("Argument exceeds the maximum string length of: " + maximumLength);
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLengthGreaterThan(int minimumLength) {
        Checks.Internal.checkThat(minimumLength > 0, "minimumLength must be > 0");
        Checks.Internal.checkThat(minimumLength < Integer.MAX_VALUE, "not possible to have a String larger than Integer.MAX_VALUE");
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            if (string.length() <= minimumLength) {
                throw new FailedAssertionException("Expected a String with length > " + minimumLength);
            }
        };
    }

    public static AlchemyAssertion<String> nonEmptyString() {
        return string -> {
            if (Checks.Internal.isNullOrEmpty(string)) {
                throw new FailedAssertionException("String argument is empty");
            }
        };
    }

    public static AlchemyAssertion<String> stringWithLengthBetween(int minimumLength, int maximumLength) {
        Checks.Internal.checkThat(minimumLength >= 0, "Minimum length must be at least 0");
        Checks.Internal.checkThat(minimumLength < maximumLength, "Minimum length must be < maximum length.");
        return string -> {
            Assertions.notNull().check((String)string);
            if (string.length() < minimumLength || string.length() > maximumLength) {
                String message = String.format("Argument size is not between acceptable range of [%d -> %d]", minimumLength, maximumLength);
                throw new FailedAssertionException(message);
            }
        };
    }

    public static AlchemyAssertion<String> stringContaining(@NonEmpty String substring) throws IllegalArgumentException {
        Checks.Internal.checkNotNullOrEmpty(substring, "substring cannot be empty");
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            if (!string.contains(substring)) {
                throw new FailedAssertionException(String.format("Expected %s to contain %s", string, substring));
            }
        };
    }

    public static AlchemyAssertion<String> allUpperCaseString() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            for (char character : string.toCharArray()) {
                if (Character.isUpperCase(character)) continue;
                throw new FailedAssertionException(String.format("Expected %s to be all upper-case, but %s isn't", string, Character.valueOf(character)));
            }
        };
    }

    public static AlchemyAssertion<String> allLowerCaseString() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            for (char character : string.toCharArray()) {
                if (Character.isLowerCase(character)) continue;
                throw new FailedAssertionException(String.format("Expected %s to be all lower-case, but %s isn't", string, Character.valueOf(character)));
            }
        };
    }

    public static AlchemyAssertion<String> stringEndingWith(@NonEmpty String suffix) throws IllegalArgumentException {
        Checks.Internal.checkNotNullOrEmpty(suffix, "string should not be empty");
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            if (!string.endsWith(suffix)) {
                throw new FailedAssertionException(String.format("Expected %s to end with %s", string, suffix));
            }
        };
    }

    public static AlchemyAssertion<String> alphabeticString() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            for (char character : string.toCharArray()) {
                if (Character.isAlphabetic(character)) continue;
                throw new FailedAssertionException(String.format("Expected alphabetic string, but '%s' is not alphabetic", Character.valueOf(character)));
            }
        };
    }

    public static AlchemyAssertion<String> alphanumericString() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            for (char character : string.toCharArray()) {
                if (Character.isAlphabetic(character) || Character.isDigit(character)) continue;
                throw new FailedAssertionException(String.format("Expected alphanumeric string, but chracter '%s' is not", Character.valueOf(character)));
            }
        };
    }

    public static AlchemyAssertion<String> validUUID() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            try {
                UUID.fromString(string);
            }
            catch (Exception ex) {
                throw new FailedAssertionException("String is not a valid UUID: " + string);
            }
        };
    }

    public static AlchemyAssertion<String> stringRepresentingInteger() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            for (int i = 0; i < string.length(); ++i) {
                char character = string.charAt(i);
                if (i == 0 && StringAssertions.isSignCharacter(character) || Character.isDigit(character)) continue;
                throw new FailedAssertionException(String.format("Expected an Integer String, but %s is not a digi", Character.valueOf(character)));
            }
        };
    }

    private static boolean isSignCharacter(char character) {
        return character == '-' || character == '+';
    }
}

