/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.util.regex.Pattern;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@NonInstantiable
public final class PeopleAssertions {
    private static final Pattern PATTERN = Pattern.compile("^.+@.+\\..+$");

    PeopleAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<String> validEmailAddress() {
        return email -> {
            if (Checks.Internal.isNullOrEmpty(email)) {
                throw new FailedAssertionException("Email is null or empty");
            }
            if (!PATTERN.matcher((CharSequence)email).matches()) {
                throw new FailedAssertionException("Invalid Email Address: " + PATTERN);
            }
        };
    }
}

