/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class NumberAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(NumberAssertions.class);

    NumberAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<Integer> greaterThan(int exclusiveLowerBound) {
        Checks.Internal.checkThat(exclusiveLowerBound != Integer.MAX_VALUE, "Integers cannot exceed 2147483647");
        return integer -> {
            Assertions.notNull().check((Integer)integer);
            if (integer <= exclusiveLowerBound) {
                throw new FailedAssertionException("Number must be > " + exclusiveLowerBound);
            }
        };
    }

    public static AlchemyAssertion<Long> greaterThan(long exclusiveLowerBound) {
        Checks.Internal.checkThat(exclusiveLowerBound != Long.MAX_VALUE, "Longs cannot exceed 9223372036854775807");
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number <= exclusiveLowerBound) {
                throw new FailedAssertionException("Number must be > " + exclusiveLowerBound);
            }
        };
    }

    public static AlchemyAssertion<Integer> greaterThanOrEqualTo(int lowerBound) {
        return number -> {
            Assertions.notNull().check((Integer)number);
            if (number < lowerBound) {
                throw new FailedAssertionException("Number must be greater than or equal to " + lowerBound);
            }
        };
    }

    public static AlchemyAssertion<Long> greaterThanOrEqualTo(long lowerBound) {
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number < lowerBound) {
                throw new FailedAssertionException("Number must be greater than or equal to " + lowerBound);
            }
        };
    }

    public static AlchemyAssertion<Integer> positiveInteger() {
        return number -> {
            Assertions.notNull().check((Integer)number);
            if (number <= 0) {
                throw new FailedAssertionException("Expected positive integer: " + number);
            }
        };
    }

    public static AlchemyAssertion<Integer> negativeInteger() {
        return NumberAssertions.lessThan(0);
    }

    public static AlchemyAssertion<Integer> lessThanOrEqualTo(int inclusiveUpperBound) {
        return number -> {
            Assertions.notNull().check((Integer)number);
            if (number > inclusiveUpperBound) {
                throw new FailedAssertionException("Number must be less than or equal to " + inclusiveUpperBound);
            }
        };
    }

    public static AlchemyAssertion<Long> lessThanOrEqualTo(long inclusiveUpperBound) {
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number > inclusiveUpperBound) {
                throw new FailedAssertionException("Number must be less than or equal to " + inclusiveUpperBound);
            }
        };
    }

    public static AlchemyAssertion<Long> positiveLong() {
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number <= 0L) {
                throw new FailedAssertionException("Expected positive long: " + number);
            }
        };
    }

    public static AlchemyAssertion<Long> negativeLong() {
        return NumberAssertions.lessThan(0L);
    }

    public static AlchemyAssertion<Integer> lessThan(int exclusiveUpperBound) {
        Checks.Internal.checkThat(exclusiveUpperBound != Integer.MIN_VALUE, "Ints cannot be less than -2147483648");
        return number -> {
            Assertions.notNull().check((Integer)number);
            if (number >= exclusiveUpperBound) {
                throw new FailedAssertionException("Number must be < " + exclusiveUpperBound);
            }
        };
    }

    public static AlchemyAssertion<Long> lessThan(long exclusiveUpperBound) {
        Checks.Internal.checkThat(exclusiveUpperBound != Long.MIN_VALUE, "Longs cannot be less than -9223372036854775808");
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number >= exclusiveUpperBound) {
                throw new FailedAssertionException("Number must be < " + exclusiveUpperBound);
            }
        };
    }

    public static AlchemyAssertion<Integer> numberBetween(int min, int max) throws IllegalArgumentException {
        Checks.Internal.checkThat(min < max, "Minimum must be less than Max.");
        return number -> {
            Assertions.notNull().check((Integer)number);
            if (number < min || number > max) {
                String message = String.format("Expected a number between %d and %d but got %d instead", min, max, number);
                throw new FailedAssertionException(message);
            }
        };
    }

    public static AlchemyAssertion<Long> numberBetween(long min, long max) throws IllegalArgumentException {
        Checks.Internal.checkThat(min < max, "Minimum must be less than Max.");
        return number -> {
            Assertions.notNull().check((Long)number);
            if (number < min || number > max) {
                String message = String.format("Expected a number between %d and %d but got %d instead", min, max, number);
                throw new FailedAssertionException(message);
            }
        };
    }
}

