/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
public final class NetworkAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkAssertions.class);
    private static final int MAX_PORT = 65535;

    NetworkAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<String> validURL() {
        return string -> {
            StringAssertions.nonEmptyString().check((String)string);
            try {
                URL uRL = new URL((String)string);
            }
            catch (Exception ex) {
                throw new FailedAssertionException("Invalid URL: " + string, ex);
            }
        };
    }

    public static AlchemyAssertion<Integer> validPort() {
        return port -> {
            if (port <= 0) {
                throw new FailedAssertionException("Network port must be > 0");
            }
            if (port > 65535) {
                throw new FailedAssertionException("Network port must <65535");
            }
        };
    }
}

