/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class DateAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(DateAssertions.class);

    DateAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<Date> inThePast() {
        return argument -> {
            Date present = new Date();
            if (!argument.before(present)) {
                throw new FailedAssertionException(String.format("Expected Date %s to be in the past", argument));
            }
        };
    }

    public static AlchemyAssertion<Date> before(@NonNull Date expected) {
        Checks.Internal.checkNotNull(expected, "date cannot be null");
        return argument -> {
            Assertions.notNull().check((Date)argument);
            if (!argument.before(expected)) {
                throw new FailedAssertionException(String.format("Expected Date to be before %s", expected.toInstant().toString()));
            }
        };
    }

    public static AlchemyAssertion<Date> inTheFuture() {
        return argument -> {
            Date present = new Date();
            if (!argument.after(present)) {
                throw new FailedAssertionException(String.format("Expected Date to be in the future", argument));
            }
        };
    }

    public static AlchemyAssertion<Date> after(@NonNull Date expected) {
        Checks.Internal.checkNotNull(expected, "date cannot be null");
        return date -> {
            Assertions.notNull().check((Date)date);
            if (!date.after(expected)) {
                throw new FailedAssertionException(String.format("Expected Date to be after %s", expected.toInstant().toString()));
            }
        };
    }
}

