/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class CollectionAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionAssertions.class);

    CollectionAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static <E> AlchemyAssertion<Collection<E>> nonEmptyCollection() {
        return collection -> {
            Assertions.notNull().check((Collection)collection);
            if (collection.isEmpty()) {
                throw new FailedAssertionException("Collection is empty");
            }
        };
    }

    public static <E> AlchemyAssertion<List<E>> nonEmptyList() {
        return list -> {
            Assertions.notNull().check((List)list);
            if (list.isEmpty()) {
                throw new FailedAssertionException("List is empty");
            }
        };
    }

    public static <E> AlchemyAssertion<Set<E>> nonEmptySet() {
        return set -> {
            Assertions.notNull().check((Set)set);
            if (set.isEmpty()) {
                throw new FailedAssertionException("Set is empty");
            }
        };
    }

    public static <K, V> AlchemyAssertion<Map<K, V>> nonEmptyMap() {
        return map -> {
            Assertions.notNull().check((Map)map);
            if (map.isEmpty()) {
                throw new FailedAssertionException("Map is empty");
            }
        };
    }

    public static <E> AlchemyAssertion<E[]> nonEmptyArray() {
        return array -> {
            Assertions.notNull().check((Object[])array);
            if (((Object[])array).length == 0) {
                throw new FailedAssertionException("Array is empty");
            }
        };
    }

    public static <E> AlchemyAssertion<Collection<E>> emptyCollection() {
        return collection -> {
            Assertions.notNull().check((Collection)collection);
            if (!collection.isEmpty()) {
                throw new FailedAssertionException(String.format("Expected an empty collection, but it has size [%s]", collection.size()));
            }
        };
    }

    public static <E> AlchemyAssertion<List<E>> emptyList() {
        return list -> CollectionAssertions.emptyCollection().check((Collection)list);
    }

    public static <E> AlchemyAssertion<Set<E>> emptySet() {
        return set -> CollectionAssertions.emptyCollection().check((Collection)set);
    }

    public static <E> AlchemyAssertion<List<E>> listContaining(@NonNull E element) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(element, "cannot check for null");
        return list -> {
            Assertions.notNull().check((List)list);
            if (!list.contains(element)) {
                throw new FailedAssertionException(element + " not found in List");
            }
        };
    }

    public static <K, V> AlchemyAssertion<Map<K, V>> mapWithKey(@NonNull K key) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(key, "key cannot be null");
        return map -> {
            Assertions.notNull().check((Map)map);
            if (!map.containsKey(key)) {
                throw new FailedAssertionException(String.format("Expected Key %s in Map", key));
            }
        };
    }

    public static <K, V> AlchemyAssertion<Map<K, V>> mapWithKeyValue(@NonNull K key, V value) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(key, "key cannot be null");
        return map -> {
            CollectionAssertions.mapWithKey(key).check((Map)map);
            Object valueInMap = map.get(key);
            if (!Objects.equals(value, valueInMap)) {
                throw new FailedAssertionException(String.format("Value in Map [%s] does not match expcted value %s", valueInMap, value));
            }
        };
    }

    public static <K, V> AlchemyAssertion<K> keyInMap(Map<K, V> map) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(map, "map cannot be null");
        Consumer<Object> failAssertion = key -> {
            throw new FailedAssertionException(String.format("Expected key [%s] to be in map", key));
        };
        return key -> {
            Assertions.notNull().check(key);
            if (!map.containsKey(key)) {
                failAssertion.accept(key);
            }
        };
    }

    public static <K, V> AlchemyAssertion<V> valueInMap(Map<K, V> map) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(map, "map cannot be null");
        Consumer<Object> failAssertion = key -> {
            throw new FailedAssertionException(String.format("Expected value [%s] to be in map", key));
        };
        return value -> {
            Assertions.notNull().check(value);
            if (!map.containsValue(value)) {
                failAssertion.accept(value);
            }
        };
    }

    public static <E> AlchemyAssertion<E> elementInCollection(@NonEmpty Collection<E> collection) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(collection, "collection cannot be null");
        return element -> {
            Assertions.notNull().check(element);
            if (!collection.contains(element)) {
                throw new FailedAssertionException(String.format("Expected element [%s] to be in collection", element));
            }
        };
    }

    public static <C extends Collection> AlchemyAssertion<C> collectionOfSize(int size) throws IllegalArgumentException {
        Checks.Internal.checkThat(size >= 0, "size must be >= 0");
        return collection -> {
            CollectionAssertions.nonEmptyCollection().check((Collection)collection);
            int actualSize = collection.size();
            if (actualSize != size) {
                throw new FailedAssertionException(String.format("Expected collection with size [%s] but is instead [%s]", size, actualSize));
            }
        };
    }
}

