/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public final class BooleanAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanAssertions.class);

    private BooleanAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<Boolean> trueStatement() {
        return b -> {
            Assertions.notNull().check((Boolean)b);
            if (!b.booleanValue()) {
                throw new FailedAssertionException("Condition not met");
            }
        };
    }

    public static AlchemyAssertion<Boolean> falseStatement() {
        return b -> {
            Assertions.notNull().check((Boolean)b);
            BooleanAssertions.trueStatement().check(b == false);
        };
    }
}

