/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments.assertions;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.arguments.Nullable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@NonInstantiable
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(Assertions.class);

    Assertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate class");
    }

    public static <A> AlchemyAssertion<A> notNull() {
        return reference -> {
            if (reference == null) {
                throw new FailedAssertionException("Argument is null");
            }
        };
    }

    public static <A> AlchemyAssertion<A> sameInstanceAs(@Nullable Object other) {
        return argument -> {
            if (argument == null && other == null) {
                return;
            }
            if (argument != other) {
                throw new FailedAssertionException("Expected " + argument + " to be the same instance as " + other);
            }
        };
    }

    public static <A> AlchemyAssertion<A> instanceOf(Class<?> classOfExpectedType) {
        Checks.Internal.checkNotNull(classOfExpectedType, "class cannot be null");
        return argument -> {
            Assertions.notNull().check(argument);
            if (!classOfExpectedType.isInstance(argument)) {
                throw new FailedAssertionException("Expected Object of type: " + classOfExpectedType);
            }
        };
    }

    public static <A> AlchemyAssertion<A> equalTo(@Nullable A other) {
        return argument -> {
            if (!Objects.equals(argument, other)) {
                throw new FailedAssertionException(String.format("Expected %s to be equal to %s", argument, other));
            }
        };
    }

    public static <A> AlchemyAssertion<A> not(@NonNull AlchemyAssertion<A> assertion) {
        Checks.Internal.checkNotNull(assertion, "missing assertion");
        return argument -> {
            try {
                assertion.check(argument);
            }
            catch (FailedAssertionException ex) {
                return;
            }
            throw new FailedAssertionException("Expected assertion to fail, but it passed: " + assertion);
        };
    }
}

