/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@Internal
@Immutable
final class DynamicExceptionSupplier<Ex extends Throwable>
implements ExceptionMapper<Ex> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicExceptionSupplier.class);
    private final Class<Ex> exceptionClass;
    private final String message;

    DynamicExceptionSupplier(Class<Ex> exceptionClass, String message) {
        Checks.Internal.checkNotNull(exceptionClass, "missing exceptionClass");
        this.exceptionClass = exceptionClass;
        this.message = message;
    }

    @Override
    public Ex apply(FailedAssertionException cause) {
        Ex instance = this.tryToCreateInstance(cause);
        return instance;
    }

    private Ex tryToCreateInstance(FailedAssertionException cause) {
        try {
            if (this.haveBothAMessageAndACause(this.message, cause)) {
                if (this.throwableClassHasMessageAndCauseConstructor()) {
                    return (Ex)((Throwable)this.exceptionClass.getConstructor(String.class, Throwable.class).newInstance(this.message, cause));
                }
                if (this.throwableClassHasCauseConstructor()) {
                    return (Ex)((Throwable)this.exceptionClass.getConstructor(Throwable.class).newInstance(cause));
                }
                if (this.throwableClassHasMessageConstructor()) {
                    return (Ex)((Throwable)this.exceptionClass.getConstructor(String.class).newInstance(this.message));
                }
            }
            if (this.haveOnlyACause(this.message, cause) && this.throwableClassHasCauseConstructor()) {
                return (Ex)((Throwable)this.exceptionClass.getConstructor(Throwable.class).newInstance(cause));
            }
            if (this.haveOnlyAMessage(this.message, cause) && this.throwableClassHasMessageConstructor()) {
                return (Ex)((Throwable)this.exceptionClass.getConstructor(String.class).newInstance(this.message));
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to initialize instance of Exception type {}", this.exceptionClass, (Object)ex);
        }
        try {
            if (this.hasDefaultConstructor()) {
                return (Ex)((Throwable)this.exceptionClass.newInstance());
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to create instance of {} using default constructor", (Object)this.exceptionClass.getName());
        }
        return null;
    }

    public String toString() {
        return "DynamicExceptionSupplier{exceptionClass=" + this.exceptionClass + ", message=" + this.message + '}';
    }

    private boolean hasConstructorWithArguments(Class<?> ... classes) throws NoSuchMethodException, SecurityException {
        try {
            Constructor<Ex> constructor = this.exceptionClass.getConstructor(classes);
            return constructor != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private boolean hasDefaultConstructor() throws NoSuchMethodException, SecurityException {
        return this.hasConstructorWithArguments(new Class[0]);
    }

    private boolean throwableClassHasCauseConstructor() throws NoSuchMethodException, SecurityException {
        return this.hasConstructorWithArguments(Throwable.class);
    }

    private boolean throwableClassHasMessageConstructor() throws NoSuchMethodException, SecurityException {
        return this.hasConstructorWithArguments(String.class);
    }

    private boolean throwableClassHasMessageAndCauseConstructor() throws NoSuchMethodException, SecurityException {
        return this.hasConstructorWithArguments(String.class, Throwable.class);
    }

    private boolean haveOnlyAMessage(String message, FailedAssertionException cause) {
        return !Checks.Internal.isNullOrEmpty(message) && cause == null;
    }

    private boolean haveOnlyACause(String message, FailedAssertionException cause) {
        return cause != null && Checks.Internal.isNullOrEmpty(message);
    }

    private boolean haveBothAMessageAndACause(String message, FailedAssertionException cause) {
        return cause != null && !Checks.Internal.isNullOrEmpty(message);
    }

    @Internal
    Class<Ex> getExceptionClass() {
        return this.exceptionClass;
    }
}

