/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;

@NonInstantiable
@tech.sirwellington.alchemy.annotations.access.Internal
public final class Checks {
    private static final Logger LOG = LoggerFactory.getLogger(Checks.class);

    private Checks() throws IllegalAccessException {
        throw new IllegalAccessException("not meant to be instantiated");
    }

    @NonInstantiable
    @tech.sirwellington.alchemy.annotations.access.Internal
    public static class Internal {
        private Internal() throws IllegalAccessException {
            throw new IllegalAccessException("not meant to be instantiated");
        }

        public static boolean isNullOrEmpty(String string) {
            return string == null || string.isEmpty();
        }

        public static boolean isNullOrEmpty(Collection<?> collection) {
            return collection == null || collection.isEmpty();
        }

        public static void checkNotNull(Object reference) throws IllegalArgumentException {
            Internal.checkNotNull(reference, "");
        }

        public static void checkNotNull(Object reference, String message) throws IllegalArgumentException {
            Internal.checkThat(reference != null, message);
        }

        public static void checkState(boolean predicate, String message) throws IllegalStateException {
            if (!predicate) {
                throw new IllegalStateException(message);
            }
        }

        public static void checkThat(boolean predicate) throws IllegalArgumentException {
            Internal.checkThat(predicate, "");
        }

        public static void checkThat(boolean predicate, String message) throws IllegalArgumentException {
            if (!predicate) {
                throw new IllegalArgumentException(message);
            }
        }

        public static void checkNotNullOrEmpty(String string) throws IllegalArgumentException {
            Internal.checkThat(!Internal.isNullOrEmpty(string));
        }

        public static void checkNotNullOrEmpty(String string, String message) throws IllegalArgumentException {
            Internal.checkThat(!Internal.isNullOrEmpty(string), message);
        }
    }
}

