/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.AssertionBuilder;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.DynamicExceptionSupplier;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@FluidAPIDesign
@StrategyPattern(role=StrategyPattern.Role.CLIENT)
@Immutable
@Internal
final class AssertionBuilderImpl<Argument, Ex extends Throwable>
implements AssertionBuilder<Argument, Ex> {
    private static final Logger LOG = LoggerFactory.getLogger(AssertionBuilderImpl.class);
    private final AlchemyAssertion<Argument> assertion;
    private final ExceptionMapper<Ex> exceptionMapper;
    @Immutable
    private final List<Argument> arguments;
    private final String overrideMessage;

    private AssertionBuilderImpl(AlchemyAssertion<Argument> assertion, ExceptionMapper<Ex> exceptionMapper, String overrideMessage, List<Argument> arguments) {
        this.assertion = assertion;
        this.exceptionMapper = exceptionMapper;
        this.overrideMessage = overrideMessage;
        this.arguments = arguments;
    }

    @Override
    public AssertionBuilder<Argument, Ex> usingMessage(String message) {
        Checks.Internal.checkThat(!Checks.Internal.isNullOrEmpty(message), "error message is empty");
        ExceptionMapper<Ex> newExceptionMapper = this.exceptionMapper instanceof DynamicExceptionSupplier ? this.createUpdatedDynamicExceptionMapperWithMessage(message) : this.exceptionMapper;
        return new AssertionBuilderImpl<Argument, Ex>(this.assertion, newExceptionMapper, message, this.arguments);
    }

    static <Argument> AssertionBuilderImpl<Argument, FailedAssertionException> checkThat(List<Argument> arguments) {
        return new AssertionBuilderImpl<Argument, FailedAssertionException>(null, ExceptionMapper.IDENTITY, "", arguments);
    }

    @Override
    public <Ex extends Throwable> AssertionBuilderImpl<Argument, Ex> throwing(ExceptionMapper<Ex> exceptionMapper) {
        Checks.Internal.checkNotNull(exceptionMapper, "exceptionMapper is null");
        return new AssertionBuilderImpl<Argument, Ex>(null, exceptionMapper, this.overrideMessage, this.arguments);
    }

    @Override
    public <Ex extends Throwable> AssertionBuilder<Argument, Ex> throwing(Class<Ex> exceptionClass) {
        Checks.Internal.checkNotNull(exceptionClass);
        return this.throwing((ExceptionMapper)new DynamicExceptionSupplier<Ex>(exceptionClass, this.overrideMessage));
    }

    @Override
    public AssertionBuilderImpl<Argument, Ex> is(AlchemyAssertion<Argument> assertion) throws Ex {
        Checks.Internal.checkNotNull(assertion, "assertion is null");
        AssertionBuilderImpl<Argument, Ex> newBuilder = new AssertionBuilderImpl<Argument, Ex>(assertion, this.exceptionMapper, this.overrideMessage, this.arguments);
        super.checkAssertion();
        return newBuilder;
    }

    private void checkAssertion() throws Ex {
        Checks.Internal.checkState(this.assertion != null, "no assertion found");
        Checks.Internal.checkState(this.exceptionMapper != null, "no exceptionMapper found");
        FailedAssertionException caught = null;
        try {
            this.arguments.forEach(this.assertion::check);
        }
        catch (FailedAssertionException ex) {
            caught = ex;
            if (!Checks.Internal.isNullOrEmpty(this.overrideMessage)) {
                caught.changeMessage(this.overrideMessage);
            }
        }
        catch (RuntimeException ex) {
            this.handleUnexpectedException(ex);
        }
        if (this.exceptionOccured(caught)) {
            this.handleFailedAssertion(caught);
        }
    }

    private boolean exceptionOccured(FailedAssertionException caught) {
        return caught != null;
    }

    private void handleUnexpectedException(RuntimeException ex) throws Ex {
        LOG.warn("Assertion {} threw an unexpected exception. Only {} Exceptions are acceptable for Assertions.", new Object[]{this.assertion, FailedAssertionException.class.getSimpleName(), ex});
        FailedAssertionException wrappedException = new FailedAssertionException("wrapping unexpected exception", ex);
        this.handleFailedAssertion(wrappedException);
    }

    private void handleFailedAssertion(FailedAssertionException caught) throws Ex {
        Ex mappedEx = this.exceptionMapper.apply(caught);
        if (mappedEx != null) {
            throw mappedEx;
        }
        LOG.warn("Exception Mapper did not return a throwable. Swallowing exception", (Throwable)caught);
    }

    private ExceptionMapper<Ex> createUpdatedDynamicExceptionMapperWithMessage(String message) {
        DynamicExceptionSupplier dynamicExceptionMapper = (DynamicExceptionSupplier)this.exceptionMapper;
        Class exceptionClass = dynamicExceptionMapper.getExceptionClass();
        return new DynamicExceptionSupplier(exceptionClass, message);
    }
}

