/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.DynamicExceptionSupplier;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;

@FluidAPIDesign
public interface AssertionBuilder<Argument, Ex extends Throwable> {
    public AssertionBuilder<Argument, Ex> usingMessage(@NonEmpty String var1);

    public <Ex extends Throwable> AssertionBuilder<Argument, Ex> throwing(@NonNull ExceptionMapper<Ex> var1);

    public AssertionBuilder<Argument, Ex> is(@NonNull AlchemyAssertion<Argument> var1) throws Ex;

    default public AssertionBuilder<Argument, Ex> are(@NonNull AlchemyAssertion<Argument> assertion) throws Ex {
        return this.is(assertion);
    }

    default public <Ex extends Throwable> AssertionBuilder<Argument, Ex> throwing(@NonNull Class<Ex> exceptionClass) {
        return this.throwing(new DynamicExceptionSupplier<Ex>(exceptionClass, ""));
    }
}

