/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Nullable;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.arguments.AssertionBuilder;
import tech.sirwellington.alchemy.arguments.AssertionBuilderImpl;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@NonInstantiable
@FluidAPIDesign
public final class Arguments {
    private static final Logger LOG = LoggerFactory.getLogger(Arguments.class);

    Arguments() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate class");
    }

    public static <Argument> AssertionBuilder<Argument, FailedAssertionException> checkThat(@Nullable Argument argument) {
        return AssertionBuilderImpl.checkThat(Arrays.asList(argument));
    }

    public static <Argument> AssertionBuilder<Argument, FailedAssertionException> checkThat(@Nullable Argument argument, Argument ... others) {
        ArrayList<Argument> listOfArguments = new ArrayList<Argument>();
        listOfArguments.add(argument);
        if (others != null) {
            listOfArguments.addAll(Arrays.asList(others));
        }
        return AssertionBuilderImpl.checkThat(listOfArguments);
    }
}

