/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.arguments;

import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.arguments.Nullable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;

@FunctionalInterface
@StrategyPattern(role=StrategyPattern.Role.INTERFACE)
public interface AlchemyAssertion<A> {
    public void check(@Nullable A var1) throws FailedAssertionException;

    @NonNull
    default public AlchemyAssertion<A> and(@NonNull AlchemyAssertion<A> other) throws IllegalArgumentException {
        Checks.Internal.checkNotNull(other, "assertion cannot be null");
        return argument -> {
            this.check(argument);
            other.check(argument);
        };
    }

    public static <T> AlchemyAssertion<T> combine(@NonNull AlchemyAssertion<T> first, AlchemyAssertion<T> ... other) {
        Checks.Internal.checkNotNull(first, "the first AlchemyAssertion cannot be null");
        Checks.Internal.checkNotNull(other, "null varargs");
        return argument -> {
            first.check(argument);
            for (AlchemyAssertion assertion : other) {
                assertion.check(argument);
            }
        };
    }
}

