/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.thrift.clients;

import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;

@NonInstantiable
public class Clients {
    private static final Logger LOG = LoggerFactory.getLogger(Clients.class);

    Clients() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static void attemptClose(Object client) throws TException {
        if (client == null) {
            return;
        }
        if (!(client instanceof TServiceClient)) {
            return;
        }
        TServiceClient thriftClient = (TServiceClient)client;
        Clients.close(thriftClient);
    }

    public static void attemptCloseSilently(Object client) {
        try {
            Clients.attemptClose(client);
        }
        catch (TException ex) {
            LOG.info("Could not silently close client: {}", client, (Object)ex);
        }
    }

    public static void close(TServiceClient client) throws TException {
        if (client != null) {
            try {
                if (client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
                    client.getInputProtocol().getTransport().close();
                }
                if (client.getOutputProtocol() != null && client.getOutputProtocol().getTransport() != null) {
                    client.getOutputProtocol().getTransport().close();
                }
            }
            catch (Exception ex) {
                throw new TException((Throwable)ex);
            }
        }
    }

    public static void closeSilently(TServiceClient client) {
        try {
            Clients.close(client);
        }
        catch (TException ex) {
            LOG.error("Failed to close Thrift Client {}", (Object)client, (Object)ex);
        }
    }
}

