/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.thrift;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
public class ThriftObjects {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftObjects.class);
    private static final Gson GSON = new Gson();

    private ThriftObjects() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static <T extends TBase> String toPrettyJson(@NonNull T object) throws TException {
        Arguments.checkThat(object).is(Assertions.notNull());
        TSimpleJSONProtocol.Factory protocol = new TSimpleJSONProtocol.Factory();
        TSerializer serializer = new TSerializer((TProtocolFactory)protocol);
        byte[] data = serializer.serialize(object);
        String json = new String(data, StandardCharsets.UTF_8);
        LOG.debug("TObject {} converted to Pretty JSON: {}", object, (Object)json);
        return json;
    }

    public static <T extends TBase> T fromPrettyJson(@NonNull T prototype, @NonEmpty String json) throws TException {
        Arguments.checkThat(prototype).usingMessage("missing prototype").is(Assertions.notNull());
        if (ThriftObjects.isNullOrEmpty(json)) {
            LOG.warn("JSON String is empty");
            return prototype;
        }
        Class<?> clazz = prototype.getClass();
        TBase object = (TBase)GSON.fromJson(json, clazz);
        LOG.debug("Prototype TObject inflated to {} from json {}", (Object)object, (Object)json);
        return (T)object;
    }

    public static <T extends TBase> String toJson(@NonNull T object) throws TException {
        Arguments.checkThat(object).is(Assertions.notNull());
        TJSONProtocol.Factory protocol = new TJSONProtocol.Factory();
        TSerializer serializer = new TSerializer((TProtocolFactory)protocol);
        byte[] data = serializer.serialize(object);
        String json = new String(data, StandardCharsets.UTF_8);
        LOG.debug("TObject {} converted to JSON: {}", object, (Object)json);
        return json;
    }

    public static <T extends TBase> T fromJson(@NonNull T prototype, @NonEmpty String json) throws TException {
        Arguments.checkThat(prototype).usingMessage("missing prototype").is(Assertions.notNull());
        if (ThriftObjects.isNullOrEmpty(json)) {
            LOG.warn("JSON String is empty");
            return prototype;
        }
        TJSONProtocol.Factory protocol = new TJSONProtocol.Factory();
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)protocol);
        deserializer.deserialize(prototype, json, StandardCharsets.UTF_8.name());
        LOG.debug("Prototype TObject inflated to {} from json {}", prototype, (Object)json);
        return prototype;
    }

    public static <T extends TBase> byte[] toBinary(@NonNull T object) throws TException {
        Arguments.checkThat(object).is(Assertions.notNull());
        TBinaryProtocol.Factory protocol = new TBinaryProtocol.Factory(true, true);
        TSerializer serializer = new TSerializer((TProtocolFactory)protocol);
        byte[] data = serializer.serialize(object);
        LOG.debug("TObject {} converted to binary of length {}", (Object)data.length);
        return data;
    }

    public static <T extends TBase> T fromBinary(@NonNull T prototype, @NonEmpty byte[] binary) throws TException {
        Arguments.checkThat(prototype).usingMessage("missing prototype").is(Assertions.notNull());
        if (binary == null || binary.length == 0) {
            LOG.warn("missing binary: {}", (Object)binary);
            return prototype;
        }
        TBinaryProtocol.Factory protocol = new TBinaryProtocol.Factory(true, true);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)protocol);
        deserializer.deserialize(prototype, binary);
        LOG.debug("Binary with length {} deserialized into TObject {}", (Object)binary.length, (Object)protocol);
        return prototype;
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

