/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.BaselineDimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/VerticalWidgetRun;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "<init>", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "baseline", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "getBaseline", "()Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "setBaseline", "(Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;)V", "mBaselineDimension", "Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "getMBaselineDimension", "()Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "setMBaselineDimension", "(Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;)V", "toString", "", "clear", "", "reset", "supportsWrapComputation", "", "update", "node", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "apply", "applyToWidget", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class VerticalWidgetRun
extends WidgetRun {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DependencyNode baseline;
    @Nullable
    private DimensionDependency mBaselineDimension;
    public static final int $stable = 8;
    private static final boolean FORCE_USE = true;

    public VerticalWidgetRun(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        super(widget);
        this.baseline = new DependencyNode(this);
        this.getStart().setMType(DependencyNode.Type.TOP);
        this.getEnd().setMType(DependencyNode.Type.BOTTOM);
        this.baseline.setMType(DependencyNode.Type.BASELINE);
        this.setOrientation(1);
    }

    @NotNull
    public final DependencyNode getBaseline() {
        return this.baseline;
    }

    public final void setBaseline(@NotNull DependencyNode dependencyNode) {
        Intrinsics.checkNotNullParameter((Object)dependencyNode, (String)"<set-?>");
        this.baseline = dependencyNode;
    }

    @Nullable
    public final DimensionDependency getMBaselineDimension() {
        return this.mBaselineDimension;
    }

    public final void setMBaselineDimension(@Nullable DimensionDependency dimensionDependency) {
        this.mBaselineDimension = dimensionDependency;
    }

    @NotNull
    public String toString() {
        ConstraintWidget constraintWidget = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        return "VerticalRun " + constraintWidget.getDebugName();
    }

    @Override
    public void clear() {
        this.setMRunGroup(null);
        this.getStart().clear();
        this.getEnd().clear();
        this.baseline.clear();
        this.getMDimension().clear();
        this.setMResolved(false);
    }

    @Override
    public void reset() {
        this.setMResolved(false);
        this.getStart().clear();
        this.getStart().setResolved(false);
        this.getEnd().clear();
        this.getEnd().setResolved(false);
        this.baseline.clear();
        this.baseline.setResolved(false);
        this.getMDimension().setResolved(false);
    }

    @Override
    public boolean supportsWrapComputation() {
        boolean bl;
        if (super.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            ConstraintWidget constraintWidget = super.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            bl = constraintWidget.getMMatchConstraintDefaultHeight() == 0;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void update(@NotNull Dependency node) {
        DependencyNode startTarget;
        int endPos;
        int startPos;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getMRunType$compose().ordinal()]) {
            case 1: {
                this.updateRunStart(node);
                break;
            }
            case 2: {
                this.updateRunEnd(node);
                break;
            }
            case 3: {
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                ConstraintAnchor constraintAnchor = constraintWidget.getMTop();
                ConstraintWidget constraintWidget2 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                this.updateRunCenter(node, constraintAnchor, constraintWidget2.getMBottom(), 1);
                return;
            }
        }
        if (this.getMDimension().getReadyToSolve() && !this.getMDimension().getResolved() && this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            switch (constraintWidget.getMMatchConstraintDefaultHeight()) {
                case 3: {
                    ConstraintWidget constraintWidget3 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    HorizontalWidgetRun horizontalWidgetRun = constraintWidget3.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    if (!horizontalWidgetRun.getMDimension().getResolved()) break;
                    int size = 0;
                    ConstraintWidget constraintWidget4 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget4);
                    int ratioSide = constraintWidget4.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            ConstraintWidget constraintWidget5 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget5);
                            HorizontalWidgetRun horizontalWidgetRun2 = constraintWidget5.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                            float f = horizontalWidgetRun2.getMDimension().getValue();
                            ConstraintWidget constraintWidget6 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget6);
                            size = (int)(0.5f + f * constraintWidget6.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            ConstraintWidget constraintWidget7 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget7);
                            HorizontalWidgetRun horizontalWidgetRun3 = constraintWidget7.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                            float f = horizontalWidgetRun3.getMDimension().getValue();
                            ConstraintWidget constraintWidget8 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget8);
                            size = (int)(0.5f + f / constraintWidget8.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            ConstraintWidget constraintWidget9 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget9);
                            HorizontalWidgetRun horizontalWidgetRun4 = constraintWidget9.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                            float f = horizontalWidgetRun4.getMDimension().getValue();
                            ConstraintWidget constraintWidget10 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget10);
                            size = (int)(0.5f + f / constraintWidget10.getDimensionRatio());
                        }
                    }
                    this.getMDimension().resolve(size);
                    break;
                }
                case 2: {
                    ConstraintWidget constraintWidget11 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget11);
                    ConstraintWidget parent = constraintWidget11.getParent();
                    if (parent == null) break;
                    VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    if (!verticalWidgetRun.getMDimension().getResolved()) break;
                    ConstraintWidget constraintWidget12 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget12);
                    float percent = constraintWidget12.getMMatchConstraintPercentHeight();
                    VerticalWidgetRun verticalWidgetRun2 = parent.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                    int targetDimensionValue = verticalWidgetRun2.getMDimension().getValue();
                    int size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.getMDimension().resolve(size);
                }
            }
        }
        if (!this.getStart().getReadyToSolve() || !this.getEnd().getReadyToSolve()) {
            return;
        }
        if (this.getStart().getResolved() && this.getEnd().getResolved() && this.getMDimension().getResolved()) {
            return;
        }
        if (!this.getMDimension().getResolved() && this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            if (constraintWidget.getMMatchConstraintDefaultWidth() == 0) {
                ConstraintWidget constraintWidget13 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget13);
                if (!constraintWidget13.isInVerticalChain()) {
                    DependencyNode dependencyNode = this.getStart().getMTargets().get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)dependencyNode, (String)"get(...)");
                    DependencyNode startTarget2 = dependencyNode;
                    DependencyNode dependencyNode2 = this.getEnd().getMTargets().get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)dependencyNode2, (String)"get(...)");
                    DependencyNode endTarget = dependencyNode2;
                    startPos = startTarget2.getValue() + this.getStart().getMMargin();
                    endPos = endTarget.getValue() + this.getEnd().getMMargin();
                    int distance = endPos - startPos;
                    this.getStart().resolve(startPos);
                    this.getEnd().resolve(endPos);
                    this.getMDimension().resolve(distance);
                    return;
                }
            }
        }
        if (!this.getMDimension().getResolved() && this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.getMatchConstraintsType() == 1 && this.getStart().getMTargets().size() > 0 && this.getEnd().getMTargets().size() > 0) {
            DependencyNode dependencyNode = this.getStart().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)dependencyNode, (String)"get(...)");
            startTarget = dependencyNode;
            DependencyNode dependencyNode3 = this.getEnd().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)dependencyNode3, (String)"get(...)");
            DependencyNode endTarget = dependencyNode3;
            startPos = startTarget.getValue() + this.getStart().getMMargin();
            endPos = endTarget.getValue() + this.getEnd().getMMargin();
            int availableSpace = endPos - startPos;
            if (availableSpace < this.getMDimension().getWrapValue()) {
                this.getMDimension().resolve(availableSpace);
            } else {
                this.getMDimension().resolve(this.getMDimension().getWrapValue());
            }
        }
        if (!this.getMDimension().getResolved()) {
            return;
        }
        if (this.getStart().getMTargets().size() > 0 && this.getEnd().getMTargets().size() > 0) {
            DependencyNode dependencyNode = this.getStart().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)dependencyNode, (String)"get(...)");
            startTarget = dependencyNode;
            DependencyNode dependencyNode4 = this.getEnd().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)dependencyNode4, (String)"get(...)");
            DependencyNode endTarget = dependencyNode4;
            startPos = startTarget.getValue() + this.getStart().getMMargin();
            endPos = endTarget.getValue() + this.getEnd().getMMargin();
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            float bias = constraintWidget.getVerticalBiasPercent();
            if (Intrinsics.areEqual((Object)startTarget, (Object)endTarget)) {
                startPos = startTarget.getValue();
                endPos = endTarget.getValue();
                bias = 0.5f;
            }
            int distance = endPos - startPos - this.getMDimension().getValue();
            this.getStart().resolve((int)(0.5f + (float)startPos + (float)distance * bias));
            this.getEnd().resolve(this.getStart().getValue() + this.getMDimension().getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void apply() {
        block49: {
            DependencyNode top;
            DependencyNode target;
            block51: {
                block50: {
                    block48: {
                        DependencyNode startTarget;
                        block47: {
                            block46: {
                                block45: {
                                    ConstraintWidget parent;
                                    block44: {
                                        ConstraintWidget constraintWidget = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget);
                                        if (constraintWidget.getMeasured()) {
                                            DimensionDependency dimensionDependency = this.getMDimension();
                                            ConstraintWidget constraintWidget2 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget2);
                                            dimensionDependency.resolve(constraintWidget2.getHeight());
                                        }
                                        if (this.getMDimension().getResolved()) break block44;
                                        ConstraintWidget constraintWidget3 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget3);
                                        super.setMDimensionBehavior(constraintWidget3.getVerticalDimensionBehaviour());
                                        ConstraintWidget constraintWidget4 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget4);
                                        if (constraintWidget4.getHasBaseline()) {
                                            this.mBaselineDimension = new BaselineDimensionDependency(this);
                                        }
                                        if (super.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                                            if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                                                ConstraintWidget constraintWidget5 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget5);
                                                parent = constraintWidget5.getParent();
                                                if (parent != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
                                                    int n = parent.getHeight();
                                                    ConstraintWidget constraintWidget6 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget6);
                                                    int n2 = n - constraintWidget6.getMTop().getMargin();
                                                    ConstraintWidget constraintWidget7 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget7);
                                                    int resolvedDimension = n2 - constraintWidget7.getMBottom().getMargin();
                                                    DependencyNode dependencyNode = this.getStart();
                                                    VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                                                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                                    DependencyNode dependencyNode2 = verticalWidgetRun.getStart();
                                                    ConstraintWidget constraintWidget8 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget8);
                                                    this.addTarget(dependencyNode, dependencyNode2, constraintWidget8.getMTop().getMargin());
                                                    DependencyNode dependencyNode3 = this.getEnd();
                                                    VerticalWidgetRun verticalWidgetRun2 = parent.getMVerticalRun();
                                                    Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                                                    DependencyNode dependencyNode4 = verticalWidgetRun2.getEnd();
                                                    ConstraintWidget constraintWidget9 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget9);
                                                    this.addTarget(dependencyNode3, dependencyNode4, -constraintWidget9.getMBottom().getMargin());
                                                    this.getMDimension().resolve(resolvedDimension);
                                                    return;
                                                }
                                            }
                                            if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.FIXED) {
                                                DimensionDependency dimensionDependency = this.getMDimension();
                                                ConstraintWidget constraintWidget10 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget10);
                                                dimensionDependency.resolve(constraintWidget10.getHeight());
                                            }
                                        }
                                        break block45;
                                    }
                                    if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                                        ConstraintWidget constraintWidget = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget);
                                        parent = constraintWidget.getParent();
                                        if (parent != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
                                            DependencyNode dependencyNode = this.getStart();
                                            VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                                            Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                            DependencyNode dependencyNode5 = verticalWidgetRun.getStart();
                                            ConstraintWidget constraintWidget11 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget11);
                                            this.addTarget(dependencyNode, dependencyNode5, constraintWidget11.getMTop().getMargin());
                                            DependencyNode dependencyNode6 = this.getEnd();
                                            VerticalWidgetRun verticalWidgetRun3 = parent.getMVerticalRun();
                                            Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                                            DependencyNode dependencyNode7 = verticalWidgetRun3.getEnd();
                                            ConstraintWidget constraintWidget12 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget12);
                                            this.addTarget(dependencyNode6, dependencyNode7, -constraintWidget12.getMBottom().getMargin());
                                            return;
                                        }
                                    }
                                }
                                if (this.getMDimension().getResolved()) {
                                    ConstraintWidget constraintWidget = this.getMWidget();
                                    Intrinsics.checkNotNull((Object)constraintWidget);
                                    if (constraintWidget.getMeasured()) {
                                        ConstraintWidget constraintWidget13 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget13);
                                        if (constraintWidget13.getMListAnchors()[2].getMTarget() != null) {
                                            ConstraintWidget constraintWidget14 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget14);
                                            if (constraintWidget14.getMListAnchors()[3].getMTarget() != null) {
                                                ConstraintWidget constraintWidget15 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget15);
                                                if (constraintWidget15.isInVerticalChain()) {
                                                    DependencyNode dependencyNode = this.getStart();
                                                    ConstraintWidget constraintWidget16 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget16);
                                                    dependencyNode.setMMargin(constraintWidget16.getMListAnchors()[2].getMargin());
                                                    DependencyNode dependencyNode8 = this.getEnd();
                                                    ConstraintWidget constraintWidget17 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget17);
                                                    dependencyNode8.setMMargin(-constraintWidget17.getMListAnchors()[3].getMargin());
                                                } else {
                                                    ConstraintWidget constraintWidget18 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget18);
                                                    startTarget = this.getTarget(constraintWidget18.getMListAnchors()[2]);
                                                    if (startTarget != null) {
                                                        DependencyNode dependencyNode = this.getStart();
                                                        ConstraintWidget constraintWidget19 = this.getMWidget();
                                                        Intrinsics.checkNotNull((Object)constraintWidget19);
                                                        this.addTarget(dependencyNode, startTarget, constraintWidget19.getMListAnchors()[2].getMargin());
                                                    }
                                                    ConstraintWidget constraintWidget20 = this.getMWidget();
                                                    Intrinsics.checkNotNull((Object)constraintWidget20);
                                                    DependencyNode endTarget = this.getTarget(constraintWidget20.getMListAnchors()[3]);
                                                    if (endTarget != null) {
                                                        DependencyNode dependencyNode = this.getEnd();
                                                        ConstraintWidget constraintWidget21 = this.getMWidget();
                                                        Intrinsics.checkNotNull((Object)constraintWidget21);
                                                        this.addTarget(dependencyNode, endTarget, -constraintWidget21.getMListAnchors()[3].getMargin());
                                                    }
                                                    this.getStart().setDelegateToWidgetRun(true);
                                                    this.getEnd().setDelegateToWidgetRun(true);
                                                }
                                                ConstraintWidget constraintWidget22 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget22);
                                                if (!constraintWidget22.getHasBaseline()) return;
                                                DependencyNode dependencyNode = this.getStart();
                                                ConstraintWidget constraintWidget23 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget23);
                                                this.addTarget(this.baseline, dependencyNode, constraintWidget23.getBaselineDistance());
                                                return;
                                            }
                                        }
                                        ConstraintWidget constraintWidget24 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget24);
                                        if (constraintWidget24.getMListAnchors()[2].getMTarget() != null) {
                                            ConstraintWidget constraintWidget25 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget25);
                                            target = this.getTarget(constraintWidget25.getMListAnchors()[2]);
                                            if (target == null) return;
                                            DependencyNode dependencyNode = this.getStart();
                                            ConstraintWidget constraintWidget26 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget26);
                                            this.addTarget(dependencyNode, target, constraintWidget26.getMListAnchors()[2].getMargin());
                                            this.addTarget(this.getEnd(), this.getStart(), this.getMDimension().getValue());
                                            ConstraintWidget constraintWidget27 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget27);
                                            if (!constraintWidget27.getHasBaseline()) return;
                                            DependencyNode dependencyNode9 = this.getStart();
                                            ConstraintWidget constraintWidget28 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget28);
                                            this.addTarget(this.baseline, dependencyNode9, constraintWidget28.getBaselineDistance());
                                            return;
                                        }
                                        ConstraintWidget constraintWidget29 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget29);
                                        if (constraintWidget29.getMListAnchors()[3].getMTarget() != null) {
                                            ConstraintWidget constraintWidget30 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget30);
                                            target = this.getTarget(constraintWidget30.getMListAnchors()[3]);
                                            if (target != null) {
                                                DependencyNode dependencyNode = this.getEnd();
                                                ConstraintWidget constraintWidget31 = this.getMWidget();
                                                Intrinsics.checkNotNull((Object)constraintWidget31);
                                                this.addTarget(dependencyNode, target, -constraintWidget31.getMListAnchors()[3].getMargin());
                                                this.addTarget(this.getStart(), this.getEnd(), -this.getMDimension().getValue());
                                            }
                                            ConstraintWidget constraintWidget32 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget32);
                                            if (!constraintWidget32.getHasBaseline()) return;
                                            DependencyNode dependencyNode = this.getStart();
                                            ConstraintWidget constraintWidget33 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget33);
                                            this.addTarget(this.baseline, dependencyNode, constraintWidget33.getBaselineDistance());
                                            return;
                                        }
                                        ConstraintWidget constraintWidget34 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget34);
                                        if (constraintWidget34.getMListAnchors()[4].getMTarget() != null) {
                                            ConstraintWidget constraintWidget35 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget35);
                                            target = this.getTarget(constraintWidget35.getMListAnchors()[4]);
                                            if (target == null) return;
                                            this.addTarget(this.baseline, target, 0);
                                            DependencyNode dependencyNode = this.getStart();
                                            ConstraintWidget constraintWidget36 = this.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget36);
                                            this.addTarget(dependencyNode, this.baseline, -constraintWidget36.getBaselineDistance());
                                            this.addTarget(this.getEnd(), this.getStart(), this.getMDimension().getValue());
                                            return;
                                        }
                                        if (this.getMWidget() instanceof Helper) return;
                                        ConstraintWidget constraintWidget37 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget37);
                                        if (constraintWidget37.getParent() == null) return;
                                        ConstraintWidget constraintWidget38 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget38);
                                        ConstraintAnchor constraintAnchor = constraintWidget38.getAnchor(ConstraintAnchor.Type.CENTER);
                                        Intrinsics.checkNotNull((Object)constraintAnchor);
                                        if (constraintAnchor.getMTarget() != null) return;
                                        ConstraintWidget constraintWidget39 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget39);
                                        ConstraintWidget constraintWidget40 = constraintWidget39.getParent();
                                        Intrinsics.checkNotNull((Object)constraintWidget40);
                                        VerticalWidgetRun verticalWidgetRun = constraintWidget40.getMVerticalRun();
                                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                        top = verticalWidgetRun.getStart();
                                        DependencyNode dependencyNode = this.getStart();
                                        ConstraintWidget constraintWidget41 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget41);
                                        this.addTarget(dependencyNode, top, constraintWidget41.getY());
                                        this.addTarget(this.getEnd(), this.getStart(), this.getMDimension().getValue());
                                        ConstraintWidget constraintWidget42 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget42);
                                        if (!constraintWidget42.getHasBaseline()) return;
                                        DependencyNode dependencyNode10 = this.getStart();
                                        ConstraintWidget constraintWidget43 = this.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget43);
                                        this.addTarget(this.baseline, dependencyNode10, constraintWidget43.getBaselineDistance());
                                        return;
                                    }
                                }
                                if (this.getMDimension().getResolved() || this.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block46;
                                ConstraintWidget constraintWidget = this.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget);
                                switch (constraintWidget.getMMatchConstraintDefaultHeight()) {
                                    case 3: {
                                        VerticalWidgetRun $this$apply_u24lambda_u240 = this;
                                        boolean bl = false;
                                        ConstraintWidget constraintWidget44 = $this$apply_u24lambda_u240.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget44);
                                        if (!constraintWidget44.isInVerticalChain()) {
                                            ConstraintWidget constraintWidget45 = $this$apply_u24lambda_u240.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget45);
                                            if (constraintWidget45.getMMatchConstraintDefaultWidth() == 3) break;
                                            ConstraintWidget constraintWidget46 = $this$apply_u24lambda_u240.getMWidget();
                                            Intrinsics.checkNotNull((Object)constraintWidget46);
                                            HorizontalWidgetRun horizontalWidgetRun = constraintWidget46.getMHorizontalRun();
                                            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                                            DependencyNode targetDimension = horizontalWidgetRun.getMDimension();
                                            $this$apply_u24lambda_u240.getMDimension().getMTargets().add(targetDimension);
                                            targetDimension.getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                                            $this$apply_u24lambda_u240.getMDimension().setDelegateToWidgetRun(true);
                                            $this$apply_u24lambda_u240.getMDimension().getMDependencies().add($this$apply_u24lambda_u240.getStart());
                                            $this$apply_u24lambda_u240.getMDimension().getMDependencies().add($this$apply_u24lambda_u240.getEnd());
                                            break;
                                        }
                                        break block47;
                                    }
                                    case 2: {
                                        VerticalWidgetRun $this$apply_u24lambda_u241 = this;
                                        boolean bl = false;
                                        ConstraintWidget constraintWidget47 = $this$apply_u24lambda_u241.getMWidget();
                                        Intrinsics.checkNotNull((Object)constraintWidget47);
                                        ConstraintWidget constraintWidget48 = constraintWidget47.getParent();
                                        if (constraintWidget48 == null) break;
                                        ConstraintWidget parent = constraintWidget48;
                                        VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                        DependencyNode targetDimension = verticalWidgetRun.getMDimension();
                                        $this$apply_u24lambda_u241.getMDimension().getMTargets().add(targetDimension);
                                        targetDimension.getMDependencies().add($this$apply_u24lambda_u241.getMDimension());
                                        $this$apply_u24lambda_u241.getMDimension().setDelegateToWidgetRun(true);
                                        $this$apply_u24lambda_u241.getMDimension().getMDependencies().add($this$apply_u24lambda_u241.getStart());
                                        $this$apply_u24lambda_u241.getMDimension().getMDependencies().add($this$apply_u24lambda_u241.getEnd());
                                    }
                                }
                                break block47;
                            }
                            this.getMDimension().addDependency(this);
                        }
                        ConstraintWidget constraintWidget = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget);
                        if (constraintWidget.getMListAnchors()[2].getMTarget() == null) break block48;
                        ConstraintWidget constraintWidget49 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget49);
                        if (constraintWidget49.getMListAnchors()[3].getMTarget() == null) break block48;
                        ConstraintWidget constraintWidget50 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget50);
                        if (constraintWidget50.isInVerticalChain()) {
                            DependencyNode dependencyNode = this.getStart();
                            ConstraintWidget constraintWidget51 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget51);
                            dependencyNode.setMMargin(constraintWidget51.getMListAnchors()[2].getMargin());
                            DependencyNode dependencyNode11 = this.getEnd();
                            ConstraintWidget constraintWidget52 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget52);
                            dependencyNode11.setMMargin(-constraintWidget52.getMListAnchors()[3].getMargin());
                        } else {
                            ConstraintWidget constraintWidget53 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget53);
                            startTarget = this.getTarget(constraintWidget53.getMListAnchors()[2]);
                            ConstraintWidget constraintWidget54 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget54);
                            DependencyNode endTarget = this.getTarget(constraintWidget54.getMListAnchors()[3]);
                            DependencyNode dependencyNode = startTarget;
                            if (dependencyNode != null) {
                                dependencyNode.addDependency(this);
                            }
                            DependencyNode dependencyNode12 = endTarget;
                            if (dependencyNode12 != null) {
                                dependencyNode12.addDependency(this);
                            }
                            this.setMRunType$compose(WidgetRun.RunType.CENTER);
                        }
                        ConstraintWidget constraintWidget55 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget55);
                        if (constraintWidget55.getHasBaseline()) {
                            DependencyNode dependencyNode = this.getStart();
                            DimensionDependency dimensionDependency = this.mBaselineDimension;
                            Intrinsics.checkNotNull((Object)dimensionDependency);
                            this.addTarget(this.baseline, dependencyNode, 1, dimensionDependency);
                        }
                        break block49;
                    }
                    ConstraintWidget constraintWidget = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget);
                    if (constraintWidget.getMListAnchors()[2].getMTarget() == null) break block50;
                    ConstraintWidget constraintWidget56 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget56);
                    target = this.getTarget(constraintWidget56.getMListAnchors()[2]);
                    if (target == null) break block49;
                    DependencyNode dependencyNode = this.getStart();
                    ConstraintWidget constraintWidget57 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget57);
                    this.addTarget(dependencyNode, target, constraintWidget57.getMListAnchors()[2].getMargin());
                    this.addTarget(this.getEnd(), this.getStart(), 1, this.getMDimension());
                    ConstraintWidget constraintWidget58 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget58);
                    if (constraintWidget58.getHasBaseline()) {
                        DependencyNode dependencyNode13 = this.getStart();
                        DimensionDependency dimensionDependency = this.mBaselineDimension;
                        Intrinsics.checkNotNull((Object)dimensionDependency);
                        this.addTarget(this.baseline, dependencyNode13, 1, dimensionDependency);
                    }
                    if (this.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block49;
                    ConstraintWidget constraintWidget59 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget59);
                    if (constraintWidget59.getDimensionRatio() > 0.0f) {
                        ConstraintWidget constraintWidget60 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget60);
                        HorizontalWidgetRun horizontalWidgetRun = constraintWidget60.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                        if (horizontalWidgetRun.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            ConstraintWidget constraintWidget61 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget61);
                            HorizontalWidgetRun horizontalWidgetRun2 = constraintWidget61.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                            horizontalWidgetRun2.getMDimension().getMDependencies().add(this.getMDimension());
                            ArrayList<DependencyNode> arrayList = this.getMDimension().getMTargets();
                            ConstraintWidget constraintWidget62 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget62);
                            HorizontalWidgetRun horizontalWidgetRun3 = constraintWidget62.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                            arrayList.add(horizontalWidgetRun3.getMDimension());
                            this.getMDimension().setUpdateDelegate(this);
                        }
                    }
                    break block49;
                }
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                if (constraintWidget.getMListAnchors()[3].getMTarget() == null) break block51;
                ConstraintWidget constraintWidget63 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget63);
                target = this.getTarget(constraintWidget63.getMListAnchors()[3]);
                if (target != null) {
                    DependencyNode dependencyNode = this.getEnd();
                    ConstraintWidget constraintWidget64 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget64);
                    this.addTarget(dependencyNode, target, -constraintWidget64.getMListAnchors()[3].getMargin());
                    this.addTarget(this.getStart(), this.getEnd(), -1, this.getMDimension());
                    ConstraintWidget constraintWidget65 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget65);
                    if (constraintWidget65.getHasBaseline()) {
                        DependencyNode dependencyNode14 = this.getStart();
                        DimensionDependency dimensionDependency = this.mBaselineDimension;
                        Intrinsics.checkNotNull((Object)dimensionDependency);
                        this.addTarget(this.baseline, dependencyNode14, 1, dimensionDependency);
                    }
                }
                break block49;
            }
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            if (constraintWidget.getMListAnchors()[4].getMTarget() != null) {
                ConstraintWidget constraintWidget66 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget66);
                target = this.getTarget(constraintWidget66.getMListAnchors()[4]);
                if (target != null) {
                    this.addTarget(this.baseline, target, 0);
                    DependencyNode dependencyNode = this.getStart();
                    DimensionDependency dimensionDependency = this.mBaselineDimension;
                    Intrinsics.checkNotNull((Object)dimensionDependency);
                    this.addTarget(dependencyNode, this.baseline, -1, dimensionDependency);
                    this.addTarget(this.getEnd(), this.getStart(), 1, this.getMDimension());
                }
            } else if (!(this.getMWidget() instanceof Helper)) {
                ConstraintWidget constraintWidget67 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget67);
                if (constraintWidget67.getParent() != null) {
                    ConstraintWidget constraintWidget68 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget68);
                    ConstraintWidget constraintWidget69 = constraintWidget68.getParent();
                    Intrinsics.checkNotNull((Object)constraintWidget69);
                    VerticalWidgetRun verticalWidgetRun = constraintWidget69.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    top = verticalWidgetRun.getStart();
                    DependencyNode dependencyNode = this.getStart();
                    ConstraintWidget constraintWidget70 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget70);
                    this.addTarget(dependencyNode, top, constraintWidget70.getY());
                    this.addTarget(this.getEnd(), this.getStart(), 1, this.getMDimension());
                    ConstraintWidget constraintWidget71 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget71);
                    if (constraintWidget71.getHasBaseline()) {
                        DependencyNode dependencyNode15 = this.getStart();
                        DimensionDependency dimensionDependency = this.mBaselineDimension;
                        Intrinsics.checkNotNull((Object)dimensionDependency);
                        this.addTarget(this.baseline, dependencyNode15, 1, dimensionDependency);
                    }
                    if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        ConstraintWidget constraintWidget72 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget72);
                        if (constraintWidget72.getDimensionRatio() > 0.0f) {
                            ConstraintWidget constraintWidget73 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget73);
                            HorizontalWidgetRun horizontalWidgetRun = constraintWidget73.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                            if (horizontalWidgetRun.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                                ConstraintWidget constraintWidget74 = this.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget74);
                                HorizontalWidgetRun horizontalWidgetRun4 = constraintWidget74.getMHorizontalRun();
                                Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                                horizontalWidgetRun4.getMDimension().getMDependencies().add(this.getMDimension());
                                ArrayList<DependencyNode> arrayList = this.getMDimension().getMTargets();
                                ConstraintWidget constraintWidget75 = this.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget75);
                                HorizontalWidgetRun horizontalWidgetRun5 = constraintWidget75.getMHorizontalRun();
                                Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
                                arrayList.add(horizontalWidgetRun5.getMDimension());
                                this.getMDimension().setUpdateDelegate(this);
                            }
                        }
                    }
                }
            }
        }
        if (this.getMDimension().getMTargets().size() != 0) return;
        this.getMDimension().setReadyToSolve(true);
    }

    @Override
    public void applyToWidget() {
        if (this.getStart().getResolved()) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            constraintWidget.setY(this.getStart().getValue());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/VerticalWidgetRun$Companion;", "", "<init>", "()V", "FORCE_USE", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WidgetRun.RunType.values().length];
            try {
                nArray[WidgetRun.RunType.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetRun.RunType.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetRun.RunType.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

