/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J@\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016\u00a8\u0006\u001e"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/HorizontalWidgetRun;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "<init>", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "toString", "", "clear", "", "reset", "supportsWrapComputation", "", "apply", "computeInsetRatio", "dimensions", "", "x1", "", "x2", "y1", "y2", "ratio", "", "side", "update", "node", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "applyToWidget", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class HorizontalWidgetRun
extends WidgetRun {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    @NotNull
    private static final int[] sTempDimensions = new int[2];

    public HorizontalWidgetRun(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        super(widget);
        this.getStart().setMType(DependencyNode.Type.LEFT);
        this.getEnd().setMType(DependencyNode.Type.RIGHT);
        this.setOrientation(0);
    }

    @NotNull
    public String toString() {
        ConstraintWidget constraintWidget = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        return "HorizontalRun " + constraintWidget.getDebugName();
    }

    @Override
    public void clear() {
        this.setMRunGroup(null);
        this.getStart().clear();
        this.getEnd().clear();
        this.getMDimension().clear();
        this.setMResolved(false);
    }

    @Override
    public void reset() {
        this.setMResolved(false);
        this.getStart().clear();
        this.getStart().setResolved(false);
        this.getEnd().clear();
        this.getEnd().setResolved(false);
        this.getMDimension().setResolved(false);
    }

    @Override
    public boolean supportsWrapComputation() {
        boolean bl;
        if (super.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            ConstraintWidget constraintWidget = super.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            bl = constraintWidget.getMMatchConstraintDefaultWidth() == 0;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void apply() {
        DependencyNode left;
        DependencyNode target;
        DependencyNode startTarget;
        block32: {
            ConstraintWidget parent;
            block31: {
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                if (constraintWidget.getMeasured()) {
                    DimensionDependency dimensionDependency = this.getMDimension();
                    ConstraintWidget constraintWidget2 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget2);
                    dimensionDependency.resolve(constraintWidget2.getWidth());
                }
                if (this.getMDimension().getResolved()) break block31;
                ConstraintWidget constraintWidget3 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget3);
                super.setMDimensionBehavior(constraintWidget3.getHorizontalDimensionBehaviour());
                if (super.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        ConstraintWidget constraintWidget4 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget4);
                        parent = constraintWidget4.getParent();
                        if (parent != null && (parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
                            int n = parent.getWidth();
                            ConstraintWidget constraintWidget5 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget5);
                            int n2 = n - constraintWidget5.getMLeft().getMargin();
                            ConstraintWidget constraintWidget6 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget6);
                            int resolvedDimension = n2 - constraintWidget6.getMRight().getMargin();
                            DependencyNode dependencyNode = this.getStart();
                            HorizontalWidgetRun horizontalWidgetRun = parent.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                            DependencyNode dependencyNode2 = horizontalWidgetRun.getStart();
                            ConstraintWidget constraintWidget7 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget7);
                            this.addTarget(dependencyNode, dependencyNode2, constraintWidget7.getMLeft().getMargin());
                            DependencyNode dependencyNode3 = this.getEnd();
                            HorizontalWidgetRun horizontalWidgetRun2 = parent.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                            DependencyNode dependencyNode4 = horizontalWidgetRun2.getEnd();
                            ConstraintWidget constraintWidget8 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget8);
                            this.addTarget(dependencyNode3, dependencyNode4, -constraintWidget8.getMRight().getMargin());
                            this.getMDimension().resolve(resolvedDimension);
                            return;
                        }
                    }
                    if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.FIXED) {
                        DimensionDependency dimensionDependency = this.getMDimension();
                        ConstraintWidget constraintWidget9 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget9);
                        dimensionDependency.resolve(constraintWidget9.getWidth());
                    }
                }
                break block32;
            }
            if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                parent = constraintWidget.getParent();
                if (parent != null && (parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
                    DependencyNode dependencyNode = this.getStart();
                    HorizontalWidgetRun horizontalWidgetRun = parent.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    DependencyNode dependencyNode5 = horizontalWidgetRun.getStart();
                    ConstraintWidget constraintWidget10 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget10);
                    this.addTarget(dependencyNode, dependencyNode5, constraintWidget10.getMLeft().getMargin());
                    DependencyNode dependencyNode6 = this.getEnd();
                    HorizontalWidgetRun horizontalWidgetRun3 = parent.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                    DependencyNode dependencyNode7 = horizontalWidgetRun3.getEnd();
                    ConstraintWidget constraintWidget11 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget11);
                    this.addTarget(dependencyNode6, dependencyNode7, -constraintWidget11.getMRight().getMargin());
                    return;
                }
            }
        }
        if (this.getMDimension().getResolved()) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            if (constraintWidget.getMeasured()) {
                ConstraintWidget constraintWidget12 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget12);
                if (constraintWidget12.getMListAnchors()[0].getMTarget() != null) {
                    ConstraintWidget constraintWidget13 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget13);
                    if (constraintWidget13.getMListAnchors()[1].getMTarget() != null) {
                        ConstraintWidget constraintWidget14 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget14);
                        if (constraintWidget14.isInHorizontalChain()) {
                            DependencyNode dependencyNode = this.getStart();
                            ConstraintWidget constraintWidget15 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget15);
                            dependencyNode.setMMargin(constraintWidget15.getMListAnchors()[0].getMargin());
                            DependencyNode dependencyNode8 = this.getEnd();
                            ConstraintWidget constraintWidget16 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget16);
                            dependencyNode8.setMMargin(-constraintWidget16.getMListAnchors()[1].getMargin());
                            return;
                        }
                        ConstraintWidget constraintWidget17 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget17);
                        startTarget = this.getTarget(constraintWidget17.getMListAnchors()[0]);
                        if (startTarget != null) {
                            DependencyNode dependencyNode = this.getStart();
                            ConstraintWidget constraintWidget18 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget18);
                            this.addTarget(dependencyNode, startTarget, constraintWidget18.getMListAnchors()[0].getMargin());
                        }
                        ConstraintWidget constraintWidget19 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget19);
                        DependencyNode endTarget = this.getTarget(constraintWidget19.getMListAnchors()[1]);
                        if (endTarget != null) {
                            DependencyNode dependencyNode = this.getEnd();
                            ConstraintWidget constraintWidget20 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget20);
                            this.addTarget(dependencyNode, endTarget, -constraintWidget20.getMListAnchors()[1].getMargin());
                        }
                        this.getStart().setDelegateToWidgetRun(true);
                        this.getEnd().setDelegateToWidgetRun(true);
                        return;
                    }
                }
                ConstraintWidget constraintWidget21 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget21);
                if (constraintWidget21.getMListAnchors()[0].getMTarget() != null) {
                    ConstraintWidget constraintWidget22 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget22);
                    target = this.getTarget(constraintWidget22.getMListAnchors()[0]);
                    if (target == null) return;
                    DependencyNode dependencyNode = this.getStart();
                    ConstraintWidget constraintWidget23 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget23);
                    this.addTarget(dependencyNode, target, constraintWidget23.getMListAnchors()[0].getMargin());
                    this.addTarget(this.getEnd(), this.getStart(), this.getMDimension().getValue());
                    return;
                }
                ConstraintWidget constraintWidget24 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget24);
                if (constraintWidget24.getMListAnchors()[1].getMTarget() != null) {
                    ConstraintWidget constraintWidget25 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget25);
                    target = this.getTarget(constraintWidget25.getMListAnchors()[1]);
                    if (target == null) return;
                    DependencyNode dependencyNode = this.getEnd();
                    ConstraintWidget constraintWidget26 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget26);
                    this.addTarget(dependencyNode, target, -constraintWidget26.getMListAnchors()[1].getMargin());
                    this.addTarget(this.getStart(), this.getEnd(), -this.getMDimension().getValue());
                    return;
                }
                if (this.getMWidget() instanceof Helper) return;
                ConstraintWidget constraintWidget27 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget27);
                if (constraintWidget27.getParent() == null) return;
                ConstraintWidget constraintWidget28 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget28);
                ConstraintAnchor constraintAnchor = constraintWidget28.getAnchor(ConstraintAnchor.Type.CENTER);
                Intrinsics.checkNotNull((Object)constraintAnchor);
                if (constraintAnchor.getMTarget() != null) return;
                ConstraintWidget constraintWidget29 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget29);
                ConstraintWidget constraintWidget30 = constraintWidget29.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget30);
                HorizontalWidgetRun horizontalWidgetRun = constraintWidget30.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                left = horizontalWidgetRun.getStart();
                DependencyNode dependencyNode = this.getStart();
                ConstraintWidget constraintWidget31 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget31);
                this.addTarget(dependencyNode, left, constraintWidget31.getX());
                this.addTarget(this.getEnd(), this.getStart(), this.getMDimension().getValue());
                return;
            }
        }
        if (this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            switch (constraintWidget.getMMatchConstraintDefaultWidth()) {
                case 3: {
                    HorizontalWidgetRun $this$apply_u24lambda_u240 = this;
                    boolean bl = false;
                    ConstraintWidget constraintWidget32 = $this$apply_u24lambda_u240.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget32);
                    if (constraintWidget32.getMMatchConstraintDefaultHeight() == 3) {
                        boolean bl2;
                        $this$apply_u24lambda_u240.getStart().setUpdateDelegate($this$apply_u24lambda_u240);
                        $this$apply_u24lambda_u240.getEnd().setUpdateDelegate($this$apply_u24lambda_u240);
                        ConstraintWidget constraintWidget33 = $this$apply_u24lambda_u240.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget33);
                        VerticalWidgetRun verticalWidgetRun = constraintWidget33.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                        verticalWidgetRun.getStart().setUpdateDelegate($this$apply_u24lambda_u240);
                        ConstraintWidget constraintWidget34 = $this$apply_u24lambda_u240.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget34);
                        VerticalWidgetRun verticalWidgetRun2 = constraintWidget34.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                        verticalWidgetRun2.getEnd().setUpdateDelegate($this$apply_u24lambda_u240);
                        $this$apply_u24lambda_u240.getMDimension().setUpdateDelegate($this$apply_u24lambda_u240);
                        ConstraintWidget constraintWidget35 = $this$apply_u24lambda_u240.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget35);
                        if (constraintWidget35.isInVerticalChain()) {
                            ArrayList<DependencyNode> arrayList = $this$apply_u24lambda_u240.getMDimension().getMTargets();
                            ConstraintWidget constraintWidget36 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget36);
                            VerticalWidgetRun verticalWidgetRun3 = constraintWidget36.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                            arrayList.add(verticalWidgetRun3.getMDimension());
                            ConstraintWidget constraintWidget37 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget37);
                            VerticalWidgetRun verticalWidgetRun4 = constraintWidget37.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                            verticalWidgetRun4.getMDimension().getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                            ConstraintWidget constraintWidget38 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget38);
                            VerticalWidgetRun verticalWidgetRun5 = constraintWidget38.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun5);
                            verticalWidgetRun5.getMDimension().setUpdateDelegate($this$apply_u24lambda_u240);
                            ArrayList<DependencyNode> arrayList2 = $this$apply_u24lambda_u240.getMDimension().getMTargets();
                            ConstraintWidget constraintWidget39 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget39);
                            VerticalWidgetRun verticalWidgetRun6 = constraintWidget39.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun6);
                            arrayList2.add(verticalWidgetRun6.getStart());
                            ArrayList<DependencyNode> arrayList3 = $this$apply_u24lambda_u240.getMDimension().getMTargets();
                            ConstraintWidget constraintWidget40 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget40);
                            VerticalWidgetRun verticalWidgetRun7 = constraintWidget40.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun7);
                            arrayList3.add(verticalWidgetRun7.getEnd());
                            ConstraintWidget constraintWidget41 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget41);
                            VerticalWidgetRun verticalWidgetRun8 = constraintWidget41.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun8);
                            verticalWidgetRun8.getStart().getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                            ConstraintWidget constraintWidget42 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget42);
                            VerticalWidgetRun verticalWidgetRun9 = constraintWidget42.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun9);
                            bl2 = verticalWidgetRun9.getEnd().getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                            break;
                        }
                        ConstraintWidget constraintWidget43 = $this$apply_u24lambda_u240.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget43);
                        if (constraintWidget43.isInHorizontalChain()) {
                            ConstraintWidget constraintWidget44 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget44);
                            VerticalWidgetRun verticalWidgetRun10 = constraintWidget44.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun10);
                            verticalWidgetRun10.getMDimension().getMTargets().add($this$apply_u24lambda_u240.getMDimension());
                            ArrayList<Dependency> arrayList = $this$apply_u24lambda_u240.getMDimension().getMDependencies();
                            ConstraintWidget constraintWidget45 = $this$apply_u24lambda_u240.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget45);
                            VerticalWidgetRun verticalWidgetRun11 = constraintWidget45.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun11);
                            bl2 = arrayList.add(verticalWidgetRun11.getMDimension());
                            break;
                        }
                        ConstraintWidget constraintWidget46 = $this$apply_u24lambda_u240.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget46);
                        VerticalWidgetRun verticalWidgetRun12 = constraintWidget46.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun12);
                        bl2 = verticalWidgetRun12.getMDimension().getMTargets().add($this$apply_u24lambda_u240.getMDimension());
                        break;
                    }
                    ConstraintWidget constraintWidget47 = $this$apply_u24lambda_u240.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget47);
                    VerticalWidgetRun verticalWidgetRun = constraintWidget47.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    DependencyNode targetDimension = verticalWidgetRun.getMDimension();
                    $this$apply_u24lambda_u240.getMDimension().getMTargets().add(targetDimension);
                    targetDimension.getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                    ConstraintWidget constraintWidget48 = $this$apply_u24lambda_u240.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget48);
                    VerticalWidgetRun verticalWidgetRun13 = constraintWidget48.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun13);
                    verticalWidgetRun13.getStart().getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                    ConstraintWidget constraintWidget49 = $this$apply_u24lambda_u240.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget49);
                    VerticalWidgetRun verticalWidgetRun14 = constraintWidget49.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun14);
                    verticalWidgetRun14.getEnd().getMDependencies().add($this$apply_u24lambda_u240.getMDimension());
                    $this$apply_u24lambda_u240.getMDimension().setDelegateToWidgetRun(true);
                    $this$apply_u24lambda_u240.getMDimension().getMDependencies().add($this$apply_u24lambda_u240.getStart());
                    $this$apply_u24lambda_u240.getMDimension().getMDependencies().add($this$apply_u24lambda_u240.getEnd());
                    $this$apply_u24lambda_u240.getStart().getMTargets().add($this$apply_u24lambda_u240.getMDimension());
                    $this$apply_u24lambda_u240.getEnd().getMTargets().add($this$apply_u24lambda_u240.getMDimension());
                    break;
                }
                case 2: {
                    HorizontalWidgetRun $this$apply_u24lambda_u241 = this;
                    boolean bl = false;
                    ConstraintWidget constraintWidget50 = $this$apply_u24lambda_u241.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget50);
                    ConstraintWidget constraintWidget51 = constraintWidget50.getParent();
                    if (constraintWidget51 == null) break;
                    ConstraintWidget parent = constraintWidget51;
                    VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    DependencyNode targetDimension = verticalWidgetRun.getMDimension();
                    $this$apply_u24lambda_u241.getMDimension().getMTargets().add(targetDimension);
                    targetDimension.getMDependencies().add($this$apply_u24lambda_u241.getMDimension());
                    $this$apply_u24lambda_u241.getMDimension().setDelegateToWidgetRun(true);
                    $this$apply_u24lambda_u241.getMDimension().getMDependencies().add($this$apply_u24lambda_u241.getStart());
                    $this$apply_u24lambda_u241.getMDimension().getMDependencies().add($this$apply_u24lambda_u241.getEnd());
                    break;
                }
            }
        }
        ConstraintWidget constraintWidget = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        if (constraintWidget.getMListAnchors()[0].getMTarget() != null) {
            ConstraintWidget constraintWidget52 = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget52);
            if (constraintWidget52.getMListAnchors()[1].getMTarget() != null) {
                ConstraintWidget constraintWidget53 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget53);
                if (constraintWidget53.isInHorizontalChain()) {
                    DependencyNode dependencyNode = this.getStart();
                    ConstraintWidget constraintWidget54 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget54);
                    dependencyNode.setMMargin(constraintWidget54.getMListAnchors()[0].getMargin());
                    DependencyNode dependencyNode9 = this.getEnd();
                    ConstraintWidget constraintWidget55 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget55);
                    dependencyNode9.setMMargin(-constraintWidget55.getMListAnchors()[1].getMargin());
                    return;
                }
                ConstraintWidget constraintWidget56 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget56);
                startTarget = this.getTarget(constraintWidget56.getMListAnchors()[0]);
                ConstraintWidget constraintWidget57 = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget57);
                DependencyNode endTarget = this.getTarget(constraintWidget57.getMListAnchors()[1]);
                DependencyNode dependencyNode = startTarget;
                if (dependencyNode != null) {
                    dependencyNode.addDependency(this);
                }
                DependencyNode dependencyNode10 = endTarget;
                if (dependencyNode10 != null) {
                    dependencyNode10.addDependency(this);
                }
                this.setMRunType$compose(WidgetRun.RunType.CENTER);
                return;
            }
        }
        ConstraintWidget constraintWidget58 = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget58);
        if (constraintWidget58.getMListAnchors()[0].getMTarget() != null) {
            ConstraintWidget constraintWidget59 = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget59);
            target = this.getTarget(constraintWidget59.getMListAnchors()[0]);
            if (target == null) return;
            DependencyNode dependencyNode = this.getStart();
            ConstraintWidget constraintWidget60 = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget60);
            this.addTarget(dependencyNode, target, constraintWidget60.getMListAnchors()[0].getMargin());
            this.addTarget(this.getEnd(), this.getStart(), 1, this.getMDimension());
            return;
        }
        ConstraintWidget constraintWidget61 = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget61);
        if (constraintWidget61.getMListAnchors()[1].getMTarget() != null) {
            ConstraintWidget constraintWidget62 = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget62);
            target = this.getTarget(constraintWidget62.getMListAnchors()[1]);
            if (target == null) return;
            DependencyNode dependencyNode = this.getEnd();
            ConstraintWidget constraintWidget63 = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget63);
            this.addTarget(dependencyNode, target, -constraintWidget63.getMListAnchors()[1].getMargin());
            this.addTarget(this.getStart(), this.getEnd(), -1, this.getMDimension());
            return;
        }
        if (this.getMWidget() instanceof Helper) return;
        ConstraintWidget constraintWidget64 = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget64);
        if (constraintWidget64.getParent() == null) return;
        ConstraintWidget constraintWidget65 = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget65);
        ConstraintWidget constraintWidget66 = constraintWidget65.getParent();
        Intrinsics.checkNotNull((Object)constraintWidget66);
        HorizontalWidgetRun horizontalWidgetRun = constraintWidget66.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        left = horizontalWidgetRun.getStart();
        DependencyNode dependencyNode = this.getStart();
        ConstraintWidget constraintWidget67 = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget67);
        this.addTarget(dependencyNode, left, constraintWidget67.getX());
        this.addTarget(this.getEnd(), this.getStart(), 1, this.getMDimension());
    }

    private final void computeInsetRatio(int[] dimensions, int x1, int x2, int y1, int y2, float ratio, int side) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        switch (side) {
            case -1: {
                int candidateX1 = (int)(0.5f + (float)dy * ratio);
                int candidateY2 = (int)(0.5f + (float)dx / ratio);
                if (candidateX1 <= dx && dy <= dy) {
                    dimensions[0] = candidateX1;
                    dimensions[1] = dy;
                    break;
                }
                if (dx > dx || candidateY2 > dy) break;
                dimensions[0] = dx;
                dimensions[1] = candidateY2;
                break;
            }
            case 0: {
                int horizontalSide;
                dimensions[0] = horizontalSide = (int)(0.5f + (float)dy * ratio);
                dimensions[1] = dy;
                break;
            }
            case 1: {
                int verticalSide = (int)(0.5f + (float)dx * ratio);
                dimensions[0] = dx;
                dimensions[1] = verticalSide;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(@NotNull Dependency node) {
        block47: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            switch (WhenMappings.$EnumSwitchMapping$0[this.getMRunType$compose().ordinal()]) {
                case 1: {
                    this.updateRunStart(node);
                    break;
                }
                case 2: {
                    this.updateRunEnd(node);
                    break;
                }
                case 3: {
                    v0 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v0);
                    v1 = v0.getMLeft();
                    v2 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v2);
                    this.updateRunCenter(node, v1, v2.getMRight(), 0);
                    return;
                }
            }
            if (this.getMDimension().getResolved() || this.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block47;
            v3 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v3);
            switch (v3.getMMatchConstraintDefaultWidth()) {
                case 3: {
                    v4 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v4);
                    if (v4.getMMatchConstraintDefaultHeight() == 0) ** GOTO lbl28
                    v5 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v5);
                    if (v5.getMMatchConstraintDefaultHeight() != 3) ** GOTO lbl176
lbl28:
                    // 2 sources

                    v6 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v6);
                    v7 = v6.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)v7);
                    secondStart = v7.getStart();
                    v8 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v8);
                    v9 = v8.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)v9);
                    secondEnd = v9.getEnd();
                    v10 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v10);
                    s1 = v10.getMLeft().getMTarget() != null;
                    v11 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v11);
                    s2 = v11.getMTop().getMTarget() != null;
                    v12 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v12);
                    e1 = v12.getMRight().getMTarget() != null;
                    v13 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v13);
                    e2 = v13.getMBottom().getMTarget() != null;
                    v14 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v14);
                    definedSide = v14.getDimensionRatioSide();
                    if (s1 && s2 && e1 && e2) {
                        v15 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)v15);
                        ratio = v15.getDimensionRatio();
                        if (secondStart.getResolved() && secondEnd.getResolved()) {
                            if (!this.getStart().getReadyToSolve() || !this.getEnd().getReadyToSolve()) {
                                return;
                            }
                            x1 = this.getStart().getMTargets().get(0).getValue() + this.getStart().getMMargin();
                            x2 = this.getEnd().getMTargets().get(0).getValue() - this.getEnd().getMMargin();
                            y1 = secondStart.getValue() + secondStart.getMMargin();
                            y2 = secondEnd.getValue() - secondEnd.getMMargin();
                            this.computeInsetRatio(HorizontalWidgetRun.sTempDimensions, x1, x2, y1, y2, ratio, definedSide);
                            this.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[0]);
                            v16 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v16);
                            v17 = v16.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v17);
                            v17.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[1]);
                            return;
                        }
                        if (this.getStart().getResolved() && this.getEnd().getResolved()) {
                            if (!secondStart.getReadyToSolve() || !secondEnd.getReadyToSolve()) {
                                return;
                            }
                            x1 = this.getStart().getValue() + this.getStart().getMMargin();
                            x2 = this.getEnd().getValue() - this.getEnd().getMMargin();
                            y1 = secondStart.getMTargets().get(0).getValue() + secondStart.getMMargin();
                            y2 = secondEnd.getMTargets().get(0).getValue() - secondEnd.getMMargin();
                            this.computeInsetRatio(HorizontalWidgetRun.sTempDimensions, x1, x2, y1, y2, ratio, definedSide);
                            this.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[0]);
                            v18 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v18);
                            v19 = v18.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v19);
                            v19.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[1]);
                        }
                        if (!(this.getStart().getReadyToSolve() && this.getEnd().getReadyToSolve() && secondStart.getReadyToSolve() && secondEnd.getReadyToSolve())) {
                            return;
                        }
                        x1 = this.getStart().getMTargets().get(0).getValue() + this.getStart().getMMargin();
                        x2 = this.getEnd().getMTargets().get(0).getValue() - this.getEnd().getMMargin();
                        y1 = secondStart.getMTargets().get(0).getValue() + secondStart.getMMargin();
                        y2 = secondEnd.getMTargets().get(0).getValue() - secondEnd.getMMargin();
                        this.computeInsetRatio(HorizontalWidgetRun.sTempDimensions, x1, x2, y1, y2, ratio, definedSide);
                        this.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[0]);
                        v20 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)v20);
                        v21 = v20.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)v21);
                        v21.getMDimension().resolve(HorizontalWidgetRun.sTempDimensions[1]);
                        break;
                    }
                    if (s1 && e1) {
                        if (!this.getStart().getReadyToSolve() || !this.getEnd().getReadyToSolve()) {
                            return;
                        }
                        v22 = this.getMWidget();
                        Intrinsics.checkNotNull((Object)v22);
                        ratio = v22.getDimensionRatio();
                        x1 = this.getStart().getMTargets().get(0).getValue() + this.getStart().getMMargin();
                        x2 = this.getEnd().getMTargets().get(0).getValue() - this.getEnd().getMMargin();
                        switch (definedSide) {
                            case -1: 
                            case 0: {
                                dx = x2 - x1;
                                ldx = this.getLimitedDimension(dx, 0);
                                dy = (int)(0.5f + (float)ldx * ratio);
                                ldy = this.getLimitedDimension(dy, 1);
                                if (dy != ldy) {
                                    ldx = (int)(0.5f + (float)ldy / ratio);
                                }
                                this.getMDimension().resolve(ldx);
                                v23 = this.getMWidget();
                                Intrinsics.checkNotNull((Object)v23);
                                v24 = v23.getMVerticalRun();
                                Intrinsics.checkNotNull((Object)v24);
                                v24.getMDimension().resolve(ldy);
                                break;
                            }
                            case 1: {
                                dx = x2 - x1;
                                ldx = this.getLimitedDimension(dx, 0);
                                dy = (int)(0.5f + (float)ldx / ratio);
                                ldy = this.getLimitedDimension(dy, 1);
                                if (dy != ldy) {
                                    ldx = (int)(0.5f + (float)ldy * ratio);
                                }
                                this.getMDimension().resolve(ldx);
                                v25 = this.getMWidget();
                                Intrinsics.checkNotNull((Object)v25);
                                v26 = v25.getMVerticalRun();
                                Intrinsics.checkNotNull((Object)v26);
                                v26.getMDimension().resolve(ldy);
                            }
                        }
                        break;
                    }
                    if (!s2 || !e2) break;
                    if (!secondStart.getReadyToSolve() || !secondEnd.getReadyToSolve()) {
                        return;
                    }
                    v27 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v27);
                    ratio = v27.getDimensionRatio();
                    y1 = secondStart.getMTargets().get(0).getValue() + secondStart.getMMargin();
                    y2 = secondEnd.getMTargets().get(0).getValue() - secondEnd.getMMargin();
                    switch (definedSide) {
                        case -1: 
                        case 1: {
                            dy = y2 - y1;
                            ldy = this.getLimitedDimension(dy, 1);
                            dx = (int)(0.5f + (float)ldy / ratio);
                            ldx = this.getLimitedDimension(dx, 0);
                            if (dx != ldx) {
                                ldy = (int)(0.5f + (float)ldx * ratio);
                            }
                            this.getMDimension().resolve(ldx);
                            v28 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v28);
                            v29 = v28.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v29);
                            v29.getMDimension().resolve(ldy);
                            break;
                        }
                        case 0: {
                            dy = y2 - y1;
                            ldy = this.getLimitedDimension(dy, 1);
                            dx = (int)(0.5f + (float)ldy * ratio);
                            ldx = this.getLimitedDimension(dx, 0);
                            if (dx != ldx) {
                                ldy = (int)(0.5f + (float)ldx / ratio);
                            }
                            this.getMDimension().resolve(ldx);
                            v30 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v30);
                            v31 = v30.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v31);
                            v31.getMDimension().resolve(ldy);
                        }
                    }
                    break;
lbl176:
                    // 1 sources

                    size = 0;
                    v32 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v32);
                    ratioSide = v32.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            v33 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v33);
                            v34 = v33.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v34);
                            v35 = v34.getMDimension().getValue();
                            v36 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v36);
                            size = (int)(0.5f + v35 / v36.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            v37 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v37);
                            v38 = v37.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v38);
                            v39 = v38.getMDimension().getValue();
                            v40 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v40);
                            size = (int)(0.5f + v39 * v40.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            v41 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v41);
                            v42 = v41.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)v42);
                            v43 = v42.getMDimension().getValue();
                            v44 = this.getMWidget();
                            Intrinsics.checkNotNull((Object)v44);
                            size = (int)(0.5f + v43 * v44.getDimensionRatio());
                        }
                    }
                    this.getMDimension().resolve(size);
                    break;
                }
                case 2: {
                    v45 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v45);
                    parent = v45.getParent();
                    if (parent == null) break;
                    v46 = parent.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)v46);
                    if (!v46.getMDimension().getResolved()) break;
                    v47 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)v47);
                    percent = v47.getMMatchConstraintPercentWidth();
                    v48 = parent.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)v48);
                    targetDimensionValue = v48.getMDimension().getValue();
                    size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.getMDimension().resolve(size);
                }
            }
        }
        if (!this.getStart().getReadyToSolve() || !this.getEnd().getReadyToSolve()) {
            return;
        }
        if (this.getStart().getResolved() && this.getEnd().getResolved() && this.getMDimension().getResolved()) {
            return;
        }
        if (!this.getMDimension().getResolved() && this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            v49 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v49);
            if (v49.getMMatchConstraintDefaultWidth() == 0) {
                v50 = this.getMWidget();
                Intrinsics.checkNotNull((Object)v50);
                if (!v50.isInHorizontalChain()) {
                    v51 = this.getStart().getMTargets().get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)v51, (String)"get(...)");
                    startTarget = v51;
                    v52 = this.getEnd().getMTargets().get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)v52, (String)"get(...)");
                    endTarget = v52;
                    startPos = startTarget.getValue() + this.getStart().getMMargin();
                    endPos = endTarget.getValue() + this.getEnd().getMMargin();
                    distance = endPos - startPos;
                    this.getStart().resolve(startPos);
                    this.getEnd().resolve(endPos);
                    this.getMDimension().resolve(distance);
                    return;
                }
            }
        }
        if (!this.getMDimension().getResolved() && this.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.getMatchConstraintsType() == 1 && this.getStart().getMTargets().size() > 0 && this.getEnd().getMTargets().size() > 0) {
            v53 = this.getStart().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)v53, (String)"get(...)");
            startTarget = v53;
            v54 = this.getEnd().getMTargets().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)v54, (String)"get(...)");
            endTarget = v54;
            startPos = startTarget.getValue() + this.getStart().getMMargin();
            endPos = endTarget.getValue() + this.getEnd().getMMargin();
            availableSpace = endPos - startPos;
            value = Math.min(availableSpace, this.getMDimension().getWrapValue());
            v55 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v55);
            max = v55.getMMatchConstraintMaxWidth();
            v56 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v56);
            min = v56.getMMatchConstraintMinWidth();
            value = Math.max(min, value);
            if (max > 0) {
                value = Math.min(max, value);
            }
            this.getMDimension().resolve(value);
        }
        if (!this.getMDimension().getResolved()) {
            return;
        }
        v57 = this.getStart().getMTargets().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)v57, (String)"get(...)");
        startTarget = v57;
        v58 = this.getEnd().getMTargets().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)v58, (String)"get(...)");
        endTarget = v58;
        startPos = startTarget.getValue() + this.getStart().getMMargin();
        endPos = endTarget.getValue() + this.getEnd().getMMargin();
        v59 = this.getMWidget();
        Intrinsics.checkNotNull((Object)v59);
        bias = v59.getHorizontalBiasPercent();
        if (Intrinsics.areEqual((Object)startTarget, (Object)endTarget)) {
            startPos = startTarget.getValue();
            endPos = endTarget.getValue();
            bias = 0.5f;
        }
        distance = endPos - startPos - this.getMDimension().getValue();
        this.getStart().resolve((int)(0.5f + (float)startPos + (float)distance * bias));
        this.getEnd().resolve(this.getStart().getValue() + this.getMDimension().getValue());
    }

    @Override
    public void applyToWidget() {
        if (this.getStart().getResolved()) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            constraintWidget.setX(this.getStart().getValue());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/HorizontalWidgetRun$Companion;", "", "<init>", "()V", "sTempDimensions", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WidgetRun.RunType.values().length];
            try {
                nArray[WidgetRun.RunType.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetRun.RunType.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetRun.RunType.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

