/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0001CB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010#\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\u0001H\u0016J\u000e\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020\u0001J\u0006\u0010A\u001a\u00020:J\u0006\u0010B\u001a\u00020<R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0011\"\u0004\b1\u0010\u0013R!\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u000103j\b\u0012\u0004\u0012\u00020\u0001`4\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R!\u00107\u001a\u0012\u0012\u0004\u0012\u00020\u000003j\b\u0012\u0004\u0012\u00020\u0000`4\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00106\u00a8\u0006D"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "mRun", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "<init>", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;)V", "getMRun", "()Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "setMRun", "updateDelegate", "getUpdateDelegate", "()Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "setUpdateDelegate", "(Landroidx/constraintlayout/core/widgets/analyzer/Dependency;)V", "delegateToWidgetRun", "", "getDelegateToWidgetRun", "()Z", "setDelegateToWidgetRun", "(Z)V", "readyToSolve", "getReadyToSolve", "setReadyToSolve", "mType", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "getMType", "()Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "setMType", "(Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;)V", "mMargin", "", "getMMargin", "()I", "setMMargin", "(I)V", "value", "getValue", "setValue", "mMarginFactor", "getMMarginFactor", "setMMarginFactor", "mMarginDependency", "Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "getMMarginDependency", "()Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "setMMarginDependency", "(Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;)V", "resolved", "getResolved", "setResolved", "mDependencies", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMDependencies", "()Ljava/util/ArrayList;", "mTargets", "getMTargets", "toString", "", "resolve", "", "update", "node", "addDependency", "dependency", "name", "clear", "Type", "compose"})
@StabilityInferred(parameters=0)
public class DependencyNode
implements Dependency {
    @NotNull
    private WidgetRun mRun;
    @Nullable
    private Dependency updateDelegate;
    private boolean delegateToWidgetRun;
    private boolean readyToSolve;
    @NotNull
    private Type mType;
    private int mMargin;
    private int value;
    private int mMarginFactor;
    @Nullable
    private DimensionDependency mMarginDependency;
    private boolean resolved;
    @NotNull
    private final ArrayList<Dependency> mDependencies;
    @NotNull
    private final ArrayList<DependencyNode> mTargets;
    public static final int $stable = 8;

    public DependencyNode(@NotNull WidgetRun mRun) {
        Intrinsics.checkNotNullParameter((Object)mRun, (String)"mRun");
        this.mRun = mRun;
        this.mType = Type.UNKNOWN;
        this.mMarginFactor = 1;
        this.mDependencies = new ArrayList();
        this.mTargets = new ArrayList();
    }

    @NotNull
    public final WidgetRun getMRun() {
        return this.mRun;
    }

    public final void setMRun(@NotNull WidgetRun widgetRun) {
        Intrinsics.checkNotNullParameter((Object)widgetRun, (String)"<set-?>");
        this.mRun = widgetRun;
    }

    @Nullable
    public final Dependency getUpdateDelegate() {
        return this.updateDelegate;
    }

    public final void setUpdateDelegate(@Nullable Dependency dependency) {
        this.updateDelegate = dependency;
    }

    public final boolean getDelegateToWidgetRun() {
        return this.delegateToWidgetRun;
    }

    public final void setDelegateToWidgetRun(boolean bl) {
        this.delegateToWidgetRun = bl;
    }

    public final boolean getReadyToSolve() {
        return this.readyToSolve;
    }

    public final void setReadyToSolve(boolean bl) {
        this.readyToSolve = bl;
    }

    @NotNull
    public final Type getMType() {
        return this.mType;
    }

    public final void setMType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.mType = type;
    }

    public final int getMMargin() {
        return this.mMargin;
    }

    public final void setMMargin(int n) {
        this.mMargin = n;
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int n) {
        this.value = n;
    }

    public final int getMMarginFactor() {
        return this.mMarginFactor;
    }

    public final void setMMarginFactor(int n) {
        this.mMarginFactor = n;
    }

    @Nullable
    public final DimensionDependency getMMarginDependency() {
        return this.mMarginDependency;
    }

    public final void setMMarginDependency(@Nullable DimensionDependency dimensionDependency) {
        this.mMarginDependency = dimensionDependency;
    }

    public final boolean getResolved() {
        return this.resolved;
    }

    public final void setResolved(boolean bl) {
        this.resolved = bl;
    }

    @NotNull
    public final ArrayList<Dependency> getMDependencies() {
        return this.mDependencies;
    }

    @NotNull
    public final ArrayList<DependencyNode> getMTargets() {
        return this.mTargets;
    }

    @NotNull
    public String toString() {
        ConstraintWidget constraintWidget = this.mRun.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        return constraintWidget.getDebugName() + ":" + this.mType + "(" + (this.resolved ? Integer.valueOf(this.value) : "unresolved") + ") <t=" + this.mTargets.size() + ":d=" + this.mDependencies.size() + ">";
    }

    public void resolve(int value) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.value = value;
        Iterator<Dependency> iterator = this.mDependencies.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Dependency> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Dependency node;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            node.update(node);
        }
    }

    @Override
    public void update(@NotNull Dependency node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterator<DependencyNode> iterator = this.mTargets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DependencyNode> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DependencyNode target;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (target.resolved) continue;
            return;
        }
        this.readyToSolve = true;
        if (this.updateDelegate != null) {
            Dependency dependency = this.updateDelegate;
            Intrinsics.checkNotNull((Object)dependency);
            dependency.update(this);
        }
        if (this.delegateToWidgetRun) {
            this.mRun.update(this);
            return;
        }
        DependencyNode target = null;
        int numTargets = 0;
        Iterator<DependencyNode> iterator3 = this.mTargets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator<DependencyNode> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            DependencyNode t;
            Intrinsics.checkNotNullExpressionValue((Object)iterator4.next(), (String)"next(...)");
            if (t instanceof DimensionDependency) continue;
            target = t;
            ++numTargets;
        }
        if (target != null && numTargets == 1 && target.resolved) {
            if (this.mMarginDependency != null) {
                DimensionDependency dimensionDependency = this.mMarginDependency;
                Intrinsics.checkNotNull((Object)dimensionDependency);
                if (dimensionDependency.getResolved()) {
                    DimensionDependency dimensionDependency2 = this.mMarginDependency;
                    Intrinsics.checkNotNull((Object)dimensionDependency2);
                    this.mMargin = this.mMarginFactor * dimensionDependency2.getValue();
                } else {
                    return;
                }
            }
            this.resolve(target.value + this.mMargin);
        }
        if (this.updateDelegate != null) {
            Dependency dependency = this.updateDelegate;
            Intrinsics.checkNotNull((Object)dependency);
            dependency.update(this);
        }
    }

    public final void addDependency(@NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.mDependencies.add(dependency);
        if (this.resolved) {
            dependency.update(dependency);
        }
    }

    @NotNull
    public final String name() {
        ConstraintWidget constraintWidget = this.mRun.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        Object definition = String.valueOf(constraintWidget.getDebugName());
        definition = (String)definition + (this.mType == Type.LEFT || this.mType == Type.RIGHT ? "_HORIZONTAL" : "_VERTICAL");
        definition = (String)definition + ":" + this.mType.name();
        return definition;
    }

    public final void clear() {
        this.mTargets.clear();
        this.mDependencies.clear();
        this.resolved = false;
        this.value = 0;
        this.readyToSolve = false;
        this.delegateToWidgetRun = false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN", "HORIZONTAL_DIMENSION", "VERTICAL_DIMENSION", "LEFT", "RIGHT", "TOP", "BOTTOM", "BASELINE", "compose"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNKNOWN = new Type();
        public static final /* enum */ Type HORIZONTAL_DIMENSION = new Type();
        public static final /* enum */ Type VERTICAL_DIMENSION = new Type();
        public static final /* enum */ Type LEFT = new Type();
        public static final /* enum */ Type RIGHT = new Type();
        public static final /* enum */ Type TOP = new Type();
        public static final /* enum */ Type BOTTOM = new Type();
        public static final /* enum */ Type BASELINE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.UNKNOWN, Type.HORIZONTAL_DIMENSION, Type.VERTICAL_DIMENSION, Type.LEFT, Type.RIGHT, Type.TOP, Type.BOTTOM, Type.BASELINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

