/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0001J\u001f\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0001J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0012\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0006\u0010#\u001a\u00020\u0013R*\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00010\fj\b\u0012\u0004\u0012\u00020\u0001`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00010\fj\b\u0012\u0004\u0012\u00020\u0001`\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006$"}, d2={"Landroidx/constraintlayout/core/widgets/WidgetContainer;", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "<init>", "()V", "x", "", "y", "width", "height", "(IIII)V", "(II)V", "mChildren", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMChildren", "()Ljava/util/ArrayList;", "setMChildren", "(Ljava/util/ArrayList;)V", "reset", "", "add", "widget", "widgets", "", "([Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "remove", "children", "getChildren", "getRootConstraintContainer", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "setOffset", "layout", "resetSolverVariables", "cache", "Landroidx/constraintlayout/core/Cache;", "removeAllChildren", "compose"})
@StabilityInferred(parameters=0)
public class WidgetContainer
extends ConstraintWidget {
    @NotNull
    private ArrayList<ConstraintWidget> mChildren = new ArrayList();
    public static final int $stable = 8;

    @NotNull
    public final ArrayList<ConstraintWidget> getMChildren() {
        return this.mChildren;
    }

    public final void setMChildren(@NotNull ArrayList<ConstraintWidget> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mChildren = arrayList;
    }

    public WidgetContainer() {
    }

    public WidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public WidgetContainer(int width, int height) {
        super(width, height);
    }

    @Override
    public void reset() {
        this.mChildren.clear();
        super.reset();
    }

    public final void add(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.mChildren.add(widget);
        if (widget.getParent() != null) {
            ConstraintWidget constraintWidget = widget.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.WidgetContainer");
            WidgetContainer container = (WidgetContainer)constraintWidget;
            container.remove(widget);
        }
        widget.setParent(this);
    }

    public final void add(ConstraintWidget ... widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        int count = widgets.length;
        for (int i = 0; i < count; ++i) {
            this.add(widgets[i]);
        }
    }

    public final void remove(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.mChildren.remove(widget);
        widget.reset();
    }

    @NotNull
    public final ArrayList<ConstraintWidget> getChildren() {
        return this.mChildren;
    }

    @Nullable
    public final ConstraintWidgetContainer getRootConstraintContainer() {
        ConstraintWidget item = this;
        ConstraintWidget parent = item.getParent();
        ConstraintWidgetContainer container = null;
        if (item instanceof ConstraintWidgetContainer) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.ConstraintWidgetContainer");
            container = (ConstraintWidgetContainer)this;
        }
        while (parent != null) {
            item = parent;
            parent = item.getParent();
            if (!(item instanceof ConstraintWidgetContainer)) continue;
            container = (ConstraintWidgetContainer)item;
        }
        return container;
    }

    @Override
    public void setOffset(int x, int y) {
        super.setOffset(x, y);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)this.mChildren.get(i), (String)"get(...)");
            widget.setOffset(this.getRootX(), this.getRootY());
        }
    }

    public void layout() {
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)this.mChildren.get(i), (String)"get(...)");
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
    }

    @Override
    public void resetSolverVariables(@Nullable Cache cache) {
        super.resetSolverVariables(cache);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)this.mChildren.get(i), (String)"get(...)");
            widget.resetSolverVariables(cache);
        }
    }

    public final void removeAllChildren() {
        this.mChildren.clear();
    }
}

