/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.SpringStopEngine;
import androidx.constraintlayout.core.motion.utils.StopEngine;
import androidx.constraintlayout.core.motion.utils.StopLogicEngine;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Interpolator;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u0092\u00012\u00020\u0001:\u0006\u0090\u0001\u0091\u0001\u0092\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00107\u001a\u00020\u0019J\u0006\u00108\u001a\u000202J\u0016\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u0017J.\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u0017J&\u0010B\u001a\u00020C2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u0017J\u000e\u0010H\u001a\u00020\u00172\u0006\u0010D\u001a\u00020EJ\u000e\u0010I\u001a\u0002022\u0006\u0010=\u001a\u00020\u0017J\u0018\u0010J\u001a\u0004\u0018\u00010\n2\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\bJ\u0018\u0010M\u001a\u0004\u0018\u00010\n2\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\bJ\u000e\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020PJ\u0010\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010\tJ&\u0010T\u001a\u00020C2\u0006\u0010O\u001a\u00020P2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020V2\u0006\u0010X\u001a\u00020VJ\u0006\u0010Y\u001a\u000202J\u000e\u0010Z\u001a\u00020C2\u0006\u0010[\u001a\u00020\u000fJ\u0018\u0010\\\u001a\u0002022\u0006\u0010S\u001a\u00020\b2\u0006\u0010]\u001a\u00020\bH\u0016J\u0018\u0010\\\u001a\u0002022\u0006\u0010S\u001a\u00020\b2\u0006\u0010]\u001a\u00020\u0017H\u0016J\u0018\u0010\\\u001a\u0002022\u0006\u0010S\u001a\u00020\b2\u0006\u0010]\u001a\u00020\tH\u0016J\u0018\u0010\\\u001a\u0002022\u0006\u0010S\u001a\u00020\b2\u0006\u0010]\u001a\u000202H\u0016J\u0012\u0010^\u001a\u00020\b2\b\u0010_\u001a\u0004\u0018\u00010\tH\u0016J\u0006\u0010a\u001a\u00020CJ\u0006\u0010b\u001a\u00020CJ\u0013\u0010c\u001a\u0002022\b\u0010d\u001a\u0004\u0018\u00010\tH\u0086\u0002J\u0018\u0010e\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010\t2\u0006\u0010[\u001a\u00020\u000fJ\u0018\u0010f\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010\t2\u0006\u0010[\u001a\u00020\u000fJ/\u0010f\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010\t2\u0006\u0010[\u001a\u00020\u000f2\u0010\u0010g\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010i\u0018\u00010h\u00a2\u0006\u0002\u0010jJ\u0018\u0010k\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010\t2\u0006\u0010[\u001a\u00020\u000fJ0\u0010e\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010\t2\u0006\u0010O\u001a\u00020\b2\u0006\u0010l\u001a\u00020\b2\u0006\u0010U\u001a\u00020\u00172\u0006\u0010W\u001a\u00020\u0017J(\u0010m\u001a\u00020C2\u0006\u0010n\u001a\u00020\b2\b\u0010o\u001a\u0004\u0018\u00010\t2\u0006\u0010p\u001a\u00020\t2\u0006\u0010]\u001a\u00020\u0017J(\u0010q\u001a\u00020C2\u0006\u0010n\u001a\u00020\b2\b\u0010o\u001a\u0004\u0018\u00010\t2\u0006\u0010p\u001a\u00020\t2\u0006\u0010r\u001a\u00020\bJ\u0010\u0010s\u001a\u00020C2\u0006\u0010t\u001a\u00020\u0017H\u0002J\u0016\u0010y\u001a\u00020C2\u0006\u0010z\u001a\u00020{2\u0006\u0010n\u001a\u00020\bJ\u001e\u0010|\u001a\u00020C2\u0006\u0010}\u001a\u00020\b2\u0006\u0010~\u001a\u00020\b2\u0006\u0010t\u001a\u00020\u0017J\u0010\u0010\u007f\u001a\u00020P2\b\u0010S\u001a\u0004\u0018\u00010\tJ\u0011\u0010\u0080\u0001\u001a\u00020P2\b\u0010S\u001a\u0004\u0018\u00010\tJ\u0011\u0010\u0081\u0001\u001a\u00020P2\b\u0010S\u001a\u0004\u0018\u00010\tJ\u0011\u0010\u0082\u0001\u001a\u00020V2\b\u0010S\u001a\u0004\u0018\u00010\tJ4\u0010\u0083\u0001\u001a\u00020\b2\b\u0010S\u001a\u0004\u0018\u00010\t2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010V2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0086\u0001J\u0013\u0010\u0088\u0001\u001a\u0004\u0018\u00010\r2\u0006\u0010o\u001a\u00020\tH\u0002J&\u0010\u0088\u0001\u001a\u00020\r2\b\u0010o\u001a\u0004\u0018\u00010\t2\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020\bJ\u0010\u0010\u007f\u001a\u00020P2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\u0011\u0010\u0080\u0001\u001a\u00020P2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\u0011\u0010\u0081\u0001\u001a\u00020P2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\n\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001J\u0007\u0010\u008e\u0001\u001a\u00020\bJ\u0007\u0010\u008f\u0001\u001a\u00020CRb\u0010\u0006\u001aV\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b0\u0007j*\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0007j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u001a\u0010+\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\u001a\u0010.\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0011\u0010`\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b`\u00104R\u0011\u0010u\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bv\u0010\u001fR\u0011\u0010w\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bx\u0010\u001f\u00a8\u0006\u0093\u0001"}, d2={"Landroidx/constraintlayout/core/state/Transition;", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "dpToPixel", "Landroidx/constraintlayout/core/state/CorePixelDp;", "<init>", "(Landroidx/constraintlayout/core/state/CorePixelDp;)V", "mKeyPositions", "Ljava/util/HashMap;", "", "", "Landroidx/constraintlayout/core/state/Transition$KeyPosition;", "Lkotlin/collections/HashMap;", "mState", "Landroidx/constraintlayout/core/state/Transition$Companion$WidgetState;", "mBundle", "Landroidx/constraintlayout/core/motion/utils/TypedBundle;", "mDefaultInterpolator", "mDefaultInterpolatorString", "mEasing", "Landroidx/constraintlayout/core/motion/utils/Easing;", "mAutoTransition", "mDuration", "mStagger", "", "mOnSwipe", "Landroidx/constraintlayout/core/state/Transition$OnSwipe;", "mToPixel", "getMToPixel", "()Landroidx/constraintlayout/core/state/CorePixelDp;", "mParentStartWidth", "getMParentStartWidth", "()I", "setMParentStartWidth", "(I)V", "mParentStartHeight", "getMParentStartHeight", "setMParentStartHeight", "mParentEndWidth", "getMParentEndWidth", "setMParentEndWidth", "mParentEndHeight", "getMParentEndHeight", "setMParentEndHeight", "mParentInterpolatedWidth", "getMParentInterpolatedWidth", "setMParentInterpolatedWidth", "mParentInterpolateHeight", "getMParentInterpolateHeight", "setMParentInterpolateHeight", "mWrap", "", "getMWrap", "()Z", "setMWrap", "(Z)V", "createOnSwipe", "hasOnSwipe", "isFirstDownAccepted", "posX", "posY", "dragToProgress", "currentProgress", "baseW", "baseH", "dx", "dy", "setTouchUp", "", "currentTime", "", "velocityX", "velocityY", "getTouchUpProgress", "isTouchNotDone", "findPreviousPosition", "target", "frameNumber", "findNextPosition", "getNumberKeyPositions", "frame", "Landroidx/constraintlayout/core/state/WidgetFrame;", "getMotion", "Landroidx/constraintlayout/core/motion/Motion;", "id", "fillKeyPositions", "x", "", "y", "pos", "hasPositionKeyframes", "setTransitionProperties", "bundle", "setValue", "value", "getId", "name", "isEmpty", "clear", "resetProperties", "contains", "key", "addKeyPosition", "addKeyAttribute", "custom", "", "Landroidx/constraintlayout/core/motion/CustomVariable;", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/utils/TypedBundle;[Landroidx/constraintlayout/core/motion/CustomVariable;)V", "addKeyCycle", "type", "addCustomFloat", "state", "widgetId", "property", "addCustomColor", "color", "calculateParentDimensions", "progress", "interpolatedWidth", "getInterpolatedWidth", "interpolatedHeight", "getInterpolatedHeight", "updateFrom", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "interpolate", "parentWidth", "parentHeight", "getStart", "getEnd", "getInterpolated", "getPath", "getKeyFrames", "rectangles", "pathMode", "", "position", "getWidgetState", "child", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "transitionState", "getInterpolator", "Landroidx/constraintlayout/core/state/Interpolator;", "getAutoTransition", "calcStagger", "KeyPosition", "OnSwipe", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transition.kt\nandroidx/constraintlayout/core/state/Transition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1248:1\n1#2:1249\n*E\n"})
public final class Transition
implements TypedValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, HashMap<String, KeyPosition>> mKeyPositions;
    @NotNull
    private final HashMap<String, Companion.WidgetState> mState;
    @NotNull
    private final TypedBundle mBundle;
    private final int mDefaultInterpolator;
    @Nullable
    private String mDefaultInterpolatorString;
    @Nullable
    private Easing mEasing;
    private final int mAutoTransition;
    private final int mDuration;
    private float mStagger;
    @Nullable
    private OnSwipe mOnSwipe;
    @NotNull
    private final CorePixelDp mToPixel;
    private int mParentStartWidth;
    private int mParentStartHeight;
    private int mParentEndWidth;
    private int mParentEndHeight;
    private int mParentInterpolatedWidth;
    private int mParentInterpolateHeight;
    private boolean mWrap;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    public static final int START = 0;
    public static final int END = 1;
    public static final int INTERPOLATED = 2;
    public static final int EASE_IN_OUT = 0;
    public static final int EASE_IN = 1;
    public static final int EASE_OUT = 2;
    public static final int LINEAR = 3;
    public static final int BOUNCE = 4;
    public static final int OVERSHOOT = 5;
    public static final int ANTICIPATE = 6;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;

    public Transition(@NotNull CorePixelDp dpToPixel) {
        Intrinsics.checkNotNullParameter((Object)dpToPixel, (String)"dpToPixel");
        this.mKeyPositions = new HashMap();
        this.mState = new HashMap();
        this.mBundle = new TypedBundle();
        this.mDuration = 400;
        this.mToPixel = dpToPixel;
    }

    @NotNull
    public final CorePixelDp getMToPixel() {
        return this.mToPixel;
    }

    public final int getMParentStartWidth() {
        return this.mParentStartWidth;
    }

    public final void setMParentStartWidth(int n) {
        this.mParentStartWidth = n;
    }

    public final int getMParentStartHeight() {
        return this.mParentStartHeight;
    }

    public final void setMParentStartHeight(int n) {
        this.mParentStartHeight = n;
    }

    public final int getMParentEndWidth() {
        return this.mParentEndWidth;
    }

    public final void setMParentEndWidth(int n) {
        this.mParentEndWidth = n;
    }

    public final int getMParentEndHeight() {
        return this.mParentEndHeight;
    }

    public final void setMParentEndHeight(int n) {
        this.mParentEndHeight = n;
    }

    public final int getMParentInterpolatedWidth() {
        return this.mParentInterpolatedWidth;
    }

    public final void setMParentInterpolatedWidth(int n) {
        this.mParentInterpolatedWidth = n;
    }

    public final int getMParentInterpolateHeight() {
        return this.mParentInterpolateHeight;
    }

    public final void setMParentInterpolateHeight(int n) {
        this.mParentInterpolateHeight = n;
    }

    public final boolean getMWrap() {
        return this.mWrap;
    }

    public final void setMWrap(boolean bl) {
        this.mWrap = bl;
    }

    @NotNull
    public final OnSwipe createOnSwipe() {
        OnSwipe onSwipe = this.mOnSwipe = new OnSwipe();
        Intrinsics.checkNotNull((Object)onSwipe);
        return onSwipe;
    }

    public final boolean hasOnSwipe() {
        return this.mOnSwipe != null;
    }

    public final boolean isFirstDownAccepted(float posX, float posY) {
        boolean bl;
        if (this.mOnSwipe == null) {
            return false;
        }
        OnSwipe onSwipe = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe);
        if (onSwipe.getMLimitBoundsTo() != null) {
            Map map = this.mState;
            OnSwipe onSwipe2 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe2);
            Companion.WidgetState targetWidget = (Companion.WidgetState)map.get(onSwipe2.getMLimitBoundsTo());
            if (targetWidget == null) {
                System.out.println((Object)"mLimitBoundsTo target is null");
                return false;
            }
            WidgetFrame frame = targetWidget.getFrame(2);
            bl = posX >= (float)frame.getLeft() && posX < (float)frame.getRight() && posY >= (float)frame.getTop() && posY < (float)frame.getBottom();
        } else {
            bl = true;
        }
        return bl;
    }

    public final float dragToProgress(float currentProgress, int baseW, int baseH, float dx, float dy) {
        Collection<Companion.WidgetState> collection = this.mState.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<Companion.WidgetState> widgets = collection;
        Companion.WidgetState childWidget = null;
        Iterator<Companion.WidgetState> iterator = widgets.iterator();
        if (iterator.hasNext()) {
            Companion.WidgetState widget;
            childWidget = widget = iterator.next();
        }
        if (this.mOnSwipe == null || childWidget == null) {
            return childWidget != null ? -dy / (float)childWidget.getMParentHeight() : 1.0f;
        }
        OnSwipe onSwipe = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe);
        if (onSwipe.getMAnchorId() == null) {
            OnSwipe onSwipe2 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe2);
            float[] dir = onSwipe2.getDirection();
            float motionDpDtX = childWidget.getMParentHeight();
            float motionDpDtY = childWidget.getMParentHeight();
            float drag = !(dir[0] == 0.0f) ? dx * Math.abs(dir[0]) / motionDpDtX : dy * Math.abs(dir[1]) / motionDpDtY;
            OnSwipe onSwipe3 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe3);
            return drag * onSwipe3.getScale();
        }
        Map map = this.mState;
        OnSwipe onSwipe4 = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe4);
        Object v = map.get(onSwipe4.getMAnchorId());
        Intrinsics.checkNotNull(v);
        Companion.WidgetState base = (Companion.WidgetState)v;
        OnSwipe onSwipe5 = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe5);
        float[] dir = onSwipe5.getDirection();
        OnSwipe onSwipe6 = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe6);
        float[] side = onSwipe6.getSide();
        float[] motionDpDt = new float[2];
        base.interpolate(baseW, baseH, currentProgress, this);
        base.getMMotionControl().getDpDt(currentProgress, side[0], side[1], motionDpDt);
        float drag = !(dir[0] == 0.0f) ? dx * Math.abs(dir[0]) / motionDpDt[0] : dy * Math.abs(dir[1]) / motionDpDt[1];
        OnSwipe onSwipe7 = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe7);
        return drag * onSwipe7.getScale();
    }

    public final void setTouchUp(float currentProgress, long currentTime, float velocityX, float velocityY) {
        if (this.mOnSwipe != null) {
            Map map = this.mState;
            OnSwipe onSwipe = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe);
            Object v = map.get(onSwipe.getMAnchorId());
            Intrinsics.checkNotNull(v);
            Companion.WidgetState base = (Companion.WidgetState)v;
            float[] motionDpDt = new float[2];
            OnSwipe onSwipe2 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe2);
            float[] dir = onSwipe2.getDirection();
            OnSwipe onSwipe3 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe3);
            float[] side = onSwipe3.getSide();
            base.getMMotionControl().getDpDt(currentProgress, side[0], side[1], motionDpDt);
            float movementInDir = dir[0] * motionDpDt[0] + dir[1] * motionDpDt[1];
            if ((double)Math.abs(movementInDir) < 0.01) {
                motionDpDt[0] = 0.01f;
                motionDpDt[1] = 0.01f;
            }
            float drag = !(dir[0] == 0.0f) ? velocityX / motionDpDt[0] : velocityY / motionDpDt[1];
            OnSwipe onSwipe4 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe4);
            OnSwipe onSwipe5 = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe5);
            onSwipe5.config(currentProgress, drag *= onSwipe4.getScale(), currentTime, (float)this.mDuration * 0.001f);
        }
    }

    public final float getTouchUpProgress(long currentTime) {
        float f;
        if (this.mOnSwipe != null) {
            OnSwipe onSwipe = this.mOnSwipe;
            Intrinsics.checkNotNull((Object)onSwipe);
            f = onSwipe.getTouchUpProgress(currentTime);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final boolean isTouchNotDone(float currentProgress) {
        OnSwipe onSwipe = this.mOnSwipe;
        Intrinsics.checkNotNull((Object)onSwipe);
        return onSwipe.isNotDone(currentProgress);
    }

    @Nullable
    public final KeyPosition findPreviousPosition(@NotNull String target, int frameNumber) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        for (int frameNumber2 = frameNumber; frameNumber2 >= 0; --frameNumber2) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber2);
            if (map == null || (keyPosition = map.get(target)) == null) continue;
            return keyPosition;
        }
        return null;
    }

    @Nullable
    public final KeyPosition findNextPosition(@NotNull String target, int frameNumber) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        for (int frameNumber2 = frameNumber; frameNumber2 <= 100; ++frameNumber2) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber2);
            if (map == null || (keyPosition = map.get(target)) == null) continue;
            return keyPosition;
        }
        return null;
    }

    public final int getNumberKeyPositions(@NotNull WidgetFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map == null) continue;
            Map map2 = map;
            ConstraintWidget constraintWidget = frame.getWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            KeyPosition keyPosition = (KeyPosition)map2.get(constraintWidget.getStringId());
            if (keyPosition == null) continue;
            ++numKeyPositions;
        }
        return numKeyPositions;
    }

    @NotNull
    public final Motion getMotion(@Nullable String id) {
        return this.getWidgetState(id, null, 0).getMMotionControl();
    }

    public final void fillKeyPositions(@NotNull WidgetFrame frame, @NotNull float[] x, @NotNull float[] y, @NotNull float[] pos) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            HashMap<String, KeyPosition> map = this.mKeyPositions.get(frameNumber);
            if (map == null) continue;
            Map map2 = map;
            ConstraintWidget constraintWidget = frame.getWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            KeyPosition keyPosition = (KeyPosition)map2.get(constraintWidget.getStringId());
            if (keyPosition == null) continue;
            x[numKeyPositions] = keyPosition.getMX();
            y[numKeyPositions] = keyPosition.getMY();
            pos[numKeyPositions] = keyPosition.getMFrame();
            ++numKeyPositions;
        }
    }

    public final boolean hasPositionKeyframes() {
        return this.mKeyPositions.size() > 0;
    }

    public final void setTransitionProperties(@NotNull TypedBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        bundle.applyDelta(this.mBundle);
        bundle.applyDelta(this);
    }

    @Override
    public boolean setValue(int id, int value) {
        return false;
    }

    @Override
    public boolean setValue(int id, float value) {
        if (id == 706) {
            this.mStagger = value;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setValue(int id, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (id == 705) {
            void it;
            String string;
            String string2 = string = value;
            Easing.Companion companion = Easing.Companion;
            Transition transition = this;
            boolean bl = false;
            this.mDefaultInterpolatorString = it;
            Unit unit = Unit.INSTANCE;
            transition.mEasing = companion.getInterpolator(string);
        }
        return false;
    }

    @Override
    public boolean setValue(int id, boolean value) {
        return false;
    }

    @Override
    public int getId(@Nullable String name) {
        return 0;
    }

    public final boolean isEmpty() {
        return this.mState.isEmpty();
    }

    public final void clear() {
        this.mState.clear();
    }

    public final void resetProperties() {
        this.mOnSwipe = null;
        this.mBundle.clear();
    }

    public final boolean contains(@Nullable String key) {
        return ((Map)this.mState).containsKey(key);
    }

    public final void addKeyPosition(@Nullable String target, @NotNull TypedBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
    }

    public final void addKeyAttribute(@Nullable String target, @NotNull TypedBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.getWidgetState(target, null, 0).setKeyAttribute(bundle);
    }

    public final void addKeyAttribute(@Nullable String target, @NotNull TypedBundle bundle, @Nullable CustomVariable[] custom) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.getWidgetState(target, null, 0).setKeyAttribute(bundle, custom);
    }

    public final void addKeyCycle(@Nullable String target, @NotNull TypedBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.getWidgetState(target, null, 0).setKeyCycle(bundle);
    }

    public final void addKeyPosition(@Nullable String target, int frame, int type, float x, float y) {
        TypedBundle bundle = new TypedBundle();
        bundle.add(510, 2);
        bundle.add(100, frame);
        bundle.add(506, x);
        bundle.add(507, y);
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
        String string = target;
        Intrinsics.checkNotNull((Object)string);
        KeyPosition keyPosition = new KeyPosition(string, frame, type, x, y);
        HashMap<String, KeyPosition> map = this.mKeyPositions.get(frame);
        if (map == null) {
            map = new HashMap();
            Integer n = frame;
            ((Map)this.mKeyPositions).put(n, map);
        }
        ((Map)map).put(target, keyPosition);
    }

    public final void addCustomFloat(int state, @Nullable String widgetId, @NotNull String property, float value) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Companion.WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomFloat(property, value);
    }

    public final void addCustomColor(int state, @Nullable String widgetId, @NotNull String property, int color) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Companion.WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomColor(property, color);
    }

    private final void calculateParentDimensions(float progress) {
        this.mParentInterpolatedWidth = (int)(0.5f + (float)this.mParentStartWidth + (float)(this.mParentEndWidth - this.mParentStartWidth) * progress);
        this.mParentInterpolateHeight = (int)(0.5f + (float)this.mParentStartHeight + (float)(this.mParentEndHeight - this.mParentStartHeight) * progress);
    }

    public final int getInterpolatedWidth() {
        return this.mParentInterpolatedWidth;
    }

    public final int getInterpolatedHeight() {
        return this.mParentInterpolateHeight;
    }

    public final void updateFrom(@NotNull ConstraintWidgetContainer container, int state) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.mWrap = container.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        this.mWrap |= container.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        if (state == 0) {
            this.mParentInterpolatedWidth = this.mParentStartWidth = container.getWidth();
            this.mParentInterpolateHeight = this.mParentStartHeight = container.getHeight();
        } else {
            this.mParentEndWidth = container.getWidth();
            this.mParentEndHeight = container.getHeight();
        }
        ArrayList<ConstraintWidget> children = container.getChildren();
        int count = children.size();
        Companion.WidgetState[] states = new Companion.WidgetState[count];
        for (int i = 0; i < count; ++i) {
            ConstraintWidget child;
            Companion.WidgetState widgetState;
            Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
            states[i] = widgetState = this.getWidgetState(child.getStringId(), null, state);
            widgetState.update(child, state);
            String id = widgetState.getPathRelativeId();
            if (id == null) continue;
            widgetState.setPathRelative(this.getWidgetState(id, null, state));
        }
        this.calcStagger();
    }

    public final void interpolate(int parentWidth, int parentHeight, float progress) {
        float progress2 = progress;
        if (this.mWrap) {
            this.calculateParentDimensions(progress2);
        }
        if (this.mEasing != null) {
            Easing easing = this.mEasing;
            Intrinsics.checkNotNull((Object)easing);
            progress2 = (float)easing.get(progress2);
        }
        Iterator<String> iterator = this.mState.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            Companion.WidgetState widget;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Companion.WidgetState widgetState = widget = this.mState.get(key);
            if (widgetState == null) continue;
            widgetState.interpolate(parentWidth, parentHeight, progress2, this);
        }
    }

    @NotNull
    public final WidgetFrame getStart(@Nullable String id) {
        Companion.WidgetState widgetState = (Companion.WidgetState)((Map)this.mState).get(id);
        if (widgetState == null) {
            Intrinsics.checkNotNull(null);
            return null;
        }
        Companion.WidgetState widgetState2 = widgetState;
        return widgetState2.getMStart();
    }

    @NotNull
    public final WidgetFrame getEnd(@Nullable String id) {
        Companion.WidgetState widgetState = (Companion.WidgetState)((Map)this.mState).get(id);
        if (widgetState == null) {
            Intrinsics.checkNotNull(null);
            return null;
        }
        Companion.WidgetState widgetState2 = widgetState;
        return widgetState2.getMEnd();
    }

    @NotNull
    public final WidgetFrame getInterpolated(@Nullable String id) {
        Companion.WidgetState widgetState = (Companion.WidgetState)((Map)this.mState).get(id);
        if (widgetState == null) {
            Intrinsics.checkNotNull(null);
            return null;
        }
        Companion.WidgetState widgetState2 = widgetState;
        return widgetState2.getMInterpolated();
    }

    @NotNull
    public final float[] getPath(@Nullable String id) {
        Object v = ((Map)this.mState).get(id);
        Intrinsics.checkNotNull(v);
        Companion.WidgetState widgetState = (Companion.WidgetState)v;
        int duration = 1000;
        int frames = duration / 16;
        float[] mPoints = new float[frames * 2];
        widgetState.getMMotionControl().buildPath(mPoints, frames);
        return mPoints;
    }

    public final int getKeyFrames(@Nullable String id, @Nullable float[] rectangles, @Nullable int[] pathMode, @Nullable int[] position) {
        Object v = ((Map)this.mState).get(id);
        Intrinsics.checkNotNull(v);
        Companion.WidgetState widgetState = (Companion.WidgetState)v;
        return widgetState.getMMotionControl().buildKeyFrames(rectangles, pathMode, position);
    }

    private final Companion.WidgetState getWidgetState(String widgetId) {
        return this.mState.get(widgetId);
    }

    @NotNull
    public final Companion.WidgetState getWidgetState(@Nullable String widgetId, @Nullable ConstraintWidget child, int transitionState) {
        Companion.WidgetState widgetState = (Companion.WidgetState)((Map)this.mState).get(widgetId);
        if (widgetState == null) {
            widgetState = new Companion.WidgetState();
            this.mBundle.applyDelta(widgetState.getMMotionControl());
            widgetState.getMMotionWidgetStart().updateMotion(widgetState.getMMotionControl());
            Map map = this.mState;
            String string = widgetId;
            Intrinsics.checkNotNull((Object)string);
            map.put(string, widgetState);
            if (child != null) {
                widgetState.update(child, transitionState);
            }
        }
        return widgetState;
    }

    @NotNull
    public final WidgetFrame getStart(@NotNull ConstraintWidget child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.getWidgetState(child.getStringId(), null, 0).getMStart();
    }

    @NotNull
    public final WidgetFrame getEnd(@NotNull ConstraintWidget child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.getWidgetState(child.getStringId(), null, 1).getMEnd();
    }

    @NotNull
    public final WidgetFrame getInterpolated(@NotNull ConstraintWidget child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.getWidgetState(child.getStringId(), null, 2).getMInterpolated();
    }

    @Nullable
    public final Interpolator getInterpolator() {
        return Companion.getInterpolator(this.mDefaultInterpolator, this.mDefaultInterpolatorString);
    }

    public final int getAutoTransition() {
        return this.mAutoTransition;
    }

    public final void calcStagger() {
        Motion f;
        String widgetId;
        Companion.WidgetState widgetState;
        if (this.mStagger == 0.0f) {
            return;
        }
        boolean flip = (double)this.mStagger < 0.0;
        float stagger = Math.abs(this.mStagger);
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        boolean useMotionStagger = false;
        Iterator<String> iterator = this.mState.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Companion.WidgetState widgetState2 = widgetState = this.mState.get(widgetId);
            Intrinsics.checkNotNull((Object)widgetState2);
            f = widgetState2.getMMotionControl();
            if (Float.isNaN(f.getMotionStagger())) continue;
            useMotionStagger = true;
            break;
        }
        if (useMotionStagger) {
            float widgetStagger;
            iterator = this.mState.keySet().iterator();
            while (iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Companion.WidgetState widgetState3 = widgetState = this.mState.get(widgetId);
                Intrinsics.checkNotNull((Object)widgetState3);
                f = widgetState3.getMMotionControl();
                widgetStagger = f.getMotionStagger();
                if (Float.isNaN(widgetStagger)) continue;
                min = Math.min(min, widgetStagger);
                max = Math.max(max, widgetStagger);
            }
            iterator = this.mState.keySet().iterator();
            while (iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Companion.WidgetState widgetState4 = widgetState = this.mState.get(widgetId);
                Intrinsics.checkNotNull((Object)widgetState4);
                f = widgetState4.getMMotionControl();
                widgetStagger = f.getMotionStagger();
                if (Float.isNaN(widgetStagger)) continue;
                float scale = 1.0f / (1.0f - stagger);
                float offset = stagger - stagger * (widgetStagger - min) / (max - min);
                if (flip) {
                    offset = stagger - stagger * (max - widgetStagger) / (max - min);
                }
                f.setStaggerScale(scale);
                f.setStaggerOffset(offset);
            }
        } else {
            float widgetStagger;
            float y;
            float x;
            iterator = this.mState.keySet().iterator();
            while (iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Companion.WidgetState widgetState5 = widgetState = this.mState.get(widgetId);
                Intrinsics.checkNotNull((Object)widgetState5);
                f = widgetState5.getMMotionControl();
                x = f.getFinalX();
                y = f.getFinalY();
                widgetStagger = x + y;
                min = Math.min(min, widgetStagger);
                max = Math.max(max, widgetStagger);
            }
            iterator = this.mState.keySet().iterator();
            while (iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Companion.WidgetState widgetState6 = widgetState = this.mState.get(widgetId);
                Intrinsics.checkNotNull((Object)widgetState6);
                f = widgetState6.getMMotionControl();
                x = f.getFinalX();
                y = f.getFinalY();
                widgetStagger = x + y;
                float offset = stagger - stagger * (widgetStagger - min) / (max - min);
                if (flip) {
                    offset = stagger - stagger * (max - widgetStagger) / (max - min);
                }
                float scale = 1.0f / (1.0f - stagger);
                f.setStaggerScale(scale);
                f.setStaggerOffset(offset);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u00a8\u0006\u001a"}, d2={"Landroidx/constraintlayout/core/state/Transition$Companion;", "", "<init>", "()V", "DEBUG", "", "START", "", "END", "INTERPOLATED", "EASE_IN_OUT", "EASE_IN", "EASE_OUT", "LINEAR", "BOUNCE", "OVERSHOOT", "ANTICIPATE", "SPLINE_STRING", "INTERPOLATOR_REFERENCE_ID", "getINTERPOLATOR_REFERENCE_ID$annotations", "getInterpolator", "Landroidx/constraintlayout/core/state/Interpolator;", "interpolator", "interpolatorString", "", "WidgetState", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getINTERPOLATOR_REFERENCE_ID$annotations() {
        }

        @Nullable
        public final Interpolator getInterpolator(int interpolator, @Nullable String interpolatorString) {
            switch (interpolator) {
                case -1: {
                    return arg_0 -> Companion.getInterpolator$lambda$0(interpolatorString, arg_0);
                }
                case 0: {
                    return Companion::getInterpolator$lambda$1;
                }
                case 1: {
                    return Companion::getInterpolator$lambda$2;
                }
                case 2: {
                    return Companion::getInterpolator$lambda$3;
                }
                case 3: {
                    return Companion::getInterpolator$lambda$4;
                }
                case 6: {
                    return Companion::getInterpolator$lambda$5;
                }
                case 5: {
                    return Companion::getInterpolator$lambda$6;
                }
                case 4: {
                    return Companion::getInterpolator$lambda$7;
                }
            }
            return null;
        }

        private static final float getInterpolator$lambda$0(String $interpolatorString, float v) {
            Easing easing = Easing.Companion.getInterpolator($interpolatorString);
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$1(float v) {
            Easing easing = Easing.Companion.getInterpolator("standard");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$2(float v) {
            Easing easing = Easing.Companion.getInterpolator("accelerate");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$3(float v) {
            Easing easing = Easing.Companion.getInterpolator("decelerate");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$4(float v) {
            Easing easing = Easing.Companion.getInterpolator("linear");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$5(float v) {
            Easing easing = Easing.Companion.getInterpolator("anticipate");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$6(float v) {
            Easing easing = Easing.Companion.getInterpolator("overshoot");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        private static final float getInterpolator$lambda$7(float v) {
            Easing easing = Easing.Companion.getInterpolator("spline(0.0, 0.2, 0.4, 0.6, 0.8 ,1.0, 0.8, 1.0, 0.9, 1.0)");
            Intrinsics.checkNotNull((Object)easing);
            return (float)easing.get(v);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020:J%\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0010\u0010<\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010>\u0018\u00010=\u00a2\u0006\u0002\u0010?J\u000e\u0010@\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0018\u0010A\u001a\u0002082\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020/J\b\u0010E\u001a\u0004\u0018\u00010FJ\u000e\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020/J(\u0010I\u001a\u0002082\u0006\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010OJ\u000e\u0010P\u001a\u0002082\u0006\u0010Q\u001a\u00020\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103\u00a8\u0006R"}, d2={"Landroidx/constraintlayout/core/state/Transition$Companion$WidgetState;", "", "<init>", "()V", "mStart", "Landroidx/constraintlayout/core/state/WidgetFrame;", "getMStart", "()Landroidx/constraintlayout/core/state/WidgetFrame;", "setMStart", "(Landroidx/constraintlayout/core/state/WidgetFrame;)V", "mEnd", "getMEnd", "setMEnd", "mInterpolated", "getMInterpolated", "setMInterpolated", "mMotionControl", "Landroidx/constraintlayout/core/motion/Motion;", "getMMotionControl", "()Landroidx/constraintlayout/core/motion/Motion;", "setMMotionControl", "(Landroidx/constraintlayout/core/motion/Motion;)V", "mNeedSetup", "", "getMNeedSetup", "()Z", "setMNeedSetup", "(Z)V", "mMotionWidgetStart", "Landroidx/constraintlayout/core/motion/MotionWidget;", "getMMotionWidgetStart", "()Landroidx/constraintlayout/core/motion/MotionWidget;", "setMMotionWidgetStart", "(Landroidx/constraintlayout/core/motion/MotionWidget;)V", "mMotionWidgetEnd", "getMMotionWidgetEnd", "setMMotionWidgetEnd", "mMotionWidgetInterpolated", "getMMotionWidgetInterpolated", "setMMotionWidgetInterpolated", "mKeyCache", "Landroidx/constraintlayout/core/motion/utils/KeyCache;", "getMKeyCache", "()Landroidx/constraintlayout/core/motion/utils/KeyCache;", "setMKeyCache", "(Landroidx/constraintlayout/core/motion/utils/KeyCache;)V", "mParentHeight", "", "getMParentHeight", "()I", "setMParentHeight", "(I)V", "mParentWidth", "getMParentWidth", "setMParentWidth", "setKeyPosition", "", "prop", "Landroidx/constraintlayout/core/motion/utils/TypedBundle;", "setKeyAttribute", "custom", "", "Landroidx/constraintlayout/core/motion/CustomVariable;", "(Landroidx/constraintlayout/core/motion/utils/TypedBundle;[Landroidx/constraintlayout/core/motion/CustomVariable;)V", "setKeyCycle", "update", "child", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "state", "getPathRelativeId", "", "getFrame", "type", "interpolate", "parentWidth", "parentHeight", "progress", "", "transition", "Landroidx/constraintlayout/core/state/Transition;", "setPathRelative", "widgetState", "compose"})
        @StabilityInferred(parameters=0)
        public static final class WidgetState {
            @NotNull
            private WidgetFrame mStart;
            @NotNull
            private WidgetFrame mEnd;
            @NotNull
            private WidgetFrame mInterpolated;
            @NotNull
            private Motion mMotionControl;
            private boolean mNeedSetup = true;
            @NotNull
            private MotionWidget mMotionWidgetStart;
            @NotNull
            private MotionWidget mMotionWidgetEnd;
            @NotNull
            private MotionWidget mMotionWidgetInterpolated;
            @NotNull
            private KeyCache mKeyCache = new KeyCache();
            private int mParentHeight = -1;
            private int mParentWidth = -1;
            public static final int $stable = 8;

            @NotNull
            public final WidgetFrame getMStart() {
                return this.mStart;
            }

            public final void setMStart(@NotNull WidgetFrame widgetFrame) {
                Intrinsics.checkNotNullParameter((Object)widgetFrame, (String)"<set-?>");
                this.mStart = widgetFrame;
            }

            @NotNull
            public final WidgetFrame getMEnd() {
                return this.mEnd;
            }

            public final void setMEnd(@NotNull WidgetFrame widgetFrame) {
                Intrinsics.checkNotNullParameter((Object)widgetFrame, (String)"<set-?>");
                this.mEnd = widgetFrame;
            }

            @NotNull
            public final WidgetFrame getMInterpolated() {
                return this.mInterpolated;
            }

            public final void setMInterpolated(@NotNull WidgetFrame widgetFrame) {
                Intrinsics.checkNotNullParameter((Object)widgetFrame, (String)"<set-?>");
                this.mInterpolated = widgetFrame;
            }

            @NotNull
            public final Motion getMMotionControl() {
                return this.mMotionControl;
            }

            public final void setMMotionControl(@NotNull Motion motion) {
                Intrinsics.checkNotNullParameter((Object)motion, (String)"<set-?>");
                this.mMotionControl = motion;
            }

            public final boolean getMNeedSetup() {
                return this.mNeedSetup;
            }

            public final void setMNeedSetup(boolean bl) {
                this.mNeedSetup = bl;
            }

            @NotNull
            public final MotionWidget getMMotionWidgetStart() {
                return this.mMotionWidgetStart;
            }

            public final void setMMotionWidgetStart(@NotNull MotionWidget motionWidget) {
                Intrinsics.checkNotNullParameter((Object)motionWidget, (String)"<set-?>");
                this.mMotionWidgetStart = motionWidget;
            }

            @NotNull
            public final MotionWidget getMMotionWidgetEnd() {
                return this.mMotionWidgetEnd;
            }

            public final void setMMotionWidgetEnd(@NotNull MotionWidget motionWidget) {
                Intrinsics.checkNotNullParameter((Object)motionWidget, (String)"<set-?>");
                this.mMotionWidgetEnd = motionWidget;
            }

            @NotNull
            public final MotionWidget getMMotionWidgetInterpolated() {
                return this.mMotionWidgetInterpolated;
            }

            public final void setMMotionWidgetInterpolated(@NotNull MotionWidget motionWidget) {
                Intrinsics.checkNotNullParameter((Object)motionWidget, (String)"<set-?>");
                this.mMotionWidgetInterpolated = motionWidget;
            }

            @NotNull
            public final KeyCache getMKeyCache() {
                return this.mKeyCache;
            }

            public final void setMKeyCache(@NotNull KeyCache keyCache) {
                Intrinsics.checkNotNullParameter((Object)keyCache, (String)"<set-?>");
                this.mKeyCache = keyCache;
            }

            public final int getMParentHeight() {
                return this.mParentHeight;
            }

            public final void setMParentHeight(int n) {
                this.mParentHeight = n;
            }

            public final int getMParentWidth() {
                return this.mParentWidth;
            }

            public final void setMParentWidth(int n) {
                this.mParentWidth = n;
            }

            public WidgetState() {
                this.mStart = new WidgetFrame();
                this.mEnd = new WidgetFrame();
                this.mInterpolated = new WidgetFrame();
                this.mMotionWidgetStart = new MotionWidget(this.mStart);
                this.mMotionWidgetEnd = new MotionWidget(this.mEnd);
                this.mMotionWidgetInterpolated = new MotionWidget(this.mInterpolated);
                this.mMotionControl = new Motion(this.mMotionWidgetStart);
                this.mMotionControl.setStart(this.mMotionWidgetStart);
                this.mMotionControl.setEnd(this.mMotionWidgetEnd);
            }

            public final void setKeyPosition(@NotNull TypedBundle prop) {
                Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
                MotionKeyPosition keyPosition = new MotionKeyPosition();
                prop.applyDelta(keyPosition);
                this.mMotionControl.addKey(keyPosition);
            }

            public final void setKeyAttribute(@NotNull TypedBundle prop) {
                Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
                MotionKeyAttributes keyAttributes = new MotionKeyAttributes();
                prop.applyDelta(keyAttributes);
                this.mMotionControl.addKey(keyAttributes);
            }

            public final void setKeyAttribute(@NotNull TypedBundle prop, @Nullable CustomVariable[] custom) {
                Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
                MotionKeyAttributes keyAttributes = new MotionKeyAttributes();
                prop.applyDelta(keyAttributes);
                if (custom != null) {
                    int n = custom.length;
                    for (int i = 0; i < n; ++i) {
                        CustomVariable customVariable;
                        if (custom[i] == null) continue;
                        boolean bl = false;
                        HashMap<String, CustomVariable> hashMap = keyAttributes.getMCustom();
                        if (hashMap == null) continue;
                        ((Map)hashMap).put(customVariable.getName(), customVariable);
                    }
                }
                this.mMotionControl.addKey(keyAttributes);
            }

            public final void setKeyCycle(@NotNull TypedBundle prop) {
                Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
                MotionKeyCycle keyAttributes = new MotionKeyCycle();
                prop.applyDelta(keyAttributes);
                this.mMotionControl.addKey(keyAttributes);
            }

            public final void update(@Nullable ConstraintWidget child, int state) {
                switch (state) {
                    case 0: {
                        this.mStart.update(child);
                        this.mMotionWidgetStart.updateMotion(this.mMotionWidgetStart);
                        this.mMotionControl.setStart(this.mMotionWidgetStart);
                        this.mNeedSetup = true;
                        break;
                    }
                    case 1: {
                        this.mEnd.update(child);
                        this.mMotionControl.setEnd(this.mMotionWidgetEnd);
                        this.mNeedSetup = true;
                    }
                }
                this.mParentWidth = -1;
            }

            @Nullable
            public final String getPathRelativeId() {
                return this.mMotionControl.getAnimateRelativeTo();
            }

            @NotNull
            public final WidgetFrame getFrame(int type) {
                switch (type) {
                    case 0: {
                        return this.mStart;
                    }
                    case 1: {
                        return this.mEnd;
                    }
                }
                return this.mInterpolated;
            }

            public final void interpolate(int parentWidth, int parentHeight, float progress, @Nullable Transition transition) {
                this.mParentHeight = parentHeight;
                this.mParentWidth = parentWidth;
                if (this.mNeedSetup) {
                    this.mMotionControl.setup(parentWidth, parentHeight, 1.0f, androidx.constraintlayout.core.platform.System.INSTANCE.nanoTime());
                    this.mNeedSetup = false;
                }
                Transition transition2 = transition;
                Intrinsics.checkNotNull((Object)transition2);
                WidgetFrame.Companion.interpolate(parentWidth, parentHeight, this.mInterpolated, this.mStart, this.mEnd, transition2, progress);
                this.mInterpolated.setInterpolatedPos(progress);
                this.mMotionControl.interpolate(this.mMotionWidgetInterpolated, progress, androidx.constraintlayout.core.platform.System.INSTANCE.nanoTime(), this.mKeyCache);
            }

            public final void setPathRelative(@NotNull WidgetState widgetState) {
                Intrinsics.checkNotNullParameter((Object)widgetState, (String)"widgetState");
                this.mMotionControl.setupRelative(widgetState.mMotionControl);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0019\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0019\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u0006!"}, d2={"Landroidx/constraintlayout/core/state/Transition$KeyPosition;", "", "target", "", "frame", "", "type", "x", "", "y", "<init>", "(Ljava/lang/String;IIFF)V", "mFrame", "getMFrame", "()I", "setMFrame", "(I)V", "mTarget", "getMTarget", "()Ljava/lang/String;", "setMTarget", "(Ljava/lang/String;)V", "mType", "getMType", "setMType", "mX", "getMX", "()F", "setMX", "(F)V", "mY", "getMY", "setMY", "compose"})
    @StabilityInferred(parameters=0)
    public static final class KeyPosition {
        private int mFrame;
        @NotNull
        private String mTarget;
        private int mType;
        private float mX;
        private float mY;
        public static final int $stable = 8;

        public KeyPosition(@NotNull String target, int frame, int type, float x, float y) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.mFrame = frame;
            this.mTarget = target;
            this.mType = type;
            this.mX = x;
            this.mY = y;
        }

        public final int getMFrame() {
            return this.mFrame;
        }

        public final void setMFrame(int n) {
            this.mFrame = n;
        }

        @NotNull
        public final String getMTarget() {
            return this.mTarget;
        }

        public final void setMTarget(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mTarget = string;
        }

        public final int getMType() {
            return this.mType;
        }

        public final void setMType(int n) {
            this.mType = n;
        }

        public final float getMX() {
            return this.mX;
        }

        public final void setMX(float f) {
            this.mX = f;
        }

        public final float getMY() {
            return this.mY;
        }

        public final void setMY(float f) {
            this.mY = f;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b'\b\u0007\u0018\u0000 R2\u00020\u0001:\u0001RB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020)J\u0010\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0005J\u000e\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020\u000bJ\u0010\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0005J\u0010\u00102\u001a\u00020,2\b\u00103\u001a\u0004\u0018\u00010\u0005J\u000e\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\u0018J\u000e\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020\u0018J\u000e\u0010:\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020\u0018J\u000e\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020\u0018J\u000e\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010A\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010B\u001a\u00020,2\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010C\u001a\u00020,2\u0006\u0010!\u001a\u00020\u0018J\u000e\u0010D\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010E\u001a\u00020,2\u0006\u0010$\u001a\u00020\u000bJ\u001e\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u00182\u0006\u0010H\u001a\u00020\u00182\u0006\u0010I\u001a\u00020\u0018J&\u0010J\u001a\u00020,2\u0006\u0010K\u001a\u00020\u00182\u0006\u0010H\u001a\u00020\u00182\u0006\u0010L\u001a\u00020&2\u0006\u0010I\u001a\u00020\u0018J\u000e\u0010M\u001a\u00020\u00182\u0006\u0010N\u001a\u00020&J\u0006\u0010O\u001a\u00020,J\u000e\u0010P\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\u0018R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0003R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001a\u0010\u0003R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Landroidx/constraintlayout/core/state/Transition$OnSwipe;", "", "<init>", "()V", "mAnchorId", "", "getMAnchorId", "()Ljava/lang/String;", "setMAnchorId", "(Ljava/lang/String;)V", "mAnchorSide", "", "mEngine", "Landroidx/constraintlayout/core/motion/utils/StopEngine;", "mRotationCenterId", "getMRotationCenterId$annotations", "mLimitBoundsTo", "getMLimitBoundsTo", "setMLimitBoundsTo", "mDragVertical", "", "getMDragVertical$annotations", "mDragDirection", "mDragScale", "", "mDragThreshold", "getMDragThreshold$annotations", "mAutoCompleteMode", "mMaxVelocity", "mMaxAcceleration", "mOnTouchUp", "mSpringMass", "mSpringStiffness", "mSpringDamping", "mSpringStopThreshold", "mDestination", "mSpringBoundary", "mStart", "", "getScale", "getDirection", "", "getSide", "setAnchorId", "", "anchorId", "setAnchorSide", "anchorSide", "setRotationCenterId", "rotationCenterId", "setLimitBoundsTo", "limitBoundsTo", "setDragDirection", "dragDirection", "setDragScale", "dragScale", "setDragThreshold", "dragThreshold", "setAutoCompleteMode", "setMaxVelocity", "maxVelocity", "setMaxAcceleration", "maxAcceleration", "setOnTouchUp", "onTouchUp", "setSpringMass", "setSpringStiffness", "setSpringDamping", "setSpringStopThreshold", "setSpringBoundary", "getDestinationPosition", "currentPosition", "velocity", "duration", "config", "position", "start", "getTouchUpProgress", "currentTime", "printInfo", "isNotDone", "progress", "Companion", "compose"})
    @StabilityInferred(parameters=0)
    public static final class OnSwipe {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String mAnchorId;
        private int mAnchorSide;
        @Nullable
        private StopEngine mEngine;
        @Nullable
        private String mRotationCenterId;
        @Nullable
        private String mLimitBoundsTo;
        private boolean mDragVertical = true;
        private int mDragDirection;
        private float mDragScale = 1.0f;
        private float mDragThreshold = 10.0f;
        private int mAutoCompleteMode;
        private float mMaxVelocity = 4.0f;
        private float mMaxAcceleration = 1.2f;
        private int mOnTouchUp;
        private float mSpringMass = 1.0f;
        private float mSpringStiffness = 400.0f;
        private float mSpringDamping = 10.0f;
        private float mSpringStopThreshold = 0.01f;
        private float mDestination;
        private int mSpringBoundary;
        private long mStart;
        public static final int $stable = 8;
        public static final int ANCHOR_SIDE_TOP = 0;
        public static final int ANCHOR_SIDE_LEFT = 1;
        public static final int ANCHOR_SIDE_RIGHT = 2;
        public static final int ANCHOR_SIDE_BOTTOM = 3;
        public static final int ANCHOR_SIDE_MIDDLE = 4;
        public static final int ANCHOR_SIDE_START = 5;
        public static final int ANCHOR_SIDE_END = 6;
        @NotNull
        private static final String[] SIDES;
        @NotNull
        private static final float[][] TOUCH_SIDES;
        public static final int DRAG_UP = 0;
        public static final int DRAG_DOWN = 1;
        public static final int DRAG_LEFT = 2;
        public static final int DRAG_RIGHT = 3;
        public static final int DRAG_START = 4;
        public static final int DRAG_END = 5;
        public static final int DRAG_CLOCKWISE = 6;
        public static final int DRAG_ANTICLOCKWISE = 7;
        @NotNull
        private static final String[] DIRECTIONS;
        public static final int MODE_CONTINUOUS_VELOCITY = 0;
        public static final int MODE_SPRING = 1;
        @NotNull
        private static final String[] MODE;
        public static final int ON_UP_AUTOCOMPLETE = 0;
        public static final int ON_UP_AUTOCOMPLETE_TO_START = 1;
        public static final int ON_UP_AUTOCOMPLETE_TO_END = 2;
        public static final int ON_UP_STOP = 3;
        public static final int ON_UP_DECELERATE = 4;
        public static final int ON_UP_DECELERATE_AND_COMPLETE = 5;
        public static final int ON_UP_NEVER_COMPLETE_TO_START = 6;
        public static final int ON_UP_NEVER_COMPLETE_TO_END = 7;
        @NotNull
        private static final String[] TOUCH_UP;
        public static final int BOUNDARY_OVERSHOOT = 0;
        public static final int BOUNDARY_BOUNCE_START = 1;
        public static final int BOUNDARY_BOUNCE_END = 2;
        public static final int BOUNDARY_BOUNCE_BOTH = 3;
        @NotNull
        private static final String[] BOUNDARY;
        @NotNull
        private static final float[][] TOUCH_DIRECTION;

        @Nullable
        public final String getMAnchorId() {
            return this.mAnchorId;
        }

        public final void setMAnchorId(@Nullable String string) {
            this.mAnchorId = string;
        }

        private static /* synthetic */ void getMRotationCenterId$annotations() {
        }

        @Nullable
        public final String getMLimitBoundsTo() {
            return this.mLimitBoundsTo;
        }

        public final void setMLimitBoundsTo(@Nullable String string) {
            this.mLimitBoundsTo = string;
        }

        private static /* synthetic */ void getMDragVertical$annotations() {
        }

        private static /* synthetic */ void getMDragThreshold$annotations() {
        }

        public final float getScale() {
            return this.mDragScale;
        }

        @NotNull
        public final float[] getDirection() {
            return TOUCH_DIRECTION[this.mDragDirection];
        }

        @NotNull
        public final float[] getSide() {
            return TOUCH_SIDES[this.mAnchorSide];
        }

        public final void setAnchorId(@Nullable String anchorId) {
            this.mAnchorId = anchorId;
        }

        public final void setAnchorSide(int anchorSide) {
            this.mAnchorSide = anchorSide;
        }

        public final void setRotationCenterId(@Nullable String rotationCenterId) {
            this.mRotationCenterId = rotationCenterId;
        }

        public final void setLimitBoundsTo(@Nullable String limitBoundsTo) {
            this.mLimitBoundsTo = limitBoundsTo;
        }

        public final void setDragDirection(int dragDirection) {
            this.mDragDirection = dragDirection;
            this.mDragVertical = this.mDragDirection < 2;
        }

        public final void setDragScale(float dragScale) {
            if (Float.isNaN(dragScale)) {
                return;
            }
            this.mDragScale = dragScale;
        }

        public final void setDragThreshold(float dragThreshold) {
            if (Float.isNaN(dragThreshold)) {
                return;
            }
            this.mDragThreshold = dragThreshold;
        }

        public final void setAutoCompleteMode(int mAutoCompleteMode) {
            this.mAutoCompleteMode = mAutoCompleteMode;
        }

        public final void setMaxVelocity(float maxVelocity) {
            if (Float.isNaN(maxVelocity)) {
                return;
            }
            this.mMaxVelocity = maxVelocity;
        }

        public final void setMaxAcceleration(float maxAcceleration) {
            if (Float.isNaN(maxAcceleration)) {
                return;
            }
            this.mMaxAcceleration = maxAcceleration;
        }

        public final void setOnTouchUp(int onTouchUp) {
            this.mOnTouchUp = onTouchUp;
        }

        public final void setSpringMass(float mSpringMass) {
            if (Float.isNaN(mSpringMass)) {
                return;
            }
            this.mSpringMass = mSpringMass;
        }

        public final void setSpringStiffness(float mSpringStiffness) {
            if (Float.isNaN(mSpringStiffness)) {
                return;
            }
            this.mSpringStiffness = mSpringStiffness;
        }

        public final void setSpringDamping(float mSpringDamping) {
            if (Float.isNaN(mSpringDamping)) {
                return;
            }
            this.mSpringDamping = mSpringDamping;
        }

        public final void setSpringStopThreshold(float mSpringStopThreshold) {
            if (Float.isNaN(mSpringStopThreshold)) {
                return;
            }
            this.mSpringStopThreshold = mSpringStopThreshold;
        }

        public final void setSpringBoundary(int mSpringBoundary) {
            this.mSpringBoundary = mSpringBoundary;
        }

        public final float getDestinationPosition(float currentPosition, float velocity, float duration) {
            float rest = currentPosition + 0.5f * Math.abs(velocity) * velocity / this.mMaxAcceleration;
            switch (this.mOnTouchUp) {
                case 1: {
                    return currentPosition >= 1.0f ? 1.0f : 0.0f;
                }
                case 7: {
                    return 0.0f;
                }
                case 2: {
                    return currentPosition <= 0.0f ? 0.0f : 1.0f;
                }
                case 6: {
                    return 1.0f;
                }
                case 3: {
                    return Float.NaN;
                }
                case 4: {
                    return Math.max(0.0f, Math.min(1.0f, rest));
                }
                case 5: {
                    return rest > 0.2f && rest < 0.8f ? rest : (rest > 0.5f ? 1.0f : 0.0f);
                }
            }
            return (double)rest > 0.5 ? 1.0f : 0.0f;
        }

        public final void config(float position, float velocity, long start, float duration) {
            float velocity2 = velocity;
            this.mStart = start;
            if (Math.abs(velocity2) > this.mMaxVelocity) {
                velocity2 = this.mMaxVelocity * Math.signum(velocity2);
            }
            this.mDestination = this.getDestinationPosition(position, velocity2, duration);
            if (this.mDestination == position) {
                this.mEngine = null;
                return;
            }
            if (this.mOnTouchUp == 4 && this.mAutoCompleteMode == 0) {
                StopLogicEngine.Decelerate sld = null;
                if (this.mEngine instanceof StopLogicEngine.Decelerate) {
                    StopEngine stopEngine = this.mEngine;
                    Intrinsics.checkNotNull((Object)stopEngine, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.motion.utils.StopLogicEngine.Decelerate");
                    sld = (StopLogicEngine.Decelerate)stopEngine;
                } else {
                    sld = new StopLogicEngine.Decelerate();
                    this.mEngine = sld;
                }
                sld.config(position, this.mDestination, velocity2);
                return;
            }
            if (this.mAutoCompleteMode == 0) {
                StopLogicEngine sl = null;
                if (this.mEngine instanceof StopLogicEngine) {
                    StopEngine stopEngine = this.mEngine;
                    Intrinsics.checkNotNull((Object)stopEngine, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.motion.utils.StopLogicEngine");
                    sl = (StopLogicEngine)stopEngine;
                } else {
                    sl = new StopLogicEngine();
                    this.mEngine = sl;
                }
                sl.config(position, this.mDestination, velocity2, duration, this.mMaxAcceleration, this.mMaxVelocity);
                return;
            }
            SpringStopEngine sl = null;
            if (this.mEngine instanceof SpringStopEngine) {
                StopEngine stopEngine = this.mEngine;
                Intrinsics.checkNotNull((Object)stopEngine, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.motion.utils.SpringStopEngine");
                sl = (SpringStopEngine)stopEngine;
            } else {
                sl = new SpringStopEngine();
                this.mEngine = sl;
            }
            sl.springConfig(position, this.mDestination, velocity2, this.mSpringMass, this.mSpringStiffness, this.mSpringDamping, this.mSpringStopThreshold, this.mSpringBoundary);
        }

        public final float getTouchUpProgress(long currentTime) {
            float time = (float)(currentTime - this.mStart) * 1.0E-9f;
            StopEngine stopEngine = this.mEngine;
            Intrinsics.checkNotNull((Object)stopEngine);
            float pos = stopEngine.getInterpolation(time);
            StopEngine stopEngine2 = this.mEngine;
            Intrinsics.checkNotNull((Object)stopEngine2);
            if (stopEngine2.isStopped()) {
                pos = this.mDestination;
            }
            return pos;
        }

        public final void printInfo() {
            if (this.mAutoCompleteMode == 0) {
                StopEngine stopEngine = this.mEngine;
                Intrinsics.checkNotNull((Object)stopEngine);
                System.out.println((Object)("velocity = " + stopEngine.getVelocity()));
                System.out.println((Object)("mMaxAcceleration = " + this.mMaxAcceleration));
                System.out.println((Object)("mMaxVelocity = " + this.mMaxVelocity));
            } else {
                System.out.println((Object)("mSpringMass          = " + this.mSpringMass));
                System.out.println((Object)("mSpringStiffness     = " + this.mSpringStiffness));
                System.out.println((Object)("mSpringDamping       = " + this.mSpringDamping));
                System.out.println((Object)("mSpringStopThreshold = " + this.mSpringStopThreshold));
                System.out.println((Object)("mSpringBoundary      = " + this.mSpringBoundary));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNotDone(float progress) {
            if (this.mOnTouchUp == 3) {
                return false;
            }
            if (this.mEngine == null) return false;
            StopEngine stopEngine = this.mEngine;
            Intrinsics.checkNotNull((Object)stopEngine);
            if (stopEngine.isStopped()) return false;
            return true;
        }

        static {
            Object object = new String[]{"top", "left", "right", "bottom", "middle", "start", "end"};
            SIDES = object;
            object = new float[7][];
            float[] fArray = new float[]{0.5f, 0.0f};
            object[0] = fArray;
            fArray = new float[]{0.0f, 0.5f};
            object[1] = fArray;
            fArray = new float[]{1.0f, 0.5f};
            object[2] = fArray;
            fArray = new float[]{0.5f, 1.0f};
            object[3] = fArray;
            fArray = new float[]{0.5f, 0.5f};
            object[4] = fArray;
            fArray = new float[]{0.0f, 0.5f};
            object[5] = fArray;
            fArray = new float[]{1.0f, 0.5f};
            object[6] = fArray;
            TOUCH_SIDES = (float[][])object;
            object = new String[]{"up", "down", "left", "right", "start", "end", "clockwise", "anticlockwise"};
            DIRECTIONS = object;
            object = new String[]{"velocity", "spring"};
            MODE = object;
            object = new String[]{"autocomplete", "toStart", "toEnd", "stop", "decelerate", "decelerateComplete", "neverCompleteStart", "neverCompleteEnd"};
            TOUCH_UP = object;
            object = new String[]{"overshoot", "bounceStart", "bounceEnd", "bounceBoth"};
            BOUNDARY = object;
            object = new float[6][];
            fArray = new float[]{0.0f, -1.0f};
            object[0] = fArray;
            fArray = new float[]{0.0f, 1.0f};
            object[1] = fArray;
            fArray = new float[]{-1.0f, 0.0f};
            object[2] = fArray;
            fArray = new float[]{1.0f, 0.0f};
            object[3] = fArray;
            fArray = new float[]{-1.0f, 0.0f};
            object[4] = fArray;
            fArray = new float[]{1.0f, 0.0f};
            object[5] = fArray;
            TOUCH_DIRECTION = (float[][])object;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b!\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001e\u0010\u0010R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\"\u0010\u0010R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b,\u0010\u0010R\u000e\u0010-\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b2\u0010\u0010R\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u00064"}, d2={"Landroidx/constraintlayout/core/state/Transition$OnSwipe$Companion;", "", "<init>", "()V", "ANCHOR_SIDE_TOP", "", "ANCHOR_SIDE_LEFT", "ANCHOR_SIDE_RIGHT", "ANCHOR_SIDE_BOTTOM", "ANCHOR_SIDE_MIDDLE", "ANCHOR_SIDE_START", "ANCHOR_SIDE_END", "SIDES", "", "", "getSIDES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "TOUCH_SIDES", "", "[[F", "DRAG_UP", "DRAG_DOWN", "DRAG_LEFT", "DRAG_RIGHT", "DRAG_START", "DRAG_END", "DRAG_CLOCKWISE", "DRAG_ANTICLOCKWISE", "DIRECTIONS", "getDIRECTIONS", "MODE_CONTINUOUS_VELOCITY", "MODE_SPRING", "MODE", "getMODE", "ON_UP_AUTOCOMPLETE", "ON_UP_AUTOCOMPLETE_TO_START", "ON_UP_AUTOCOMPLETE_TO_END", "ON_UP_STOP", "ON_UP_DECELERATE", "ON_UP_DECELERATE_AND_COMPLETE", "ON_UP_NEVER_COMPLETE_TO_START", "ON_UP_NEVER_COMPLETE_TO_END", "TOUCH_UP", "getTOUCH_UP", "BOUNDARY_OVERSHOOT", "BOUNDARY_BOUNCE_START", "BOUNDARY_BOUNCE_END", "BOUNDARY_BOUNCE_BOTH", "BOUNDARY", "getBOUNDARY", "TOUCH_DIRECTION", "compose"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getSIDES() {
                return SIDES;
            }

            @NotNull
            public final String[] getDIRECTIONS() {
                return DIRECTIONS;
            }

            @NotNull
            public final String[] getMODE() {
                return MODE;
            }

            @NotNull
            public final String[] getTOUCH_UP() {
                return TOUCH_UP;
            }

            @NotNull
            public final String[] getBOUNDARY() {
                return BOUNDARY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

