/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.IntegerKt;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.CoreMotionScene;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.ChainReference;
import androidx.constraintlayout.core.state.helpers.Facade;
import androidx.constraintlayout.core.state.helpers.FlowReference;
import androidx.constraintlayout.core.state.helpers.GridReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser;", "", "<init>", "()V", "GeneratedValue", "MotionLayoutDebugFlags", "LayoutVariables", "DesignElement", "Generator", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class ConstraintSetParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean PARSER_DEBUG = false;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002WXB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0013J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010 \u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020#0\"j\b\u0012\u0004\u0012\u00020#`$J\u001e\u0010%\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'J\u001e\u0010(\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020'J\u0018\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020.H\u0002J0\u00100\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0013H\u0002J0\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0013H\u0002J0\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0013H\u0002J\u001e\u00108\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020'J(\u00109\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u001a2\b\u0010:\u001a\u0004\u0018\u00010\t2\u0006\u0010;\u001a\u00020\u0013J \u0010<\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\b\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0013J*\u0010>\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0013J0\u0010?\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020A2\u0006\u0010&\u001a\u00020\u00132\b\u0010B\u001a\u0004\u0018\u00010\tJ*\u0010>\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010@\u001a\u00020A2\u0006\u0010&\u001a\u00020\u0013J \u0010C\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00132\u0006\u0010@\u001a\u00020A2\b\u0010D\u001a\u0004\u0018\u00010\tJ)\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\t2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0H\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010IJ\u0018\u0010J\u001a\u00020\u00072\u0006\u0010&\u001a\u00020K2\u0006\u0010@\u001a\u00020AH\u0002J0\u0010L\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010@\u001a\u00020A2\b\u0010D\u001a\u0004\u0018\u00010\tJ\u000e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\tJ(\u0010P\u001a\u00020N2\u0006\u0010&\u001a\u00020\u00132\b\u0010D\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\tJ\u0010\u0010V\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$Companion;", "", "<init>", "()V", "PARSER_DEBUG", "", "parseJSON", "", "content", "", "transition", "Landroidx/constraintlayout/core/state/Transition;", "state", "", "parseMotionSceneJSON", "scene", "Landroidx/constraintlayout/core/state/CoreMotionScene;", "parseConstraintSets", "json", "Landroidx/constraintlayout/core/parser/CLObject;", "override", "baseJson", "name", "overrideValue", "parseTransitions", "parseHeader", "Landroidx/constraintlayout/core/state/State;", "layoutVariables", "Landroidx/constraintlayout/core/state/ConstraintSetParser$LayoutVariables;", "populateState", "parsedJson", "parseVariables", "parseDesignElementsJSON", "list", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/state/ConstraintSetParser$DesignElement;", "Lkotlin/collections/ArrayList;", "parseHelpers", "element", "Landroidx/constraintlayout/core/parser/CLArray;", "parseGenerate", "parseChain", "orientation", "margins", "helper", "toPix", "", "dp", "parseChainType", "chainName", "object", "parseGridType", "gridType", "parseFlowType", "flowType", "flowName", "parseGuideline", "parseGuidelineParams", "guidelineId", "params", "parseBarrier", "elementName", "parseWidget", "applyAttribute", "reference", "Landroidx/constraintlayout/core/state/ConstraintReference;", "attributeName", "parseCustomProperties", "constraintName", "indexOf", "val", "types", "", "(Ljava/lang/String;[Ljava/lang/String;)I", "parseMotionProperties", "Landroidx/constraintlayout/core/parser/CLElement;", "parseConstraint", "parseDimensionMode", "Landroidx/constraintlayout/core/state/Dimension;", "dimensionString", "parseDimension", "dpToPixels", "Landroidx/constraintlayout/core/state/CorePixelDp;", "parseColorString", "", "value", "lookForType", "FiniteGenerator", "OverrideValue", "compose"})
    @SourceDebugExtension(value={"SMAP\nConstraintSetParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintSetParser.kt\nandroidx/constraintlayout/core/state/ConstraintSetParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2041:1\n1#2:2042\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void parseJSON(@Nullable String content, @NotNull Transition transition, int state) {
            Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
            try {
                String string = content;
                Intrinsics.checkNotNull((Object)string);
                CLObject json = CLParser.Companion.parse(string);
                ArrayList<String> elements = json.names();
                Iterator<String> iterator = elements.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<String> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Iterator<String> iterator3;
                    CLObject customProperties;
                    String elementName;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    CLElement base_element = json.get(elementName);
                    if (!(base_element instanceof CLObject) || (customProperties = ((CLObject)base_element).getObjectOrNull("custom")) == null) continue;
                    ArrayList<String> properties = customProperties.names();
                    Intrinsics.checkNotNullExpressionValue(properties.iterator(), (String)"iterator(...)");
                    while (iterator3.hasNext()) {
                        long color;
                        String property;
                        Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                        CLElement value = customProperties.get(property);
                        if (value instanceof CLNumber) {
                            transition.addCustomFloat(state, elementName, property, ((CLNumber)value).getFloat());
                            continue;
                        }
                        if (!(value instanceof CLString) || (color = this.parseColorString(value.content())) == -1L) continue;
                        transition.addCustomColor(state, elementName, property, (int)color);
                    }
                }
            }
            catch (CLParsingException e) {
                System.out.println((Object)("Error parsing JSON " + e));
            }
        }

        public final void parseMotionSceneJSON(@NotNull CoreMotionScene scene, @Nullable String content) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            try {
                String string = content;
                Intrinsics.checkNotNull((Object)string);
                CLObject json = CLParser.Companion.parse(string);
                ArrayList<String> elements = json.names();
                Iterator<String> iterator = elements.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<String> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    String elementName;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    CLElement element = json.get(elementName);
                    if (!(element instanceof CLObject)) continue;
                    CLElement clObject = element;
                    switch (elementName) {
                        case "ConstraintSets": {
                            this.parseConstraintSets(scene, (CLObject)clObject);
                            break;
                        }
                        case "Transitions": {
                            this.parseTransitions(scene, (CLObject)clObject);
                            break;
                        }
                        case "Header": {
                            this.parseHeader(scene, (CLObject)clObject);
                        }
                    }
                }
            }
            catch (CLParsingException e) {
                System.out.println((Object)("Error parsing JSON " + e));
            }
        }

        public final void parseConstraintSets(@NotNull CoreMotionScene scene, @NotNull CLObject json) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            ArrayList<String> constraintSetNames = json.names();
            Iterator<String> iterator = constraintSetNames.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String csName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                CLObject constraintSet = json.getObject(csName);
                boolean added = false;
                String ext = constraintSet.getStringOrNull("Extends");
                if (ext != null && !(((CharSequence)ext).length() == 0)) {
                    Iterator<String> iterator3;
                    String base;
                    if (scene.getConstraintSet(ext) == null) continue;
                    CLObject baseJson = CLParser.Companion.parse(base);
                    ArrayList<String> widgetsOverride = constraintSet.names();
                    Intrinsics.checkNotNullExpressionValue(widgetsOverride.iterator(), (String)"iterator(...)");
                    while (iterator3.hasNext()) {
                        String widgetOverrideName;
                        Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                        CLElement value = constraintSet.get(widgetOverrideName);
                        if (!(value instanceof CLObject)) continue;
                        this.override(baseJson, widgetOverrideName, (CLObject)value);
                    }
                    scene.setConstraintSetContent(csName, baseJson.toJSON$compose());
                    added = true;
                }
                if (added) continue;
                scene.setConstraintSetContent(csName, constraintSet.toJSON$compose());
            }
        }

        /*
         * Unable to fully structure code
         */
        public final void override(@NotNull CLObject baseJson, @Nullable String name, @NotNull CLObject overrideValue) throws CLParsingException {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)baseJson, (String)"baseJson");
                    Intrinsics.checkNotNullParameter((Object)overrideValue, (String)"overrideValue");
                    if (baseJson.has(name)) break block9;
                    v0 = name;
                    Intrinsics.checkNotNull((Object)v0);
                    baseJson.put(v0, overrideValue);
                    break block10;
                }
                v1 = name;
                Intrinsics.checkNotNull((Object)v1);
                base = baseJson.getObject(v1);
                keys = overrideValue.names();
                v2 = keys.iterator();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"iterator(...)");
                var6_6 = v2;
                while (var6_6.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)var6_6.next(), (String)"next(...)");
                    if (!Intrinsics.areEqual((Object)key, (Object)"clear")) {
                        base.put(key, overrideValue.get(key));
                        continue;
                    }
                    toClear = overrideValue.getArray("clear");
                    var10_10 = toClear.size();
                    block6: for (i = 0; i < var10_10; ++i) {
                        block11: {
                            if (toClear.getStringOrNull(i) == null) continue;
                            var12_12 = clearedKey;
                            switch (var12_12.hashCode()) {
                                case -1727069561: {
                                    if (!var12_12.equals("transforms")) {
                                        ** break;
                                    }
                                    break block11;
                                }
                                case -1606703562: {
                                    if (var12_12.equals("constraints")) break;
                                    ** break;
                                }
                                case 414334925: {
                                    if (!var12_12.equals("dimensions")) ** break;
                                    base.remove("width");
                                    base.remove("height");
                                    continue block6;
                                }
                            }
                            base.remove("start");
                            base.remove("end");
                            base.remove("top");
                            base.remove("bottom");
                            base.remove("baseline");
                            base.remove("center");
                            base.remove("centerHorizontally");
                            base.remove("centerVertically");
                            continue;
                        }
                        base.remove("visibility");
                        base.remove("alpha");
                        base.remove("pivotX");
                        base.remove("pivotY");
                        base.remove("rotationX");
                        base.remove("rotationY");
                        base.remove("rotationZ");
                        base.remove("scaleX");
                        base.remove("scaleY");
                        base.remove("translationX");
                        base.remove("translationY");
                        continue;
lbl61:
                        // 4 sources

                        base.remove(clearedKey);
                    }
                }
            }
        }

        public final void parseTransitions(@NotNull CoreMotionScene scene, @NotNull CLObject json) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            ArrayList<String> elements = json.names();
            Iterator<String> iterator = elements.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String elementName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                scene.setTransitionContent(elementName, json.getObject(elementName).toJSON$compose());
            }
        }

        public final void parseHeader(@NotNull CoreMotionScene scene, @NotNull CLObject json) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String name = json.getStringOrNull("export");
            if (name != null) {
                scene.setDebugName(name);
            }
        }

        public final void parseJSON(@NotNull String content, @NotNull State state, @NotNull LayoutVariables layoutVariables) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
            try {
                CLObject json = CLParser.Companion.parse(content);
                this.populateState(json, state, layoutVariables);
            }
            catch (CLParsingException e) {
                System.out.println((Object)("Error parsing JSON " + e));
            }
        }

        public final void populateState(@NotNull CLObject parsedJson, @NotNull State state, @NotNull LayoutVariables layoutVariables) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)parsedJson, (String)"parsedJson");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
            ArrayList<String> elements = parsedJson.names();
            Iterator<String> iterator = elements.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            block30: while (iterator2.hasNext()) {
                CLElement element;
                String elementName;
                block45: {
                    block46: {
                        Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                        element = parsedJson.get(elementName);
                        switch (elementName) {
                            case "Variables": {
                                if (!(element instanceof CLObject)) continue block30;
                                this.parseVariables(state, layoutVariables, (CLObject)element);
                                continue block30;
                            }
                            case "Helpers": {
                                if (!(element instanceof CLArray)) continue block30;
                                this.parseHelpers(state, layoutVariables, (CLArray)element);
                                continue block30;
                            }
                            case "Generate": {
                                if (!(element instanceof CLObject)) continue block30;
                                this.parseGenerate(state, layoutVariables, (CLObject)element);
                                continue block30;
                            }
                        }
                        if (!(element instanceof CLObject)) break block45;
                        String type = this.lookForType((CLObject)element);
                        if (type == null) break block46;
                        switch (type) {
                            case "hGuideline": {
                                this.parseGuidelineParams(0, state, elementName, (CLObject)element);
                                break;
                            }
                            case "vGuideline": {
                                this.parseGuidelineParams(1, state, elementName, (CLObject)element);
                                break;
                            }
                            case "barrier": {
                                this.parseBarrier(state, elementName, (CLObject)element);
                                break;
                            }
                            case "hChain": 
                            case "vChain": {
                                this.parseChainType(type, state, elementName, layoutVariables, (CLObject)element);
                                break;
                            }
                            case "vFlow": 
                            case "hFlow": {
                                this.parseFlowType(type, state, elementName, layoutVariables, (CLObject)element);
                                break;
                            }
                            case "grid": 
                            case "column": 
                            case "row": {
                                this.parseGridType(type, state, elementName, layoutVariables, (CLObject)element);
                            }
                        }
                        continue;
                    }
                    this.parseWidget(state, layoutVariables, elementName, (CLObject)element);
                    continue;
                }
                if (!(element instanceof CLNumber)) continue;
                layoutVariables.put(elementName, ((CLNumber)element).getInt());
            }
        }

        private final void parseVariables(State state, LayoutVariables layoutVariables, CLObject json) throws CLParsingException {
            ArrayList<String> elements = json.names();
            Iterator<String> iterator = elements.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String elementName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                CLElement element = json.get(elementName);
                if (element instanceof CLNumber) {
                    layoutVariables.put(elementName, ((CLNumber)element).getInt());
                    continue;
                }
                if (!(element instanceof CLObject)) continue;
                CLElement obj = element;
                ArrayList<String> arrayIds = null;
                if (((CLObject)obj).has("from") && ((CLObject)obj).has("to")) {
                    float from = layoutVariables.get(((CLObject)obj).get("from"));
                    float to = layoutVariables.get(((CLObject)obj).get("to"));
                    String prefix = ((CLObject)obj).getStringOrNull("prefix");
                    String postfix = ((CLObject)obj).getStringOrNull("postfix");
                    layoutVariables.put(elementName, from, to, 1.0f, prefix, postfix);
                    continue;
                }
                if (((CLObject)obj).has("from") && ((CLObject)obj).has("step")) {
                    float start = layoutVariables.get(((CLObject)obj).get("from"));
                    float increment = layoutVariables.get(((CLObject)obj).get("step"));
                    layoutVariables.put(elementName, start, increment);
                    continue;
                }
                if (((CLObject)obj).has("ids")) {
                    CLArray ids = ((CLObject)obj).getArray("ids");
                    arrayIds = new ArrayList();
                    int n = ids.size();
                    for (int i = 0; i < n; ++i) {
                        arrayIds.add(ids.getString(i));
                    }
                    layoutVariables.put(elementName, arrayIds);
                    continue;
                }
                if (!((CLObject)obj).has("tag")) continue;
                ArrayList<String> arrayList = arrayIds = state.getIdsForTag(((CLObject)obj).getString("tag"));
                Intrinsics.checkNotNull(arrayList);
                layoutVariables.put(elementName, arrayList);
            }
        }

        public final void parseDesignElementsJSON(@Nullable String content, @NotNull ArrayList<DesignElement> list) throws CLParsingException {
            CLObject json;
            Iterable<CLKey> iterable;
            CLObject cLObject;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            String string = content;
            if (string != null) {
                String it = string;
                boolean bl = false;
                cLObject = CLParser.Companion.parse(it);
            } else {
                cLObject = null;
            }
            if ((iterable = (json = cLObject)) == null || (iterable = ((CLContainer)((Object)iterable)).names()) == null) {
                return;
            }
            int i = 0;
            Iterable<CLKey> elements = iterable;
            int n = ((Collection)elements).size();
            if (i < n) {
                Object e = ((ArrayList)elements).get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                String elementName = (String)e;
                CLElement element = json.get(elementName);
                if (Intrinsics.areEqual((Object)elementName, (Object)"Design")) {
                    if (!(element instanceof CLObject)) {
                        return;
                    }
                    elements = ((CLObject)element).names();
                    for (int j = 0; j < ((ArrayList)elements).size(); ++j) {
                        Object e2 = ((ArrayList)elements).get(j);
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                        String designElementName = (String)e2;
                        CLElement cLElement = ((CLObject)element).get(designElementName);
                        Intrinsics.checkNotNull((Object)cLElement, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.parser.CLObject");
                        CLObject designElement = (CLObject)cLElement;
                        System.out.println((Object)("element found " + designElementName));
                        String type = designElement.getStringOrNull("type");
                        if (type == null) continue;
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        int size = designElement.size();
                        for (int k = 0; k < size; ++k) {
                            CLElement cLElement2 = designElement.get(j);
                            Intrinsics.checkNotNull((Object)cLElement2, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.parser.CLKey");
                            CLKey key = (CLKey)cLElement2;
                            String paramName = key.content();
                            String paramValue = key.getValue().content();
                            ((Map)parameters).put(paramName, paramValue);
                        }
                        list.add(new DesignElement(elementName, type, parameters));
                    }
                }
            }
        }

        public final void parseHelpers(@NotNull State state, @NotNull LayoutVariables layoutVariables, @NotNull CLArray element) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            int n = element.size();
            block12: for (int i = 0; i < n; ++i) {
                CLElement array;
                CLElement helper = element.get(i);
                if (!(helper instanceof CLArray) || ((CLArray)(array = helper)).size() <= 1) continue;
                switch (((CLArray)array).getString(0)) {
                    case "hChain": {
                        this.parseChain(0, state, layoutVariables, (CLArray)array);
                        continue block12;
                    }
                    case "vChain": {
                        this.parseChain(1, state, layoutVariables, (CLArray)array);
                        continue block12;
                    }
                    case "hGuideline": {
                        this.parseGuideline(0, state, (CLArray)array);
                        continue block12;
                    }
                    case "vGuideline": {
                        this.parseGuideline(1, state, (CLArray)array);
                    }
                }
            }
        }

        public final void parseGenerate(@NotNull State state, @NotNull LayoutVariables layoutVariables, @NotNull CLObject json) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            ArrayList<String> elements = json.names();
            Iterator<String> iterator = elements.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Iterator<String> iterator3;
                String elementName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                CLElement element = json.get(elementName);
                ArrayList<String> arrayIds = layoutVariables.getList(elementName);
                if (arrayIds == null || !(element instanceof CLObject)) continue;
                Intrinsics.checkNotNullExpressionValue(arrayIds.iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    String id;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    this.parseWidget(state, layoutVariables, id, (CLObject)element);
                }
            }
        }

        public final void parseChain(int orientation, @NotNull State state, @NotNull LayoutVariables margins, @NotNull CLArray helper) throws CLParsingException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            ChainReference chain = orientation == 0 ? (ChainReference)state.horizontalChain() : (ChainReference)state.verticalChain();
            CLElement refs = helper.get(1);
            if (!(refs instanceof CLArray) || ((CLArray)refs).size() < 1) {
                return;
            }
            int n = ((CLArray)refs).size();
            for (int i = 0; i < n; ++i) {
                object = new Object[]{((CLArray)refs).getString(i)};
                chain.add((Object[])object);
            }
            if (helper.size() > 2) {
                object = helper.get(2);
                CLObject cLObject = object instanceof CLObject ? (CLObject)object : null;
                if (cLObject == null) {
                    return;
                }
                CLObject params = cLObject;
                ArrayList<String> constraints = params.names();
                Iterator<String> iterator = constraints.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                object = iterator;
                while (object.hasNext()) {
                    Object object2;
                    Object e = object.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    String constraintName = (String)e;
                    if (Intrinsics.areEqual((Object)constraintName, (Object)"style")) {
                        CLElement styleObject = params.get(constraintName);
                        String styleValue = null;
                        if (styleObject instanceof CLArray && ((CLArray)styleObject).size() > 1) {
                            styleValue = ((CLArray)styleObject).getString(0);
                            float biasValue = ((CLArray)styleObject).getFloat(1);
                            chain.bias(biasValue);
                        } else {
                            styleValue = styleObject.content();
                        }
                        String string = styleValue;
                        if (Intrinsics.areEqual((Object)string, (Object)"packed")) {
                            object2 = chain.style(State.Chain.PACKED);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)string, (Object)"spread_inside")) {
                            object2 = chain.style(State.Chain.SPREAD_INSIDE);
                            continue;
                        }
                        object2 = chain.style(State.Chain.SPREAD);
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)chain, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.ConstraintReference");
                    this.parseConstraint(state, margins, params, chain, constraintName);
                    object2 = Unit.INSTANCE;
                }
            }
        }

        private final float toPix(State state, float dp) {
            CorePixelDp corePixelDp = state.getDpToPixel();
            Intrinsics.checkNotNull((Object)corePixelDp);
            return corePixelDp.toPixels(dp);
        }

        private final void parseChainType(String orientation, State state, String chainName, LayoutVariables margins, CLObject object) throws CLParsingException {
            ChainReference chain = orientation.charAt(0) == 'h' ? (ChainReference)state.horizontalChain() : (ChainReference)state.verticalChain();
            chain.setKey(chainName);
            Iterator<String> iterator = object.names().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String params;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                switch (params) {
                    case "contains": {
                        CLElement refs = object.get(params);
                        if (!(refs instanceof CLArray) || ((CLArray)refs).size() < 1) {
                            String string = chainName + " contains should be an array \"" + refs.content() + "\"";
                            System.out.println((Object)string);
                            return;
                        }
                        for (int i = 0; i < ((CLArray)refs).size(); ++i) {
                            CLElement chainElement = ((CLArray)refs).get(i);
                            if (chainElement instanceof CLArray) {
                                CLElement array = chainElement;
                                if (((CLArray)array).size() <= 0) continue;
                                String id = ((CLArray)array).get(0).content();
                                float weight = Float.NaN;
                                float preMargin = 0.0f;
                                preMargin = Float.NaN;
                                float postMargin = 0.0f;
                                postMargin = Float.NaN;
                                float preGoneMargin = Float.NaN;
                                float postGoneMargin = Float.NaN;
                                switch (((CLArray)array).size()) {
                                    case 2: {
                                        weight = ((CLArray)array).getFloat(1);
                                        break;
                                    }
                                    case 3: {
                                        weight = ((CLArray)array).getFloat(1);
                                        Companion $this$parseChainType_u24lambda_u241 = this;
                                        boolean bl = false;
                                        postMargin = preMargin = $this$parseChainType_u24lambda_u241.toPix(state, ((CLArray)array).getFloat(2));
                                        break;
                                    }
                                    case 4: {
                                        weight = ((CLArray)array).getFloat(1);
                                        preMargin = this.toPix(state, ((CLArray)array).getFloat(2));
                                        postMargin = this.toPix(state, ((CLArray)array).getFloat(3));
                                        break;
                                    }
                                    case 6: {
                                        weight = ((CLArray)array).getFloat(1);
                                        preMargin = this.toPix(state, ((CLArray)array).getFloat(2));
                                        postMargin = this.toPix(state, ((CLArray)array).getFloat(3));
                                        preGoneMargin = this.toPix(state, ((CLArray)array).getFloat(4));
                                        postGoneMargin = this.toPix(state, ((CLArray)array).getFloat(5));
                                    }
                                }
                                chain.addChainElement(id, weight, preMargin, postMargin, preGoneMargin, postGoneMargin);
                                continue;
                            }
                            Object[] objectArray = new Object[]{chainElement.content()};
                            chain.add(objectArray);
                        }
                        break;
                    }
                    case "top": 
                    case "left": 
                    case "bottom": 
                    case "start": 
                    case "end": 
                    case "right": {
                        this.parseConstraint(state, margins, object, chain, params);
                        break;
                    }
                    case "style": {
                        CLElement styleObject = object.get(params);
                        String styleValue = null;
                        if (styleObject instanceof CLArray && ((CLArray)styleObject).size() > 1) {
                            styleValue = ((CLArray)styleObject).getString(0);
                            float biasValue = ((CLArray)styleObject).getFloat(1);
                            chain.bias(biasValue);
                        } else {
                            styleValue = styleObject.content();
                        }
                        String string = styleValue;
                        ChainReference chainReference = Intrinsics.areEqual((Object)string, (Object)"packed") ? chain.style(State.Chain.PACKED) : (Intrinsics.areEqual((Object)string, (Object)"spread_inside") ? chain.style(State.Chain.SPREAD_INSIDE) : chain.style(State.Chain.SPREAD));
                    }
                }
            }
        }

        private final void parseGridType(String gridType, State state, String name, LayoutVariables layoutVariables, CLObject element) throws CLParsingException {
            GridReference gridReference = state.getGrid(name, gridType);
            Intrinsics.checkNotNull((Object)gridReference);
            GridReference grid = gridReference;
            Iterator<String> iterator = element.names().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            block32: while (iterator2.hasNext()) {
                ConstraintReference reference;
                String param;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                switch (param) {
                    case "contains": {
                        CLArray list = element.getArrayOrNull(param);
                        if (list == null) continue block32;
                        for (int j = 0; j < list.size(); ++j) {
                            String elementNameReference = list.get(j).content();
                            ConstraintReference elementReference = state.constraints(elementNameReference);
                            Object[] objectArray = new Object[1];
                            Intrinsics.checkNotNull((Object)elementReference);
                            grid.add(objectArray);
                        }
                        continue block32;
                    }
                    case "orientation": {
                        int orientation = element.get(param).getInt();
                        grid.setOrientation(orientation);
                        continue block32;
                    }
                    case "rows": {
                        int rows = element.get(param).getInt();
                        if (rows <= 0) continue block32;
                        grid.setRowsSet(rows);
                        continue block32;
                    }
                    case "columns": {
                        int columns = element.get(param).getInt();
                        if (columns <= 0) continue block32;
                        grid.setColumnsSet(columns);
                        continue block32;
                    }
                    case "hGap": {
                        float hGap = element.get(param).getFloat();
                        grid.setHorizontalGaps(this.toPix(state, hGap));
                        continue block32;
                    }
                    case "vGap": {
                        float vGap = element.get(param).getFloat();
                        grid.setVerticalGaps(this.toPix(state, vGap));
                        continue block32;
                    }
                    case "spans": {
                        String spans = element.get(param).content();
                        if (spans == null || !StringsKt.contains$default((CharSequence)spans, (CharSequence)":", (boolean)false, (int)2, null)) continue block32;
                        grid.setSpans(spans);
                        continue block32;
                    }
                    case "skips": {
                        String skips = element.get(param).content();
                        if (skips == null || !StringsKt.contains$default((CharSequence)skips, (CharSequence)":", (boolean)false, (int)2, null)) continue block32;
                        grid.setSkips(skips);
                        continue block32;
                    }
                    case "rowWeights": {
                        String rowWeights = element.get(param).content();
                        if (rowWeights == null || !StringsKt.contains$default((CharSequence)rowWeights, (CharSequence)",", (boolean)false, (int)2, null)) continue block32;
                        grid.setRowWeights(rowWeights);
                        continue block32;
                    }
                    case "columnWeights": {
                        String columnWeights = element.get(param).content();
                        if (columnWeights == null || !StringsKt.contains$default((CharSequence)columnWeights, (CharSequence)",", (boolean)false, (int)2, null)) continue block32;
                        grid.setColumnWeights(columnWeights);
                        continue block32;
                    }
                    case "padding": {
                        CLElement paddingObject = element.get(param);
                        float paddingStart = 0.0f;
                        float paddingTop = 0.0f;
                        float paddingEnd = 0.0f;
                        float paddingBottom = 0.0f;
                        if (paddingObject instanceof CLArray && ((CLArray)paddingObject).size() > 1) {
                            paddingEnd = paddingStart = (float)((CLArray)paddingObject).getInt(0);
                            paddingBottom = paddingTop = (float)((CLArray)paddingObject).getInt(1);
                            if (((CLArray)paddingObject).size() > 2) {
                                float f;
                                paddingEnd = ((CLArray)paddingObject).getInt(2);
                                try {
                                    f = ((CLArray)paddingObject).getInt(3);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    f = 0.0f;
                                }
                                paddingBottom = f;
                            }
                        } else {
                            paddingTop = paddingStart = (float)paddingObject.getInt();
                            paddingEnd = paddingStart;
                            paddingBottom = paddingStart;
                        }
                        grid.setPaddingStart(IntegerKt.roundToIntOrZero(this.toPix(state, paddingStart)));
                        grid.setPaddingTop(IntegerKt.roundToIntOrZero(this.toPix(state, paddingTop)));
                        grid.setPaddingEnd(IntegerKt.roundToIntOrZero(this.toPix(state, paddingEnd)));
                        grid.setPaddingBottom(IntegerKt.roundToIntOrZero(this.toPix(state, paddingBottom)));
                        continue block32;
                    }
                    case "flags": {
                        int flagValue = 0;
                        String flags = "";
                        try {
                            CLElement obj = element.get(param);
                            if (obj instanceof CLNumber) {
                                flagValue = ((CLNumber)obj).getInt();
                            } else {
                                flags = obj.content();
                            }
                        }
                        catch (Exception ex) {
                            androidx.constraintlayout.core.platform.System.INSTANCE.getErr().println("Error parsing grid flags " + ex);
                        }
                        if (flags != null && !(((CharSequence)flags).length() == 0)) {
                            grid.setFlags(flags);
                            continue block32;
                        }
                        grid.setFlags(flagValue);
                        continue block32;
                    }
                }
                ConstraintReference constraintReference = reference = state.constraints(name);
                Intrinsics.checkNotNull((Object)constraintReference);
                this.applyAttribute(state, layoutVariables, constraintReference, element, param);
            }
        }

        private final void parseFlowType(String flowType, State state, String flowName, LayoutVariables layoutVariables, CLObject element) throws CLParsingException {
            boolean isVertical = flowType.charAt(0) == 'v';
            FlowReference flow = state.getFlow(flowName, isVertical);
            Iterator<String> iterator = element.names().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            block51: while (iterator2.hasNext()) {
                ConstraintReference reference;
                String param;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                switch (param) {
                    case "contains": {
                        CLElement refs = element.get(param);
                        if (!(refs instanceof CLArray) || ((CLArray)refs).size() < 1) {
                            String string = flowName + " contains should be an array \"" + refs.content() + "\"";
                            System.out.println((Object)string);
                            return;
                        }
                        for (int i = 0; i < ((CLArray)refs).size(); ++i) {
                            Object[] array;
                            Object[] chainElement = ((CLArray)refs).get(i);
                            if (chainElement instanceof CLArray) {
                                array = chainElement;
                                if (((CLArray)array).size() <= 0) continue;
                                String id = ((CLArray)array).get(0).content();
                                float weight = Float.NaN;
                                float preMargin = 0.0f;
                                preMargin = Float.NaN;
                                float postMargin = 0.0f;
                                postMargin = Float.NaN;
                                switch (((CLArray)array).size()) {
                                    case 2: {
                                        weight = ((CLArray)array).getFloat(1);
                                        break;
                                    }
                                    case 3: {
                                        weight = ((CLArray)array).getFloat(1);
                                        Companion $this$parseFlowType_u24lambda_u242 = this;
                                        boolean bl = false;
                                        postMargin = preMargin = $this$parseFlowType_u24lambda_u242.toPix(state, ((CLArray)array).getFloat(2));
                                        break;
                                    }
                                    case 4: {
                                        weight = ((CLArray)array).getFloat(1);
                                        preMargin = this.toPix(state, ((CLArray)array).getFloat(2));
                                        postMargin = this.toPix(state, ((CLArray)array).getFloat(3));
                                    }
                                }
                                FlowReference flowReference = flow;
                                Intrinsics.checkNotNull((Object)flowReference);
                                flowReference.addFlowElement(id, weight, preMargin, postMargin);
                                continue;
                            }
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            array = new Object[]{chainElement.content()};
                            flowReference.add(array);
                        }
                        continue block51;
                    }
                    case "type": {
                        if (Intrinsics.areEqual((Object)element.get(param).content(), (Object)"hFlow")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setOrientation(0);
                            continue block51;
                        }
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setOrientation(1);
                        continue block51;
                    }
                    case "wrap": {
                        String wrapValue = element.get(param).content();
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setWrapMode(State.Wrap.Companion.getValueByString(wrapValue));
                        continue block51;
                    }
                    case "vGap": {
                        int vGapValue = element.get(param).getInt();
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setVerticalGap(vGapValue);
                        continue block51;
                    }
                    case "hGap": {
                        int hGapValue = element.get(param).getInt();
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setHorizontalGap(hGapValue);
                        continue block51;
                    }
                    case "maxElement": {
                        int maxElementValue = element.get(param).getInt();
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setMaxElementsWrap(maxElementValue);
                        continue block51;
                    }
                    case "padding": {
                        CLElement paddingObject = element.get(param);
                        float paddingLeft = 0.0f;
                        float paddingTop = 0.0f;
                        float paddingRight = 0.0f;
                        float paddingBottom = 0.0f;
                        if (paddingObject instanceof CLArray && ((CLArray)paddingObject).size() > 1) {
                            paddingRight = paddingLeft = (float)((CLArray)paddingObject).getInt(0);
                            paddingBottom = paddingTop = (float)((CLArray)paddingObject).getInt(1);
                            if (((CLArray)paddingObject).size() > 2) {
                                paddingRight = ((CLArray)paddingObject).getInt(2);
                                try {
                                    paddingBottom = ((CLArray)paddingObject).getInt(3);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    paddingBottom = 0.0f;
                                }
                            }
                        } else {
                            paddingTop = paddingLeft = (float)paddingObject.getInt();
                            paddingRight = paddingLeft;
                            paddingBottom = paddingLeft;
                        }
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setPaddingLeft(IntegerKt.roundToIntOrZero(this.toPix(state, paddingLeft)));
                        flow.setPaddingTop(IntegerKt.roundToIntOrZero(this.toPix(state, paddingTop)));
                        flow.setPaddingRight(IntegerKt.roundToIntOrZero(this.toPix(state, paddingRight)));
                        flow.setPaddingBottom(IntegerKt.roundToIntOrZero(this.toPix(state, paddingBottom)));
                        continue block51;
                    }
                    case "vAlign": {
                        String vAlignValue;
                        switch (vAlignValue = element.get(param).content()) {
                            case "top": {
                                FlowReference flowReference = flow;
                                Intrinsics.checkNotNull((Object)flowReference);
                                flowReference.setVerticalAlign(0);
                                continue block51;
                            }
                            case "bottom": {
                                FlowReference flowReference = flow;
                                Intrinsics.checkNotNull((Object)flowReference);
                                flowReference.setVerticalAlign(1);
                                continue block51;
                            }
                            case "baseline": {
                                FlowReference flowReference = flow;
                                Intrinsics.checkNotNull((Object)flowReference);
                                flowReference.setVerticalAlign(3);
                                continue block51;
                            }
                        }
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setVerticalAlign(2);
                        continue block51;
                    }
                    case "hAlign": {
                        String hAlignValue;
                        String paddingLeft = hAlignValue = element.get(param).content();
                        if (Intrinsics.areEqual((Object)paddingLeft, (Object)"start")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setHorizontalAlign(0);
                            continue block51;
                        }
                        if (Intrinsics.areEqual((Object)paddingLeft, (Object)"end")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setHorizontalAlign(1);
                            continue block51;
                        }
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setHorizontalAlign(2);
                        continue block51;
                    }
                    case "vFlowBias": {
                        CLElement vBiasObject = element.get(param);
                        float vBiasValue = 0.5f;
                        float vFirstBiasValue = 0.5f;
                        float vLastBiasValue = 0.5f;
                        if (vBiasObject instanceof CLArray && ((CLArray)vBiasObject).size() > 1) {
                            vFirstBiasValue = ((CLArray)vBiasObject).getFloat(0);
                            vBiasValue = ((CLArray)vBiasObject).getFloat(1);
                            if (((CLArray)vBiasObject).size() > 2) {
                                vLastBiasValue = ((CLArray)vBiasObject).getFloat(2);
                            }
                        } else {
                            vBiasValue = vBiasObject.getFloat();
                        }
                        try {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.verticalBias(vBiasValue);
                            if (!(vFirstBiasValue == 0.5f)) {
                                flow.setFirstVerticalBias(vFirstBiasValue);
                            }
                            if (vLastBiasValue == 0.5f) continue block51;
                            flow.setLastVerticalBias(vLastBiasValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block51;
                    }
                    case "hFlowBias": {
                        CLElement hBiasObject = element.get(param);
                        float hBiasValue = 0.5f;
                        float hFirstBiasValue = 0.5f;
                        float hLastBiasValue = 0.5f;
                        if (hBiasObject instanceof CLArray && ((CLArray)hBiasObject).size() > 1) {
                            hFirstBiasValue = ((CLArray)hBiasObject).getFloat(0);
                            hBiasValue = ((CLArray)hBiasObject).getFloat(1);
                            if (((CLArray)hBiasObject).size() > 2) {
                                hLastBiasValue = ((CLArray)hBiasObject).getFloat(2);
                            }
                        } else {
                            hBiasValue = hBiasObject.getFloat();
                        }
                        try {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.horizontalBias(hBiasValue);
                            if (!(hFirstBiasValue == 0.5f)) {
                                flow.setFirstHorizontalBias(hFirstBiasValue);
                            }
                            if (hLastBiasValue == 0.5f) continue block51;
                            flow.setLastHorizontalBias(hLastBiasValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block51;
                    }
                    case "vStyle": {
                        CLElement vStyleObject = element.get(param);
                        String vStyleValueStr = "";
                        String vFirstStyleValueStr = "";
                        String vLastStyleValueStr = "";
                        if (vStyleObject instanceof CLArray && ((CLArray)vStyleObject).size() > 1) {
                            vFirstStyleValueStr = ((CLArray)vStyleObject).getString(0);
                            vStyleValueStr = ((CLArray)vStyleObject).getString(1);
                            if (((CLArray)vStyleObject).size() > 2) {
                                vLastStyleValueStr = ((CLArray)vStyleObject).getString(2);
                            }
                        } else {
                            vStyleValueStr = vStyleObject.content();
                        }
                        if (!Intrinsics.areEqual((Object)vStyleValueStr, (Object)"")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setVerticalStyle(State.Chain.Companion.getValueByString(vStyleValueStr));
                        }
                        if (!Intrinsics.areEqual((Object)vFirstStyleValueStr, (Object)"")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setFirstVerticalStyle(State.Chain.Companion.getValueByString(vFirstStyleValueStr));
                        }
                        if (Intrinsics.areEqual((Object)vLastStyleValueStr, (Object)"")) continue block51;
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setLastVerticalStyle(State.Chain.Companion.getValueByString(vLastStyleValueStr));
                        continue block51;
                    }
                    case "hStyle": {
                        CLElement hStyleObject = element.get(param);
                        String hStyleValueStr = "";
                        String hFirstStyleValueStr = "";
                        String hLastStyleValueStr = "";
                        if (hStyleObject instanceof CLArray && ((CLArray)hStyleObject).size() > 1) {
                            hFirstStyleValueStr = ((CLArray)hStyleObject).getString(0);
                            hStyleValueStr = ((CLArray)hStyleObject).getString(1);
                            if (((CLArray)hStyleObject).size() > 2) {
                                hLastStyleValueStr = ((CLArray)hStyleObject).getString(2);
                            }
                        } else {
                            hStyleValueStr = hStyleObject.content();
                        }
                        if (!Intrinsics.areEqual((Object)hStyleValueStr, (Object)"")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setHorizontalStyle(State.Chain.Companion.getValueByString(hStyleValueStr));
                        }
                        if (!Intrinsics.areEqual((Object)hFirstStyleValueStr, (Object)"")) {
                            FlowReference flowReference = flow;
                            Intrinsics.checkNotNull((Object)flowReference);
                            flowReference.setFirstHorizontalStyle(State.Chain.Companion.getValueByString(hFirstStyleValueStr));
                        }
                        if (Intrinsics.areEqual((Object)hLastStyleValueStr, (Object)"")) continue block51;
                        FlowReference flowReference = flow;
                        Intrinsics.checkNotNull((Object)flowReference);
                        flowReference.setLastHorizontalStyle(State.Chain.Companion.getValueByString(hLastStyleValueStr));
                        continue block51;
                    }
                }
                ConstraintReference constraintReference = reference = state.constraints(flowName);
                Intrinsics.checkNotNull((Object)constraintReference);
                this.applyAttribute(state, layoutVariables, constraintReference, element, param);
            }
        }

        public final void parseGuideline(int orientation, @NotNull State state, @NotNull CLArray helper) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            CLElement cLElement = helper.get(1);
            CLObject cLObject = cLElement instanceof CLObject ? (CLObject)cLElement : null;
            if (cLObject == null) {
                return;
            }
            CLObject params = cLObject;
            String string = params.getStringOrNull("id");
            if (string == null) {
                return;
            }
            String guidelineId = string;
            this.parseGuidelineParams(orientation, state, guidelineId, params);
        }

        public final void parseGuidelineParams(int orientation, @NotNull State state, @Nullable String guidelineId, @NotNull CLObject params) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            ArrayList<String> constraints = params.names();
            ConstraintReference reference = state.constraints(guidelineId);
            GuidelineReference guidelineReference = orientation == 0 ? state.horizontalGuideline(guidelineId) : state.verticalGuideline(guidelineId);
            boolean isLtr = !state.isRtl() || orientation == 0;
            ConstraintReference constraintReference = reference;
            Intrinsics.checkNotNull((Object)constraintReference);
            Facade facade = constraintReference.getFacade();
            Intrinsics.checkNotNull((Object)facade);
            GuidelineReference guidelineReference2 = (GuidelineReference)facade;
            boolean isPercent = false;
            float value = 0.0f;
            boolean fromStart = true;
            Iterator<String> iterator = constraints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                block38: {
                    String constraintName;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    switch (constraintName) {
                        case "left": {
                            value = this.toPix(state, params.getFloat(constraintName));
                            fromStart = true;
                            break;
                        }
                        case "right": {
                            value = this.toPix(state, params.getFloat(constraintName));
                            fromStart = false;
                            break;
                        }
                        case "start": {
                            value = this.toPix(state, params.getFloat(constraintName));
                            fromStart = isLtr;
                            break;
                        }
                        case "end": {
                            value = this.toPix(state, params.getFloat(constraintName));
                            fromStart = !isLtr;
                            break;
                        }
                        case "percent": {
                            isPercent = true;
                            CLArray percentParams = params.getArrayOrNull(constraintName);
                            if (percentParams == null) {
                                fromStart = true;
                                value = params.getFloat(constraintName);
                                break;
                            }
                            if (percentParams.size() <= 1) break;
                            String origin = percentParams.getString(0);
                            value = percentParams.getFloat(1);
                            switch (origin) {
                                case "left": {
                                    fromStart = true;
                                    break block38;
                                }
                                case "right": {
                                    fromStart = false;
                                    break block38;
                                }
                                case "start": {
                                    fromStart = isLtr;
                                    break block38;
                                }
                                case "end": {
                                    fromStart = !isLtr;
                                }
                            }
                        }
                    }
                }
            }
            GuidelineReference guidelineReference3 = isPercent ? (fromStart ? guidelineReference2.percent(value) : guidelineReference2.percent(1.0f - value)) : (fromStart ? guidelineReference2.start(Float.valueOf(value)) : guidelineReference2.end(Float.valueOf(value)));
        }

        public final void parseBarrier(@NotNull State state, @Nullable String elementName, @NotNull CLObject element) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            boolean isLtr = !state.isRtl();
            BarrierReference reference = state.barrier(elementName, State.Direction.END);
            ArrayList<String> constraints = element.names();
            Iterator<String> iterator = constraints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            block21: while (iterator2.hasNext()) {
                String constraintName;
                block32: {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    String string = constraintName;
                    switch (string.hashCode()) {
                        case -1081309778: {
                            if (string.equals("margin")) break;
                            continue block21;
                        }
                        case -567445985: {
                            if (!string.equals("contains")) {
                                continue block21;
                            }
                            break block32;
                        }
                        case -962590849: {
                            if (!string.equals("direction")) continue block21;
                            switch (element.getString(constraintName)) {
                                case "start": {
                                    if (isLtr) {
                                        BarrierReference barrierReference = reference;
                                        Intrinsics.checkNotNull((Object)barrierReference);
                                        barrierReference.setBarrierDirection(State.Direction.LEFT);
                                        break;
                                    }
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.RIGHT);
                                    break;
                                }
                                case "end": {
                                    if (isLtr) {
                                        BarrierReference barrierReference = reference;
                                        Intrinsics.checkNotNull((Object)barrierReference);
                                        barrierReference.setBarrierDirection(State.Direction.RIGHT);
                                        break;
                                    }
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.LEFT);
                                    break;
                                }
                                case "left": {
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.LEFT);
                                    break;
                                }
                                case "right": {
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.RIGHT);
                                    break;
                                }
                                case "top": {
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.TOP);
                                    break;
                                }
                                case "bottom": {
                                    BarrierReference barrierReference = reference;
                                    Intrinsics.checkNotNull((Object)barrierReference);
                                    barrierReference.setBarrierDirection(State.Direction.BOTTOM);
                                }
                            }
                            continue block21;
                        }
                    }
                    float margin = element.getFloatOrNaN(constraintName);
                    if (Float.isNaN(margin)) continue;
                    BarrierReference barrierReference = reference;
                    Intrinsics.checkNotNull((Object)barrierReference);
                    barrierReference.margin(Float.valueOf(this.toPix(state, margin)));
                    continue;
                }
                CLArray list = element.getArrayOrNull(constraintName);
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    String elementNameReference = list.get(j).content();
                    ConstraintReference elementReference = state.constraints(elementNameReference);
                    BarrierReference barrierReference = reference;
                    Intrinsics.checkNotNull((Object)barrierReference);
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)elementReference);
                    barrierReference.add(objectArray);
                }
                {
                }
            }
        }

        public final void parseWidget(@NotNull State state, @Nullable LayoutVariables layoutVariables, @Nullable String elementName, @NotNull CLObject element) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ConstraintReference constraintReference = state.constraints(elementName);
            Intrinsics.checkNotNull((Object)constraintReference);
            ConstraintReference reference = constraintReference;
            this.parseWidget(state, layoutVariables, reference, element);
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void applyAttribute(@NotNull State state, @NotNull LayoutVariables layoutVariables, @NotNull ConstraintReference reference, @NotNull CLObject element, @Nullable String attributeName) throws CLParsingException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            float value = 0.0f;
            String string = attributeName;
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 1941332754: {
                        if (!string.equals("visibility")) break;
                        n = 1;
                        break;
                    }
                    case -1068318794: {
                        if (!string.equals("motion")) break;
                        n = 2;
                        break;
                    }
                    case -1364013995: {
                        if (!string.equals("center")) break;
                        n = 3;
                        break;
                    }
                    case -247669061: {
                        if (!string.equals("hRtlBias")) break;
                        n = 4;
                        break;
                    }
                    case -1349088399: {
                        if (!string.equals("custom")) break;
                        n = 5;
                        break;
                    }
                    case -987906985: {
                        if (!string.equals("pivotY")) break;
                        n = 6;
                        break;
                    }
                    case -987906986: {
                        if (!string.equals("pivotX")) break;
                        n = 7;
                        break;
                    }
                    case -908189618: {
                        if (!string.equals("scaleX")) break;
                        n = 8;
                        break;
                    }
                    case -908189617: {
                        if (!string.equals("scaleY")) break;
                        n = 9;
                        break;
                    }
                    case 111045711: {
                        if (!string.equals("vBias")) break;
                        n = 10;
                        break;
                    }
                    case -1249320806: {
                        if (!string.equals("rotationX")) break;
                        n = 11;
                        break;
                    }
                    case -1225497657: {
                        if (!string.equals("translationX")) break;
                        n = 12;
                        break;
                    }
                    case -1249320805: {
                        if (!string.equals("rotationY")) break;
                        n = 13;
                        break;
                    }
                    case -1249320804: {
                        if (!string.equals("rotationZ")) break;
                        n = 14;
                        break;
                    }
                    case 1404070310: {
                        if (!string.equals("centerHorizontally")) break;
                        n = 15;
                        break;
                    }
                    case 92909918: {
                        if (!string.equals("alpha")) break;
                        n = 16;
                        break;
                    }
                    case 113126854: {
                        if (!string.equals("width")) break;
                        n = 17;
                        break;
                    }
                    case 98116417: {
                        if (!string.equals("hBias")) break;
                        n = 18;
                        break;
                    }
                    case -61505906: {
                        if (!string.equals("vWeight")) break;
                        n = 19;
                        break;
                    }
                    case -1225497656: {
                        if (!string.equals("translationY")) break;
                        n = 20;
                        break;
                    }
                    case -1448775240: {
                        if (!string.equals("centerVertically")) break;
                        n = 21;
                        break;
                    }
                    case -1225497655: {
                        if (!string.equals("translationZ")) break;
                        n = 22;
                        break;
                    }
                    case 398344448: {
                        if (!string.equals("hWeight")) break;
                        n = 23;
                        break;
                    }
                    case -1221029593: {
                        if (!string.equals("height")) break;
                        n = 24;
                        break;
                    }
                }
                switch (n) {
                    case 17: {
                        CorePixelDp corePixelDp = state.getDpToPixel();
                        Intrinsics.checkNotNull((Object)corePixelDp);
                        object = reference.setWidth(this.parseDimension(element, attributeName, state, corePixelDp));
                        return;
                    }
                    case 24: {
                        CorePixelDp corePixelDp = state.getDpToPixel();
                        Intrinsics.checkNotNull((Object)corePixelDp);
                        object = reference.setHeight(this.parseDimension(element, attributeName, state, corePixelDp));
                        return;
                    }
                    case 3: {
                        String target = element.getString(attributeName);
                        ConstraintReference targetReference = null;
                        ConstraintReference constraintReference = targetReference = Intrinsics.areEqual((Object)target, (Object)"parent") ? state.constraints(0) : state.constraints(target);
                        Intrinsics.checkNotNull((Object)constraintReference);
                        reference.startToStart(constraintReference);
                        reference.endToEnd(targetReference);
                        reference.topToTop(targetReference);
                        object = reference.bottomToBottom(targetReference);
                        return;
                    }
                    case 15: {
                        ConstraintReference constraintReference;
                        String target = element.getString(attributeName);
                        if (Intrinsics.areEqual((Object)target, (Object)"parent")) {
                            ConstraintReference constraintReference = state.constraints(0);
                            constraintReference = constraintReference;
                            Intrinsics.checkNotNull((Object)constraintReference2);
                        } else {
                            ConstraintReference constraintReference = state.constraints(target);
                            constraintReference = constraintReference;
                            Intrinsics.checkNotNull((Object)constraintReference3);
                        }
                        ConstraintReference targetReference = constraintReference;
                        reference.startToStart(targetReference);
                        object = reference.endToEnd(targetReference);
                        return;
                    }
                    case 21: {
                        ConstraintReference constraintReference;
                        String target = element.getString(attributeName);
                        if (Intrinsics.areEqual((Object)target, (Object)"parent")) {
                            ConstraintReference constraintReference = state.constraints(0);
                            constraintReference = constraintReference;
                            Intrinsics.checkNotNull((Object)constraintReference4);
                        } else {
                            ConstraintReference constraintReference = state.constraints(target);
                            constraintReference = constraintReference;
                            Intrinsics.checkNotNull((Object)constraintReference5);
                        }
                        ConstraintReference targetReference = constraintReference;
                        reference.topToTop(targetReference);
                        object = reference.bottomToBottom(targetReference);
                        return;
                    }
                    case 16: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.alpha(value);
                        return;
                    }
                    case 8: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.scaleX(value);
                        return;
                    }
                    case 9: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.scaleY(value);
                        return;
                    }
                    case 12: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.translationX(this.toPix(state, value));
                        return;
                    }
                    case 20: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.translationY(this.toPix(state, value));
                        return;
                    }
                    case 22: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.translationZ(this.toPix(state, value));
                        return;
                    }
                    case 7: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.pivotX(value);
                        return;
                    }
                    case 6: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.pivotY(value);
                        return;
                    }
                    case 11: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.rotationX(value);
                        return;
                    }
                    case 13: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.rotationY(value);
                        return;
                    }
                    case 14: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.rotationZ(value);
                        return;
                    }
                    case 1: {
                        switch (element.getString(attributeName)) {
                            case "visible": {
                                reference.visibility(0);
                                break;
                            }
                            case "invisible": {
                                reference.visibility(4);
                                reference.alpha(0.0f);
                                break;
                            }
                            case "gone": {
                                reference.visibility(8);
                                break;
                            }
                        }
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 10: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.verticalBias(value);
                        return;
                    }
                    case 4: {
                        value = layoutVariables.get(element.get(attributeName));
                        if (state.isRtl()) {
                            value = 1.0f - value;
                        }
                        object = reference.horizontalBias(value);
                        return;
                    }
                    case 18: {
                        value = layoutVariables.get(element.get(attributeName));
                        object = reference.horizontalBias(value);
                        return;
                    }
                    case 19: {
                        value = layoutVariables.get(element.get(attributeName));
                        reference.setVerticalChainWeight(value);
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 23: {
                        value = layoutVariables.get(element.get(attributeName));
                        reference.setHorizontalChainWeight(value);
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 5: {
                        this.parseCustomProperties(element, reference, attributeName);
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 2: {
                        this.parseMotionProperties(element.get(attributeName), reference);
                        object = Unit.INSTANCE;
                        return;
                    }
                }
            }
            this.parseConstraint(state, layoutVariables, element, reference, attributeName);
            object = Unit.INSTANCE;
        }

        public final void parseWidget(@Nullable State state, @Nullable LayoutVariables layoutVariables, @NotNull ConstraintReference reference, @NotNull CLObject element) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (reference.getWidth() == null) {
                reference.setWidth(Dimension.Companion.createWrap());
            }
            if (reference.getHeight() == null) {
                reference.setHeight(Dimension.Companion.createWrap());
            }
            ArrayList<String> constraints = element.names();
            Iterator<String> iterator = constraints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String constraintName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                State state2 = state;
                Intrinsics.checkNotNull((Object)state2);
                LayoutVariables layoutVariables2 = layoutVariables;
                Intrinsics.checkNotNull((Object)layoutVariables2);
                this.applyAttribute(state2, layoutVariables2, reference, element, constraintName);
            }
        }

        public final void parseCustomProperties(@NotNull CLObject element, @NotNull ConstraintReference reference, @Nullable String constraintName) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            CLObject cLObject = element.getObjectOrNull(constraintName);
            if (cLObject == null) {
                return;
            }
            CLObject json = cLObject;
            ArrayList<String> properties = json.names();
            Iterator<String> iterator = properties.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                long it;
                String property;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                CLElement value = json.get(property);
                if (value instanceof CLNumber) {
                    reference.addCustomFloat(property, ((CLNumber)value).getFloat());
                    continue;
                }
                if (!(value instanceof CLString) || (it = this.parseColorString(value.content())) == -1L) continue;
                reference.addCustomColor(property, (int)it);
            }
        }

        private final int indexOf(String val, String ... types) {
            int n = types.length;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)types[i], (Object)val)) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void parseMotionProperties(CLElement element, ConstraintReference reference) throws CLParsingException {
            if (!(element instanceof CLObject)) {
                return;
            }
            CLElement obj = element;
            TypedBundle bundle = new TypedBundle();
            ArrayList<String> constraints = ((CLObject)obj).names();
            Iterator<String> iterator = constraints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            block7: while (iterator2.hasNext()) {
                block12: {
                    String constraintName;
                    block13: {
                        block14: {
                            block15: {
                                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                                String string = constraintName;
                                switch (string.hashCode()) {
                                    case -236944793: {
                                        if (string.equals("relativeTo")) break;
                                        break block12;
                                    }
                                    case -1285003983: {
                                        if (string.equals("quantize")) break block13;
                                        break block12;
                                    }
                                    case -1897525331: {
                                        if (string.equals("stagger")) break block14;
                                        break block12;
                                    }
                                    case -1310311125: {
                                        if (string.equals("easing")) break block15;
                                        break block12;
                                    }
                                    case -791482387: {
                                        if (string.equals("pathArc")) {
                                            String val = ((CLObject)obj).getString(constraintName);
                                            String[] stringArray = new String[]{"none", "startVertical", "startHorizontal", "flip", "below", "above"};
                                            int ord = this.indexOf(val, stringArray);
                                            if (ord == -1) {
                                                String string2 = obj.getLine() + " pathArc = '" + val + "'";
                                                System.out.println((Object)string2);
                                                break block7;
                                            }
                                            bundle.add(607, ord);
                                        }
                                        break block12;
                                    }
                                }
                                bundle.add(605, ((CLObject)obj).getString(constraintName));
                                continue;
                            }
                            bundle.add(603, ((CLObject)obj).getString(constraintName));
                            continue;
                        }
                        bundle.add(600, ((CLObject)obj).getFloat(constraintName));
                        continue;
                    }
                    CLElement quant = ((CLObject)obj).get(constraintName);
                    if (quant instanceof CLArray) {
                        CLElement array = quant;
                        int n = ((CLArray)array).size();
                        if (n <= 0) continue;
                        bundle.add(610, ((CLArray)array).getInt(0));
                        if (n <= 1) continue;
                        bundle.add(611, ((CLArray)array).getString(1));
                        if (n <= 2) continue;
                        bundle.add(602, ((CLArray)array).getFloat(2));
                        continue;
                    }
                    bundle.add(610, ((CLObject)obj).getInt(constraintName));
                }
            }
            reference.setMMotionProperties(bundle);
        }

        /*
         * Unable to fully structure code
         */
        public final void parseConstraint(@NotNull State state, @NotNull LayoutVariables layoutVariables, @NotNull CLObject element, @NotNull ConstraintReference reference, @Nullable String constraintName) throws CLParsingException {
            block112: {
                block106: {
                    block109: {
                        block110: {
                            block107: {
                                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                                Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                                isLtr = state.isRtl() == false;
                                constraint = element.getArrayOrNull(constraintName);
                                if (constraint == null || constraint.size() <= 1) break block106;
                                target = constraint.getString(0);
                                anchor = constraint.getStringOrNull(1);
                                margin = 0.0f;
                                marginGone = 0.0f;
                                if (constraint.size() > 2) {
                                    v0 = arg2 = constraint.getOrNull(2);
                                    Intrinsics.checkNotNull((Object)v0);
                                    margin = layoutVariables.get(v0);
                                    margin = this.toPix(state, margin);
                                }
                                if (constraint.size() > 3) {
                                    v1 = arg2 = constraint.getOrNull(3);
                                    Intrinsics.checkNotNull((Object)v1);
                                    marginGone = layoutVariables.get(v1);
                                    marginGone = this.toPix(state, marginGone);
                                }
                                targetReference = Intrinsics.areEqual((Object)target, (Object)"parent") != false ? state.constraints(0) : state.constraints(target);
                                isHorizontalConstraint = false;
                                isHorOriginLeft = true;
                                isHorTargetLeft = true;
                                var16_19 = constraintName;
                                if (var16_19 == null) break block107;
                                tmp = -1;
                                switch (var16_19.hashCode()) {
                                    case 115029: {
                                        if (var16_19.equals("top")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 3317767: {
                                        if (var16_19.equals("left")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case -1383228885: {
                                        if (var16_19.equals("bottom")) {
                                            tmp = 3;
                                        }
                                        break;
                                    }
                                    case 109757538: {
                                        if (var16_19.equals("start")) {
                                            tmp = 4;
                                        }
                                        break;
                                    }
                                    case -1498085729: {
                                        if (var16_19.equals("circular")) {
                                            tmp = 5;
                                        }
                                        break;
                                    }
                                    case 100571: {
                                        if (var16_19.equals("end")) {
                                            tmp = 6;
                                        }
                                        break;
                                    }
                                    case -1720785339: {
                                        if (var16_19.equals("baseline")) {
                                            tmp = 7;
                                        }
                                        break;
                                    }
                                    case 108511772: {
                                        if (var16_19.equals("right")) {
                                            tmp = 8;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 5: {
                                        angle = layoutVariables.get(constraint.get(1));
                                        distance = 0.0f;
                                        if (constraint.size() > 2) {
                                            v2 = distanceArg = constraint.getOrNull(2);
                                            Intrinsics.checkNotNull((Object)v2);
                                            distance = layoutVariables.get(v2);
                                            distance = this.toPix(state, distance);
                                        }
                                        reference.circularConstraint(targetReference, angle, distance);
                                        break;
                                    }
                                    case 1: {
                                        var17_21 = anchor;
                                        if (var17_21 == null) break;
                                        tmp = -1;
                                        switch (var17_21.hashCode()) {
                                            case 115029: {
                                                if (var17_21.equals("top")) {
                                                    tmp = 1;
                                                }
                                                break;
                                            }
                                            case -1383228885: {
                                                if (var17_21.equals("bottom")) {
                                                    tmp = 2;
                                                }
                                                break;
                                            }
                                            case -1720785339: {
                                                if (var17_21.equals("baseline")) {
                                                    tmp = 3;
                                                }
                                                break;
                                            }
                                        }
                                        switch (tmp) {
                                            case 1: {
                                                v3 = targetReference;
                                                Intrinsics.checkNotNull((Object)v3);
                                                reference.topToTop(v3);
                                                break;
                                            }
                                            case 2: {
                                                v4 = targetReference;
                                                Intrinsics.checkNotNull((Object)v4);
                                                reference.topToBottom(v4);
                                                break;
                                            }
                                            case 3: {
                                                v5 = targetReference;
                                                Intrinsics.checkNotNull((Object)v5);
                                                v6 = v5.getKey();
                                                Intrinsics.checkNotNull((Object)v6);
                                                state.baselineNeededFor(v6);
                                                reference.topToBaseline(targetReference);
                                            }
                                        }
                                        break;
                                    }
                                    case 3: {
                                        var17_22 = anchor;
                                        if (var17_22 == null) break;
                                        tmp = -1;
                                        switch (var17_22.hashCode()) {
                                            case 115029: {
                                                if (var17_22.equals("top")) {
                                                    tmp = 1;
                                                }
                                                break;
                                            }
                                            case -1383228885: {
                                                if (var17_22.equals("bottom")) {
                                                    tmp = 2;
                                                }
                                                break;
                                            }
                                            case -1720785339: {
                                                if (var17_22.equals("baseline")) {
                                                    tmp = 3;
                                                }
                                                break;
                                            }
                                        }
                                        switch (tmp) {
                                            case 1: {
                                                v7 = targetReference;
                                                Intrinsics.checkNotNull((Object)v7);
                                                reference.bottomToTop(v7);
                                                break;
                                            }
                                            case 2: {
                                                v8 = targetReference;
                                                Intrinsics.checkNotNull((Object)v8);
                                                reference.bottomToBottom(v8);
                                                break;
                                            }
                                            case 3: {
                                                v9 = targetReference;
                                                Intrinsics.checkNotNull((Object)v9);
                                                v10 = v9.getKey();
                                                Intrinsics.checkNotNull((Object)v10);
                                                state.baselineNeededFor(v10);
                                                reference.bottomToBaseline(targetReference);
                                            }
                                        }
                                        break;
                                    }
                                    case 7: {
                                        var17_23 = anchor;
                                        if (var17_23 == null) break;
                                        switch (var17_23.hashCode()) {
                                            case 115029: {
                                                if (var17_23.equals("top")) break;
                                                ** break;
                                            }
                                            case -1383228885: {
                                                if (!var17_23.equals("bottom")) {
                                                    ** break;
                                                }
                                                ** GOTO lbl204
                                            }
                                            case -1720785339: {
                                                if (!var17_23.equals("baseline")) ** break;
                                                v11 = reference.getKey();
                                                Intrinsics.checkNotNull((Object)v11);
                                                state.baselineNeededFor(v11);
                                                v12 = targetReference;
                                                Intrinsics.checkNotNull((Object)v12);
                                                v13 = v12.getKey();
                                                Intrinsics.checkNotNull((Object)v13);
                                                state.baselineNeededFor(v13);
                                                reference.baselineToBaseline(targetReference);
                                                ** break;
                                            }
                                        }
                                        v14 = reference.getKey();
                                        Intrinsics.checkNotNull((Object)v14);
                                        state.baselineNeededFor(v14);
                                        v15 = targetReference;
                                        Intrinsics.checkNotNull((Object)v15);
                                        reference.baselineToTop(v15);
                                        break;
lbl204:
                                        // 1 sources

                                        v16 = reference.getKey();
                                        Intrinsics.checkNotNull((Object)v16);
                                        state.baselineNeededFor(v16);
                                        v17 = targetReference;
                                        Intrinsics.checkNotNull((Object)v17);
                                        reference.baselineToBottom(v17);
lbl211:
                                        // 6 sources

                                        break;
                                    }
                                    case 2: {
                                        isHorizontalConstraint = true;
                                        isHorOriginLeft = true;
                                        break;
                                    }
                                    case 8: {
                                        isHorizontalConstraint = true;
                                        isHorOriginLeft = false;
                                        break;
                                    }
                                    case 4: {
                                        isHorizontalConstraint = true;
                                        isHorOriginLeft = isLtr;
                                        break;
                                    }
                                    case 6: {
                                        isHorizontalConstraint = true;
                                        v18 = isHorOriginLeft = isLtr == false;
                                    }
                                }
                            }
                            if (!isHorizontalConstraint) break block109;
                            var16_19 = anchor;
                            if (var16_19 == null) break block110;
                            tmp = -1;
                            switch (var16_19.hashCode()) {
                                case 3317767: {
                                    if (var16_19.equals("left")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case 109757538: {
                                    if (var16_19.equals("start")) {
                                        tmp = 2;
                                    }
                                    break;
                                }
                                case 100571: {
                                    if (var16_19.equals("end")) {
                                        tmp = 3;
                                    }
                                    break;
                                }
                                case 108511772: {
                                    if (var16_19.equals("right")) {
                                        tmp = 4;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    isHorTargetLeft = true;
                                    break;
                                }
                                case 4: {
                                    isHorTargetLeft = false;
                                    break;
                                }
                                case 2: {
                                    isHorTargetLeft = isLtr;
                                    break;
                                }
                                case 3: {
                                    v19 = isHorTargetLeft = isLtr == false;
                                }
                            }
                        }
                        if (isHorOriginLeft) {
                            if (isHorTargetLeft) {
                                v20 = targetReference;
                                Intrinsics.checkNotNull((Object)v20);
                                v21 = reference.leftToLeft(v20);
                            } else {
                                v22 = targetReference;
                                Intrinsics.checkNotNull((Object)v22);
                                v21 = reference.leftToRight(v22);
                            }
                        } else if (isHorTargetLeft) {
                            v23 = targetReference;
                            Intrinsics.checkNotNull((Object)v23);
                            v21 = reference.rightToLeft(v23);
                        } else {
                            v24 = targetReference;
                            Intrinsics.checkNotNull((Object)v24);
                            v21 = reference.rightToRight(v24);
                        }
                    }
                    reference.margin(Float.valueOf(margin)).marginGone(Float.valueOf(marginGone));
                    break block112;
                }
                target = element.getStringOrNull(constraintName);
                if (target == null) break block112;
                targetReference = Intrinsics.areEqual((Object)target, (Object)"parent") != false ? state.constraints(0) : state.constraints(target);
                var10_13 = constraintName;
                if (var10_13 == null) break block112;
                tmp = -1;
                switch (var10_13.hashCode()) {
                    case 115029: {
                        if (var10_13.equals("top")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -1383228885: {
                        if (var10_13.equals("bottom")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 109757538: {
                        if (var10_13.equals("start")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 100571: {
                        if (var10_13.equals("end")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -1720785339: {
                        if (var10_13.equals("baseline")) {
                            tmp = 5;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        if (isLtr) {
                            v25 = targetReference;
                            Intrinsics.checkNotNull((Object)v25);
                            v26 = reference.leftToLeft(v25);
                            break;
                        }
                        v27 = targetReference;
                        Intrinsics.checkNotNull((Object)v27);
                        v26 = reference.rightToRight(v27);
                        break;
                    }
                    case 4: {
                        if (isLtr) {
                            v28 = targetReference;
                            Intrinsics.checkNotNull((Object)v28);
                            v29 = reference.rightToRight(v28);
                            break;
                        }
                        v30 = targetReference;
                        Intrinsics.checkNotNull((Object)v30);
                        v29 = reference.leftToLeft(v30);
                        break;
                    }
                    case 1: {
                        v31 = targetReference;
                        Intrinsics.checkNotNull((Object)v31);
                        reference.topToTop(v31);
                        break;
                    }
                    case 2: {
                        v32 = targetReference;
                        Intrinsics.checkNotNull((Object)v32);
                        reference.bottomToBottom(v32);
                        break;
                    }
                    case 5: {
                        v33 = reference.getKey();
                        Intrinsics.checkNotNull((Object)v33);
                        state.baselineNeededFor(v33);
                        v34 = targetReference;
                        Intrinsics.checkNotNull((Object)v34);
                        v35 = v34.getKey();
                        Intrinsics.checkNotNull((Object)v35);
                        state.baselineNeededFor(v35);
                        reference.baselineToBaseline(targetReference);
                    }
                }
            }
        }

        @NotNull
        public final Dimension parseDimensionMode(@NotNull String dimensionString) {
            Intrinsics.checkNotNullParameter((Object)dimensionString, (String)"dimensionString");
            Dimension dimension = Dimension.Companion.createFixed(0);
            switch (dimensionString) {
                case "wrap": {
                    dimension = Dimension.Companion.createWrap();
                    break;
                }
                case "preferWrap": {
                    dimension = Dimension.Companion.createSuggested("WRAP_DIMENSION");
                    break;
                }
                case "spread": {
                    dimension = Dimension.Companion.createSuggested("SPREAD_DIMENSION");
                    break;
                }
                case "parent": {
                    dimension = Dimension.Companion.createParent();
                    break;
                }
                default: {
                    if (StringsKt.endsWith$default((String)dimensionString, (String)"%", (boolean)false, (int)2, null)) {
                        String string = dimensionString.substring(0, StringsKt.indexOf$default((CharSequence)dimensionString, (char)'%', (int)0, (boolean)false, (int)6, null));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String percentString = string;
                        float percentValue = Float.parseFloat(percentString) / 100.0f;
                        dimension = Dimension.Companion.createPercent(0, percentValue).suggested(0);
                        break;
                    }
                    if (!StringsKt.contains$default((CharSequence)dimensionString, (CharSequence)":", (boolean)false, (int)2, null)) break;
                    dimension = Dimension.Companion.createRatio(dimensionString).suggested("SPREAD_DIMENSION");
                }
            }
            return dimension;
        }

        @NotNull
        public final Dimension parseDimension(@NotNull CLObject element, @Nullable String constraintName, @NotNull State state, @NotNull CorePixelDp dpToPixels) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)dpToPixels, (String)"dpToPixels");
            String string = constraintName;
            Intrinsics.checkNotNull((Object)string);
            CLElement dimensionElement = element.get(string);
            Dimension dimension = Dimension.Companion.createFixed(0);
            if (dimensionElement instanceof CLString) {
                dimension = this.parseDimensionMode(dimensionElement.content());
            } else if (dimensionElement instanceof CLNumber) {
                dimension = Dimension.Companion.createFixed(state.convertDimension(Float.valueOf(dpToPixels.toPixels(element.getFloat(constraintName)))));
            } else if (dimensionElement instanceof CLObject) {
                CLElement maxEl;
                CLElement minEl;
                CLElement obj = dimensionElement;
                String mode = ((CLObject)obj).getStringOrNull("value");
                if (mode != null) {
                    dimension = this.parseDimensionMode(mode);
                }
                if ((minEl = ((CLObject)obj).getOrNull("min")) != null) {
                    if (minEl instanceof CLNumber) {
                        float min = ((CLNumber)minEl).getFloat();
                        dimension.min(state.convertDimension(Float.valueOf(dpToPixels.toPixels(min))));
                    } else if (minEl instanceof CLString) {
                        dimension.min("WRAP_DIMENSION");
                    }
                }
                if ((maxEl = ((CLObject)obj).getOrNull("max")) != null) {
                    if (maxEl instanceof CLNumber) {
                        float max = ((CLNumber)maxEl).getFloat();
                        dimension.max(state.convertDimension(Float.valueOf(dpToPixels.toPixels(max))));
                    } else if (maxEl instanceof CLString) {
                        dimension.max("WRAP_DIMENSION");
                    }
                }
            }
            return dimension;
        }

        public final long parseColorString(@NotNull String value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object str = value;
            if (StringsKt.startsWith$default((String)str, (String)"#", (boolean)false, (int)2, null)) {
                String string = ((String)str).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                str = string;
                if (((String)str).length() == 6) {
                    str = "FF" + (String)str;
                }
                l = Long.parseLong((String)str, CharsKt.checkRadix((int)16));
            } else {
                l = -1L;
            }
            return l;
        }

        @Nullable
        public final String lookForType(@NotNull CLObject element) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ArrayList<String> constraints = element.names();
            Iterator<String> iterator = constraints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String constraintName;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!Intrinsics.areEqual((Object)constraintName, (Object)"type")) continue;
                return element.getString("type");
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0017j\b\u0012\u0004\u0012\u00020\u0007`\u0018R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$Companion$FiniteGenerator;", "Landroidx/constraintlayout/core/state/ConstraintSetParser$GeneratedValue;", "from", "", "to", "step", "prefix", "", "postfix", "<init>", "(FFFLjava/lang/String;Ljava/lang/String;)V", "mFrom", "mTo", "mStep", "mStop", "", "mPrefix", "mPostfix", "mCurrent", "mInitial", "mMax", "value", "array", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "compose"})
        @StabilityInferred(parameters=0)
        public static final class FiniteGenerator
        implements GeneratedValue {
            private float mFrom;
            private float mTo;
            private float mStep;
            private boolean mStop;
            @NotNull
            private String mPrefix;
            @NotNull
            private String mPostfix;
            private float mCurrent;
            private float mInitial;
            private float mMax;
            public static final int $stable = 8;

            public FiniteGenerator(float from, float to, float step, @Nullable String prefix, @Nullable String postfix) {
                String string;
                this.mFrom = from;
                this.mTo = to;
                this.mStep = step;
                String string2 = prefix;
                if (string2 == null) {
                    string2 = this.mPrefix = "";
                }
                if ((string = postfix) == null) {
                    string = "";
                }
                this.mPostfix = string;
                this.mMax = to;
                this.mInitial = from;
            }

            @Override
            public float value() {
                if (this.mCurrent >= this.mMax) {
                    this.mStop = true;
                }
                if (!this.mStop) {
                    this.mCurrent += this.mStep;
                }
                return this.mCurrent;
            }

            @NotNull
            public final ArrayList<String> array() {
                ArrayList<String> array = new ArrayList<String>();
                int value = (int)this.mInitial;
                int i = value;
                int maxInt = (int)this.mMax;
                if (i <= maxInt) {
                    while (true) {
                        array.add(this.mPrefix + value + this.mPostfix);
                        value += (int)this.mStep;
                        if (i == maxInt) break;
                        ++i;
                    }
                }
                return array;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$Companion$OverrideValue;", "Landroidx/constraintlayout/core/state/ConstraintSetParser$GeneratedValue;", "value", "", "<init>", "(F)V", "mValue", "compose"})
        @StabilityInferred(parameters=0)
        public static final class OverrideValue
        implements GeneratedValue {
            private float mValue;
            public static final int $stable = 8;

            public OverrideValue(float value) {
                this.mValue = value;
            }

            @Override
            public float value() {
                return this.mValue;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\"\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$DesignElement;", "", "id", "", "type", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/HashMap;)V", "getId", "()Ljava/lang/String;", "getType", "getParams", "()Ljava/util/HashMap;", "compose"})
    @StabilityInferred(parameters=0)
    public static final class DesignElement {
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        @NotNull
        private final HashMap<String, String> params;
        public static final int $stable = 8;

        public DesignElement(@NotNull String id, @NotNull String type, @NotNull HashMap<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            this.id = id;
            this.type = type;
            this.params = params;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final HashMap<String, String> getParams() {
            return this.params;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$GeneratedValue;", "", "value", "", "compose"})
    public static interface GeneratedValue {
        public float value();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$Generator;", "Landroidx/constraintlayout/core/state/ConstraintSetParser$GeneratedValue;", "start", "", "incrementBy", "<init>", "(FF)V", "mStart", "getMStart", "()F", "setMStart", "(F)V", "mIncrementBy", "mCurrent", "mStop", "", "value", "compose"})
    @StabilityInferred(parameters=0)
    public static final class Generator
    implements GeneratedValue {
        private float mStart;
        private float mIncrementBy;
        private float mCurrent;
        private boolean mStop;
        public static final int $stable = 8;

        public Generator(float start, float incrementBy) {
            this.mStart = start;
            this.mIncrementBy = incrementBy;
            this.mCurrent = start;
        }

        public final float getMStart() {
            return this.mStart;
        }

        public final void setMStart(float f) {
            this.mStart = f;
        }

        @Override
        public float value() {
            if (!this.mStop) {
                this.mCurrent += this.mIncrementBy;
            }
            return this.mCurrent;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0007J \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0013J\u0011\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0001H\u0086\u0002J\"\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fj\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\r2\u0006\u0010\u0010\u001a\u00020\u0006J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\rR*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000RJ\u0010\u000b\u001a>\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\r0\u0005j\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\r`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$LayoutVariables;", "", "<init>", "()V", "mMargins", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "mGenerators", "Landroidx/constraintlayout/core/state/ConstraintSetParser$GeneratedValue;", "mArrayIds", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "put", "", "elementName", "element", "start", "", "incrementBy", "from", "to", "step", "prefix", "postfix", "putOverride", "value", "get", "getList", "elements", "compose"})
    @StabilityInferred(parameters=0)
    public static final class LayoutVariables {
        @NotNull
        private HashMap<String, Integer> mMargins = new HashMap();
        @NotNull
        private HashMap<String, GeneratedValue> mGenerators = new HashMap();
        @NotNull
        private HashMap<String, ArrayList<String>> mArrayIds = new HashMap();
        public static final int $stable = 8;

        public final void put(@Nullable String elementName, int element) {
            Integer n = element;
            Map map = this.mMargins;
            String string = elementName;
            Intrinsics.checkNotNull((Object)string);
            map.put(string, n);
        }

        public final void put(@Nullable String elementName, float start, float incrementBy) {
            if (((Map)this.mGenerators).containsKey(elementName) && ((Map)this.mGenerators).get(elementName) instanceof Companion.OverrideValue) {
                return;
            }
            Map map = this.mGenerators;
            String string = elementName;
            Intrinsics.checkNotNull((Object)string);
            map.put(string, new Generator(start, incrementBy));
        }

        public final void put(@NotNull String elementName, float from, float to, float step, @Nullable String prefix, @Nullable String postfix) {
            Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
            if (this.mGenerators.containsKey(elementName) && this.mGenerators.get(elementName) instanceof Companion.OverrideValue) {
                return;
            }
            Companion.FiniteGenerator generator = new Companion.FiniteGenerator(from, to, step, prefix, postfix);
            ((Map)this.mGenerators).put(elementName, generator);
            ((Map)this.mArrayIds).put(elementName, generator.array());
        }

        public final void putOverride(@NotNull String elementName, float value) {
            Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
            GeneratedValue generator = new Companion.OverrideValue(value);
            ((Map)this.mGenerators).put(elementName, generator);
        }

        public final float get(@NotNull Object elementName) {
            Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
            if (elementName instanceof CLString) {
                String stringValue = ((CLString)elementName).content();
                if (this.mGenerators.containsKey(stringValue)) {
                    GeneratedValue generatedValue = this.mGenerators.get(stringValue);
                    Intrinsics.checkNotNull((Object)generatedValue);
                    return generatedValue.value();
                }
                if (this.mMargins.containsKey(stringValue)) {
                    Integer n = this.mMargins.get(stringValue);
                    Intrinsics.checkNotNull((Object)n);
                    return ((Number)n).intValue();
                }
            } else if (elementName instanceof CLNumber) {
                return ((CLNumber)elementName).getFloat();
            }
            return 0.0f;
        }

        @Nullable
        public final ArrayList<String> getList(@NotNull String elementName) {
            Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
            return this.mArrayIds.containsKey(elementName) ? this.mArrayIds.get(elementName) : null;
        }

        public final void put(@NotNull String elementName, @NotNull ArrayList<String> elements) {
            Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            ((Map)this.mArrayIds).put(elementName, elements);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/state/ConstraintSetParser$MotionLayoutDebugFlags;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SHOW_ALL", "UNKNOWN", "compose"})
    public static final class MotionLayoutDebugFlags
    extends Enum<MotionLayoutDebugFlags> {
        public static final /* enum */ MotionLayoutDebugFlags NONE = new MotionLayoutDebugFlags();
        public static final /* enum */ MotionLayoutDebugFlags SHOW_ALL = new MotionLayoutDebugFlags();
        public static final /* enum */ MotionLayoutDebugFlags UNKNOWN = new MotionLayoutDebugFlags();
        private static final /* synthetic */ MotionLayoutDebugFlags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MotionLayoutDebugFlags[] values() {
            return (MotionLayoutDebugFlags[])$VALUES.clone();
        }

        public static MotionLayoutDebugFlags valueOf(String value) {
            return Enum.valueOf(MotionLayoutDebugFlags.class, value);
        }

        @NotNull
        public static EnumEntries<MotionLayoutDebugFlags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = motionLayoutDebugFlagsArray = new MotionLayoutDebugFlags[]{MotionLayoutDebugFlags.NONE, MotionLayoutDebugFlags.SHOW_ALL, MotionLayoutDebugFlags.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

