/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.parser.CLToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 62\u00020\u0001:\u00016B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00130\tj\b\u0012\u0004\u0012\u00020\u0013`\nJ\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0001J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0006\u0010 \u001a\u00020\u0010J\u0011\u0010!\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013J\u0012\u0010*\u001a\u0004\u0018\u00010\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0012\u0010+\u001a\u0004\u0018\u00010'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0012\u0010,\u001a\u0004\u0018\u00010%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u000e\u0010-\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u0013J\u0012\u0010.\u001a\u0004\u0018\u00010\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0010\u0010/\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0011\u0010!\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0015H\u0086\u0002J\u000e\u0010\"\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020%2\u0006\u00100\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0015J\u000e\u0010)\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0015J\u0010\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u00100\u001a\u00020\u0015J\u0010\u0010.\u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u00020\u0015J\b\u00101\u001a\u00020\u0000H\u0016J\u0013\u00102\u001a\u00020\u00182\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u00020\u0015H\u0016R*\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00010\tj\b\u0012\u0004\u0012\u00020\u0001`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00067"}, d2={"Landroidx/constraintlayout/core/parser/CLContainer;", "Landroidx/constraintlayout/core/parser/CLElement;", "content", "", "<init>", "([C)V", "clContainer", "(Landroidx/constraintlayout/core/parser/CLContainer;)V", "mElements", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMElements", "()Ljava/util/ArrayList;", "setMElements", "(Ljava/util/ArrayList;)V", "add", "", "element", "toString", "", "size", "", "names", "has", "", "name", "put", "value", "putNumber", "", "putString", "remove", "clear", "get", "getInt", "getFloat", "getArray", "Landroidx/constraintlayout/core/parser/CLArray;", "getObject", "Landroidx/constraintlayout/core/parser/CLObject;", "getString", "getBoolean", "getOrNull", "getObjectOrNull", "getArrayOrNull", "getArrayOrCreate", "getStringOrNull", "getFloatOrNaN", "index", "clone", "equals", "other", "", "hashCode", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class CLContainer
extends CLElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<CLElement> mElements;
    public static final int $stable = 8;

    @NotNull
    public final ArrayList<CLElement> getMElements() {
        return this.mElements;
    }

    public final void setMElements(@NotNull ArrayList<CLElement> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mElements = arrayList;
    }

    public CLContainer(@NotNull char[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        super(content);
        this.mElements = new ArrayList();
    }

    public CLContainer(@NotNull CLContainer clContainer) {
        Intrinsics.checkNotNullParameter((Object)clContainer, (String)"clContainer");
        super(clContainer);
        this.mElements = new ArrayList();
        ArrayList<CLElement> clonedArray = new ArrayList<CLElement>(clContainer.mElements.size());
        Iterator<CLElement> iterator = clContainer.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            CLElement elementClone = element.clone();
            elementClone.setContainer(this);
            clonedArray.add(elementClone);
        }
        this.mElements = clonedArray;
    }

    public final void add(@NotNull CLElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.mElements.add(element);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder list = new StringBuilder();
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (((CharSequence)list).length() > 0) {
                list.append("; ");
            }
            list.append(element);
        }
        return super.toString() + " = <" + list + " >";
    }

    public final int size() {
        return this.mElements.size();
    }

    @NotNull
    public final ArrayList<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!(element instanceof CLKey)) continue;
            CLKey key = (CLKey)element;
            names.add(key.content());
        }
        return names;
    }

    public final boolean has(@Nullable String name) {
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLKey key;
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!(element instanceof CLKey) || !Intrinsics.areEqual((Object)(key = (CLKey)element).content(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    public final void put(@NotNull String name, @NotNull CLElement value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            CLKey key = (CLKey)element;
            if (!Intrinsics.areEqual((Object)key.content(), (Object)name)) continue;
            key.set(value);
            return;
        }
        CLElement cLElement = CLKey.Companion.allocate(name, value);
        Intrinsics.checkNotNull((Object)cLElement, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.parser.CLKey");
        CLKey key = (CLKey)cLElement;
        this.mElements.add(key);
    }

    public final void putNumber(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.put(name, new CLNumber(value));
    }

    public final void putString(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = value.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        CLElement stringElement = new CLString(cArray);
        stringElement.setStart(0L);
        stringElement.setEnd(value.length() - 1);
        this.put(name, stringElement);
    }

    public final void remove(@Nullable String name) {
        CLElement element;
        ArrayList<CLElement> toRemove = new ArrayList<CLElement>();
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            CLKey key = (CLKey)element;
            if (!Intrinsics.areEqual((Object)key.content(), (Object)name)) continue;
            toRemove.add(element);
        }
        Iterator iterator3 = toRemove.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            this.mElements.remove(element);
        }
    }

    public final void clear() {
        this.mElements.clear();
    }

    @NotNull
    public final CLElement get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            CLKey key = (CLKey)element;
            if (!Intrinsics.areEqual((Object)key.content(), (Object)name)) continue;
            return key.getValue();
        }
        throw new CLParsingException("no element for key <" + name + ">", this);
    }

    public final int getInt(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        return element.getInt();
    }

    public final float getFloat(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        return element.getFloat();
    }

    @NotNull
    public final CLArray getArray(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        if (element instanceof CLArray) {
            return (CLArray)element;
        }
        throw new CLParsingException("no array found for key <" + name + ">, found [" + element.getStrClass() + "] : " + element, this);
    }

    @NotNull
    public final CLObject getObject(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        if (element instanceof CLObject) {
            return (CLObject)element;
        }
        throw new CLParsingException("no object found for key <" + name + ">, found [" + element.getStrClass() + "] : " + element, this);
    }

    @NotNull
    public final String getString(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        if (element instanceof CLString) {
            return element.content();
        }
        String strClass = element.getStrClass();
        throw new CLParsingException("no string found for key <" + name + ">, found [" + strClass + "] : " + element, this);
    }

    public final boolean getBoolean(@NotNull String name) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLElement element = this.get(name);
        if (element instanceof CLToken) {
            return ((CLToken)element).getBoolean();
        }
        throw new CLParsingException("no boolean found for key <" + name + ">, found [" + element.getStrClass() + "] : " + element, this);
    }

    @Nullable
    public final CLElement getOrNull(@Nullable String name) {
        Iterator<CLElement> iterator = this.mElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<CLElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CLElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            CLKey key = (CLKey)element;
            if (!Intrinsics.areEqual((Object)key.content(), (Object)name)) continue;
            return key.getValue();
        }
        return null;
    }

    @Nullable
    public final CLObject getObjectOrNull(@Nullable String name) {
        CLElement element = this.getOrNull(name);
        return element instanceof CLObject ? (CLObject)element : null;
    }

    @Nullable
    public final CLArray getArrayOrNull(@Nullable String name) {
        CLElement element = this.getOrNull(name);
        return element instanceof CLArray ? (CLArray)element : null;
    }

    @NotNull
    public final CLArray getArrayOrCreate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CLArray array = this.getArrayOrNull(name);
        if (array != null) {
            return array;
        }
        array = new CLArray(new char[0]);
        this.put(name, array);
        return array;
    }

    @Nullable
    public final String getStringOrNull(@Nullable String name) {
        String string;
        CLElement element;
        CLElement cLElement = element = this.getOrNull(name);
        if (cLElement == null ? true : cLElement instanceof CLString) {
            CLString cLString = (CLString)element;
            string = cLString != null ? cLString.content() : null;
        } else {
            string = null;
        }
        return string;
    }

    public final float getFloatOrNaN(@Nullable String name) {
        CLElement element = this.getOrNull(name);
        return element instanceof CLNumber ? ((CLNumber)element).getFloat() : Float.NaN;
    }

    @NotNull
    public final CLElement get(int index) throws CLParsingException {
        if (index >= 0 && index < this.mElements.size()) {
            CLElement cLElement = this.mElements.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)cLElement, (String)"get(...)");
            return cLElement;
        }
        throw new CLParsingException("no element at index " + index, this);
    }

    public final int getInt(int index) throws CLParsingException {
        CLElement element = this.get(index);
        return element.getInt();
    }

    public final float getFloat(int index) throws CLParsingException {
        CLElement element = this.get(index);
        return element.getFloat();
    }

    @NotNull
    public final CLArray getArray(int index) throws CLParsingException {
        CLElement element = this.get(index);
        if (element instanceof CLArray) {
            return (CLArray)element;
        }
        throw new CLParsingException("no array at index " + index, this);
    }

    @NotNull
    public final CLObject getObject(int index) throws CLParsingException {
        CLElement element = this.get(index);
        if (element instanceof CLObject) {
            return (CLObject)element;
        }
        throw new CLParsingException("no object at index " + index, this);
    }

    @NotNull
    public final String getString(int index) throws CLParsingException {
        CLElement element = this.get(index);
        if (element instanceof CLString) {
            return element.content();
        }
        throw new CLParsingException("no string at index " + index, this);
    }

    public final boolean getBoolean(int index) throws CLParsingException {
        CLElement element = this.get(index);
        if (element instanceof CLToken) {
            return ((CLToken)element).getBoolean();
        }
        throw new CLParsingException("no boolean at index " + index, this);
    }

    @Nullable
    public final CLElement getOrNull(int index) {
        return index >= 0 && index < this.mElements.size() ? this.mElements.get(index) : null;
    }

    @Nullable
    public final String getStringOrNull(int index) {
        CLElement element = this.getOrNull(index);
        return element instanceof CLString ? ((CLString)element).content() : null;
    }

    @Override
    @NotNull
    public CLContainer clone() {
        return new CLContainer(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return !(other instanceof CLContainer) ? false : Intrinsics.areEqual(this.mElements, ((CLContainer)other).mElements);
    }

    @Override
    public int hashCode() {
        Serializable[] serializableArray = new Serializable[]{this.mElements, Integer.valueOf(super.hashCode())};
        return serializableArray.hashCode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/parser/CLContainer$Companion;", "", "<init>", "()V", "allocate", "Landroidx/constraintlayout/core/parser/CLElement;", "content", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CLElement allocate(@NotNull char[] content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new CLContainer(content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

