/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.StopEngine;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aJF\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0018J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0006\u0010+\u001a\u00020\u0012J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0003R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010-R\u0014\u0010.\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00063"}, d2={"Landroidx/constraintlayout/core/motion/utils/SpringStopEngine;", "Landroidx/constraintlayout/core/motion/utils/StopEngine;", "<init>", "()V", "mDamping", "", "getMDamping", "()D", "setMDamping", "(D)V", "mInitialized", "", "getMInitialized$annotations", "mStiffness", "mTargetPos", "mLastVelocity", "getMLastVelocity$annotations", "mLastTime", "", "mPos", "mV", "mMass", "mStopThreshold", "mBoundaryMode", "", "debug", "", "desc", "time", "log", "", "str", "springConfig", "currentPos", "target", "currentVelocity", "mass", "stiffness", "damping", "stopThreshold", "boundaryMode", "getVelocity", "getInterpolation", "getAcceleration", "velocity", "()F", "isStopped", "()Z", "compute", "dt", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class SpringStopEngine
implements StopEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double mDamping = 0.5;
    private boolean mInitialized;
    private double mStiffness;
    private double mTargetPos;
    private double mLastVelocity;
    private float mLastTime;
    private float mPos;
    private float mV;
    private float mMass;
    private float mStopThreshold;
    private int mBoundaryMode;
    private final float velocity;
    public static final int $stable = 8;
    private static final double UNSET = Double.MAX_VALUE;

    public final double getMDamping() {
        return this.mDamping;
    }

    public final void setMDamping(double d) {
        this.mDamping = d;
    }

    private static /* synthetic */ void getMInitialized$annotations() {
    }

    private static /* synthetic */ void getMLastVelocity$annotations() {
    }

    @Override
    @Nullable
    public String debug(@NotNull String desc, float time) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        return null;
    }

    public final void log(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String line = ExceptionsKt.stackTraceToString((Throwable)new Throwable());
        System.out.println((Object)(line + str));
    }

    public final void springConfig(float currentPos, float target, float currentVelocity, float mass, float stiffness, float damping, float stopThreshold, int boundaryMode) {
        this.mTargetPos = target;
        this.mDamping = damping;
        this.mInitialized = false;
        this.mPos = currentPos;
        this.mLastVelocity = currentVelocity;
        this.mStiffness = stiffness;
        this.mMass = mass;
        this.mStopThreshold = stopThreshold;
        this.mBoundaryMode = boundaryMode;
        this.mLastTime = 0.0f;
    }

    @Override
    public float getVelocity(float time) {
        return this.mV;
    }

    @Override
    public float getInterpolation(float time) {
        this.compute(time - this.mLastTime);
        this.mLastTime = time;
        if (this.isStopped()) {
            this.mPos = (float)this.mTargetPos;
        }
        return this.mPos;
    }

    public final float getAcceleration() {
        double k = this.mStiffness;
        double c = this.mDamping;
        double x = (double)this.mPos - this.mTargetPos;
        return (float)(-k * x - c * (double)this.mV) / this.mMass;
    }

    @Override
    public float getVelocity() {
        return this.velocity;
    }

    @Override
    public boolean isStopped() {
        double v = this.mV;
        double m = this.mMass;
        double k = this.mStiffness;
        double x = (double)this.mPos - this.mTargetPos;
        double energy = v * v * m + k * x * x;
        double max_def = Math.sqrt(energy / k);
        return max_def <= (double)this.mStopThreshold;
    }

    private final void compute(double dt) {
        double dt2 = dt;
        if (dt2 <= 0.0) {
            return;
        }
        double k = this.mStiffness;
        double c = this.mDamping;
        int overSample = (int)(1.0 + (double)9 / (Math.sqrt(this.mStiffness / (double)this.mMass) * dt2 * (double)4));
        dt2 /= (double)overSample;
        for (int i = 0; i < overSample; ++i) {
            double x = (double)this.mPos - this.mTargetPos;
            double a = (-k * x - c * (double)this.mV) / (double)this.mMass;
            double avgV = (double)this.mV + a * dt2 / (double)2;
            double avgX = (double)this.mPos + dt2 * avgV / (double)2 - this.mTargetPos;
            a = (-avgX * k - avgV * c) / (double)this.mMass;
            double dv = a * dt2;
            avgV = (double)this.mV + dv / (double)2;
            this.mV += (float)dv;
            this.mPos += (float)(avgV * dt2);
            if (this.mBoundaryMode <= 0) continue;
            if (this.mPos < 0.0f && (this.mBoundaryMode & 1) == 1) {
                this.mPos = -this.mPos;
                this.mV = -this.mV;
            }
            if (!(this.mPos > 1.0f) || (this.mBoundaryMode & 2) != 2) continue;
            this.mPos = (float)2 - this.mPos;
            this.mV = -this.mV;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/motion/utils/SpringStopEngine$Companion;", "", "<init>", "()V", "UNSET", "", "getUNSET$annotations", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getUNSET$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

