/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.DecimalKt;
import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.WidgetFrame;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\b'\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u001fH\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0017H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet;", "", "<init>", "()V", "mCurveFit", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "getMCurveFit", "()Landroidx/constraintlayout/core/motion/utils/CurveFit;", "setMCurveFit", "(Landroidx/constraintlayout/core/motion/utils/CurveFit;)V", "mTimePoints", "", "getMTimePoints", "()[I", "setMTimePoints", "([I)V", "mValues", "", "getMValues", "()[F", "setMValues", "([F)V", "mCount", "", "mType", "", "setProperty", "", "widget", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "t", "", "toString", "setType", "type", "get", "getSlope", "getCurveFit", "setPoint", "position", "value", "setup", "curveType", "CustomSpline", "Companion", "compose"})
@StabilityInferred(parameters=0)
public abstract class SplineSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CurveFit mCurveFit;
    @NotNull
    private int[] mTimePoints = new int[10];
    @NotNull
    private float[] mValues = new float[10];
    private int mCount;
    @Nullable
    private String mType;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "SplineSet";

    @Nullable
    protected final CurveFit getMCurveFit() {
        return this.mCurveFit;
    }

    protected final void setMCurveFit(@Nullable CurveFit curveFit) {
        this.mCurveFit = curveFit;
    }

    @NotNull
    protected final int[] getMTimePoints() {
        return this.mTimePoints;
    }

    protected final void setMTimePoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.mTimePoints = nArray;
    }

    @NotNull
    protected final float[] getMValues() {
        return this.mValues;
    }

    protected final void setMValues(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mValues = fArray;
    }

    public void setProperty(@NotNull TypedValues widget, float t) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        widget.setValue(TypedValues.AttributesType.Companion.getId(this.mType), this.get(t));
    }

    @NotNull
    public String toString() {
        String string = this.mType;
        Intrinsics.checkNotNull((Object)string);
        Object str = string;
        int n = this.mCount;
        for (int i = 0; i < n; ++i) {
            str = (String)str + "[" + this.mTimePoints[i] + " , " + DecimalKt.limitDecimals(Float.valueOf(this.mValues[i]), 2) + "] ";
        }
        return str;
    }

    public final void setType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.mType = type;
    }

    public final float get(float t) {
        CurveFit curveFit = this.mCurveFit;
        Intrinsics.checkNotNull((Object)curveFit);
        return (float)curveFit.getPos((double)t, 0);
    }

    public final float getSlope(float t) {
        CurveFit curveFit = this.mCurveFit;
        Intrinsics.checkNotNull((Object)curveFit);
        return (float)curveFit.getSlope((double)t, 0);
    }

    @NotNull
    public final CurveFit getCurveFit() {
        CurveFit curveFit = this.mCurveFit;
        Intrinsics.checkNotNull((Object)curveFit);
        return curveFit;
    }

    public void setPoint(int position, float value) {
        if (this.mTimePoints.length < this.mCount + 1) {
            int[] nArray = Arrays.copyOf(this.mTimePoints, this.mTimePoints.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.mTimePoints = nArray;
            float[] fArray = Arrays.copyOf(this.mValues, this.mValues.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.mValues = fArray;
        }
        this.mTimePoints[this.mCount] = position;
        this.mValues[this.mCount] = value;
        int n = this.mCount;
        this.mCount = n + 1;
    }

    public void setup(int curveType) {
        if (this.mCount == 0) {
            return;
        }
        Companion.Sort.INSTANCE.doubleQuickSort(this.mTimePoints, this.mValues, 0, this.mCount - 1);
        int unique = 1;
        int n = this.mCount;
        for (int i = 1; i < n; ++i) {
            if (this.mTimePoints[i - 1] == this.mTimePoints[i]) continue;
            ++unique;
        }
        double[] time = new double[unique];
        int n2 = 0;
        int n3 = unique;
        double[][] dArrayArray = new double[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            dArrayArray[n4] = new double[1];
        }
        double[][] values = dArrayArray;
        int k = 0;
        int n5 = this.mCount;
        for (int i = 0; i < n5; ++i) {
            if (i > 0 && this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            time[k] = (double)this.mTimePoints[i] * 0.01;
            values[k][0] = this.mValues[i];
            ++k;
        }
        this.mCurveFit = CurveFit.Companion.get(curveType, time, values);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet$Companion;", "", "<init>", "()V", "TAG", "", "makeCustomSpline", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "str", "attrList", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;", "makeCustomSplineSet", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;", "makeSpline", "currentTime", "", "Sort", "CustomSet", "CoreSpline", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SplineSet makeCustomSpline(@NotNull String str, @NotNull KeyFrameArray.CustomArray attrList) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
            return new CustomSet(str, attrList);
        }

        @NotNull
        public final SplineSet makeCustomSplineSet(@NotNull String str, @NotNull KeyFrameArray.CustomVar attrList) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
            return new CustomSpline(str, attrList);
        }

        @NotNull
        public final SplineSet makeSpline(@NotNull String str, long currentTime) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return new CoreSpline(str, currentTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet$Companion$CoreSpline;", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "mType", "", "mStart", "", "<init>", "(Ljava/lang/String;J)V", "getMType", "()Ljava/lang/String;", "setMType", "(Ljava/lang/String;)V", "getMStart", "()J", "setMStart", "(J)V", "setProperty", "", "widget", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "t", "", "compose"})
        private static final class CoreSpline
        extends SplineSet {
            @NotNull
            private String mType;
            private long mStart;

            public CoreSpline(@NotNull String mType, long mStart) {
                Intrinsics.checkNotNullParameter((Object)mType, (String)"mType");
                this.mType = mType;
                this.mStart = mStart;
            }

            @NotNull
            public final String getMType() {
                return this.mType;
            }

            public final void setMType(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.mType = string;
            }

            public final long getMStart() {
                return this.mStart;
            }

            public final void setMStart(long l) {
                this.mStart = l;
            }

            @Override
            public void setProperty(@NotNull TypedValues widget, float t) {
                Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
                int id = widget.getId(this.mType);
                widget.setValue(id, this.get(t));
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet$Companion$CustomSet;", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "attribute", "", "attrList", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;", "<init>", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;)V", "mAttributeName", "getMAttributeName", "()Ljava/lang/String;", "setMAttributeName", "(Ljava/lang/String;)V", "mConstraintAttributeList", "getMConstraintAttributeList", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;", "setMConstraintAttributeList", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;)V", "mTempValues", "", "getMTempValues", "()[F", "setMTempValues", "([F)V", "setup", "", "curveType", "", "setPoint", "position", "value", "", "Landroidx/constraintlayout/core/motion/CustomAttribute;", "setProperty", "view", "Landroidx/constraintlayout/core/state/WidgetFrame;", "t", "compose"})
        @StabilityInferred(parameters=0)
        public static final class CustomSet
        extends SplineSet {
            @NotNull
            private String mAttributeName;
            @NotNull
            private KeyFrameArray.CustomArray mConstraintAttributeList;
            @Nullable
            private float[] mTempValues;
            public static final int $stable = 8;

            @NotNull
            public final String getMAttributeName() {
                return this.mAttributeName;
            }

            public final void setMAttributeName(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.mAttributeName = string;
            }

            @NotNull
            public final KeyFrameArray.CustomArray getMConstraintAttributeList() {
                return this.mConstraintAttributeList;
            }

            public final void setMConstraintAttributeList(@NotNull KeyFrameArray.CustomArray customArray) {
                Intrinsics.checkNotNullParameter((Object)customArray, (String)"<set-?>");
                this.mConstraintAttributeList = customArray;
            }

            @Nullable
            public final float[] getMTempValues() {
                return this.mTempValues;
            }

            public final void setMTempValues(@Nullable float[] fArray) {
                this.mTempValues = fArray;
            }

            public CustomSet(@NotNull String attribute, @NotNull KeyFrameArray.CustomArray attrList) {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
                String[] stringArray = new String[]{","};
                this.mAttributeName = (String)StringsKt.split$default((CharSequence)attribute, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                this.mConstraintAttributeList = attrList;
            }

            @Override
            public void setup(int curveType) {
                int size = this.mConstraintAttributeList.size();
                CustomAttribute customAttribute = this.mConstraintAttributeList.valueAt(0);
                Intrinsics.checkNotNull((Object)customAttribute);
                int dimensionality = customAttribute.numberOfInterpolatedValues();
                double[] time = new double[size];
                this.mTempValues = new float[dimensionality];
                int n = 0;
                double[][] dArrayArray = new double[size][];
                while (n < size) {
                    int n2 = n++;
                    dArrayArray[n2] = new double[dimensionality];
                }
                double[][] values = dArrayArray;
                for (int i = 0; i < size; ++i) {
                    CustomAttribute ca;
                    int key = this.mConstraintAttributeList.keyAt(i);
                    Intrinsics.checkNotNull((Object)this.mConstraintAttributeList.valueAt(i));
                    time[i] = (double)key * 0.01;
                    Intrinsics.checkNotNull((Object)this.mTempValues);
                    ca.getValuesToInterpolate(this.mTempValues);
                    Intrinsics.checkNotNull((Object)this.mTempValues);
                    int n3 = this.mTempValues.length;
                    for (int k = 0; k < n3; ++k) {
                        double[] dArray = values[i];
                        Intrinsics.checkNotNull((Object)this.mTempValues);
                        dArray[k] = this.mTempValues[k];
                    }
                }
                this.setMCurveFit(CurveFit.Companion.get(curveType, time, values));
            }

            @Override
            public void setPoint(int position, float value) {
                throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
            }

            public final void setPoint(int position, @NotNull CustomAttribute value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.mConstraintAttributeList.append(position, value);
            }

            public final void setProperty(@NotNull WidgetFrame view, float t) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                CurveFit curveFit = this.getMCurveFit();
                Intrinsics.checkNotNull((Object)curveFit);
                double d = t;
                Intrinsics.checkNotNull((Object)this.mTempValues);
                curveFit.getPos(d, this.mTempValues);
                view.setCustomValue(this.mConstraintAttributeList.valueAt(0), this.mTempValues);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ(\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet$Companion$Sort;", "", "<init>", "()V", "doubleQuickSort", "", "key", "", "value", "", "low", "", "hi", "partition", "array", "swap", "a", "b", "compose"})
        private static final class Sort {
            @NotNull
            public static final Sort INSTANCE = new Sort();

            private Sort() {
            }

            public final void doubleQuickSort(@NotNull int[] key, @NotNull float[] value, int low, int hi) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                int low2 = low;
                int hi2 = hi;
                int[] stack = new int[key.length + 10];
                int count = 0;
                stack[count++] = hi2;
                stack[count++] = low2;
                while (count > 0) {
                    --count;
                    low2 = stack[count];
                    if (low2 >= (hi2 = stack[--count])) continue;
                    int p = this.partition(key, value, low2, hi2);
                    stack[count++] = p - 1;
                    stack[count++] = low2;
                    stack[count++] = hi2;
                    stack[count++] = p + 1;
                }
            }

            private final int partition(int[] array, float[] value, int low, int hi) {
                int pivot = array[hi];
                int i = low;
                for (int j = low; j < hi; ++j) {
                    if (array[j] > pivot) continue;
                    this.swap(array, value, i, j);
                    ++i;
                }
                this.swap(array, value, i, hi);
                return i;
            }

            private final void swap(int[] array, float[] value, int a, int b) {
                int tmp = array[a];
                array[a] = array[b];
                array[b] = tmp;
                float tmpv = value[a];
                value[a] = value[b];
                value[b] = tmpv;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010$J\u0016\u0010 \u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u001fR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Landroidx/constraintlayout/core/motion/utils/SplineSet$CustomSpline;", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "attribute", "", "attrList", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;", "<init>", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;)V", "mAttributeName", "getMAttributeName", "()Ljava/lang/String;", "setMAttributeName", "(Ljava/lang/String;)V", "mConstraintAttributeList", "getMConstraintAttributeList", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;", "setMConstraintAttributeList", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;)V", "mTempValues", "", "getMTempValues", "()[F", "setMTempValues", "([F)V", "setup", "", "curveType", "", "setPoint", "position", "value", "", "setProperty", "widget", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "t", "Landroidx/constraintlayout/core/motion/CustomVariable;", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "compose"})
    @StabilityInferred(parameters=0)
    public static final class CustomSpline
    extends SplineSet {
        @NotNull
        private String mAttributeName;
        @NotNull
        private KeyFrameArray.CustomVar mConstraintAttributeList;
        @Nullable
        private float[] mTempValues;
        public static final int $stable = 8;

        @NotNull
        public final String getMAttributeName() {
            return this.mAttributeName;
        }

        public final void setMAttributeName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mAttributeName = string;
        }

        @NotNull
        public final KeyFrameArray.CustomVar getMConstraintAttributeList() {
            return this.mConstraintAttributeList;
        }

        public final void setMConstraintAttributeList(@NotNull KeyFrameArray.CustomVar customVar) {
            Intrinsics.checkNotNullParameter((Object)customVar, (String)"<set-?>");
            this.mConstraintAttributeList = customVar;
        }

        @Nullable
        public final float[] getMTempValues() {
            return this.mTempValues;
        }

        public final void setMTempValues(@Nullable float[] fArray) {
            this.mTempValues = fArray;
        }

        public CustomSpline(@NotNull String attribute, @NotNull KeyFrameArray.CustomVar attrList) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
            String[] stringArray = new String[]{","};
            this.mAttributeName = (String)StringsKt.split$default((CharSequence)attribute, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality];
            int n = 0;
            double[][] dArrayArray = new double[size][];
            while (n < size) {
                int n2 = n++;
                dArrayArray[n2] = new double[dimensionality];
            }
            double[][] values = dArrayArray;
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                CustomVariable ca = this.mConstraintAttributeList.valueAt(i);
                time[i] = (double)key * 0.01;
                Intrinsics.checkNotNull((Object)this.mTempValues);
                ca.getValuesToInterpolate(this.mTempValues);
                Intrinsics.checkNotNull((Object)this.mTempValues);
                int n3 = this.mTempValues.length;
                for (int k = 0; k < n3; ++k) {
                    double[] dArray = values[i];
                    Intrinsics.checkNotNull((Object)this.mTempValues);
                    dArray[k] = this.mTempValues[k];
                }
            }
            this.setMCurveFit(CurveFit.Companion.get(curveType, time, values));
        }

        @Override
        public void setPoint(int position, float value) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        @Override
        public void setProperty(@NotNull TypedValues widget, float t) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            this.setProperty((MotionWidget)widget, t);
        }

        public final void setPoint(int position, @Nullable CustomVariable value) {
            this.mConstraintAttributeList.append(position, value);
        }

        public final void setProperty(@NotNull MotionWidget view, float t) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            CurveFit curveFit = this.getMCurveFit();
            Intrinsics.checkNotNull((Object)curveFit);
            double d = t;
            Intrinsics.checkNotNull((Object)this.mTempValues);
            curveFit.getPos(d, this.mTempValues);
            CustomVariable customVariable = this.mConstraintAttributeList.valueAt(0);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            customVariable.setInterpolatedValue(view, this.mTempValues);
        }
    }
}

